/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.unit;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import org.junit.Test;

/**
 * {@link BidAndOfferPriceUnits} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class BidAndOfferPriceUnitsTest {

	@Test
	public void testBidAndOfferPriceUnits() {
		// Act
		final BidAndOfferPriceUnits bo = new BidAndOfferPriceUnits();
		// Assert
		assertThat(bo.units.size(), is(9));
		assertThat(bo.units.get( 0).getPrice(), is(30000000));
		assertThat(bo.units.get( 1).getPrice(), is(20000000));
		assertThat(bo.units.get( 2).getPrice(), is( 1000000));
		assertThat(bo.units.get( 3).getPrice(), is(  100000));
		assertThat(bo.units.get( 4).getPrice(), is(   50000));
		assertThat(bo.units.get( 5).getPrice(), is(   30000));
		assertThat(bo.units.get( 6).getPrice(), is(    3000));
		assertThat(bo.units.get( 7).getPrice(), is(    2000));
		assertThat(bo.units.get( 8).getPrice(), is(       1));
		assertThat(bo.units.get( 0).getPoint(), is(100000D));
		assertThat(bo.units.get( 1).getPoint(), is( 50000D));
		assertThat(bo.units.get( 2).getPoint(), is( 10000D));
		assertThat(bo.units.get( 3).getPoint(), is(  1000D));
		assertThat(bo.units.get( 4).getPoint(), is(   100D));
		assertThat(bo.units.get( 5).getPoint(), is(    50D));
		assertThat(bo.units.get( 6).getPoint(), is(    10D));
		assertThat(bo.units.get( 7).getPoint(), is(     5D));
		assertThat(bo.units.get( 8).getPoint(), is(     1D));
	}

	@Test
	public void testAdd() {
		// Arrange
		final BidAndOfferPriceUnits bo = new BidAndOfferPriceUnits();
		// Act
		bo.add(new PriceUnit(0, 0D));
		bo.add(new PriceUnit(40000000, 200000D));
		// Assert
		assertThat(bo.units.size(), is(11));
		assertThat(bo.units.get( 0).getPrice(), is(40000000));
		assertThat(bo.units.get( 0).getPoint(), is( 200000D));
		assertThat(bo.units.get(10).getPrice(), is(       0));
		assertThat(bo.units.get(10).getPoint(), is(      0D));
	}

	@Test
	public void testGetCeilingUnitUnit() {
		// Arrange
		final BidAndOfferPriceUnits bo = new BidAndOfferPriceUnits();
		// Act + Assert
		assertThat(bo.getCeilingPriceUnit(new PriceUnit(       0, 0D)).getPrice(), is(       1));
		assertThat(bo.getCeilingPriceUnit(new PriceUnit(       1, 0D)).getPrice(), is(       1));
		assertThat(bo.getCeilingPriceUnit(new PriceUnit(     100, 0D)).getPrice(), is(       1));
		assertThat(bo.getCeilingPriceUnit(new PriceUnit(    2000, 0D)).getPrice(), is(    2000));
		assertThat(bo.getCeilingPriceUnit(new PriceUnit(    2500, 0D)).getPrice(), is(    2000));
		assertThat(bo.getCeilingPriceUnit(new PriceUnit(30000000, 0D)).getPrice(), is(30000000));
		assertThat(bo.getCeilingPriceUnit(new PriceUnit(50000000, 0D)).getPrice(), is(30000000));
	}

	@Test
	public void testGetCeilingUnitInt() {
		// Arrange
		final BidAndOfferPriceUnits bo = new BidAndOfferPriceUnits();
		// Act + Assert
		assertThat(bo.getCeilingPriceUnit(       0).getPrice(), is(       1));
		assertThat(bo.getCeilingPriceUnit(       1).getPrice(), is(       1));
		assertThat(bo.getCeilingPriceUnit(     100).getPrice(), is(       1));
		assertThat(bo.getCeilingPriceUnit(    2000).getPrice(), is(    2000));
		assertThat(bo.getCeilingPriceUnit(    2500).getPrice(), is(    2000));
		assertThat(bo.getCeilingPriceUnit(30000000).getPrice(), is(30000000));
		assertThat(bo.getCeilingPriceUnit(50000000).getPrice(), is(30000000));
	}

}
