/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui.screen;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.ChartScreenEvent;
import jp.sf.orangesignal.chart.ui.UpDownColorType;
import jp.sf.orangesignal.chart.util.StringManager;

/**
 * その他タブの画面を提供します。
 * 
 * @author 杉澤 浩二
 */
public class Option extends SideScreen {

	private static final long serialVersionUID = 6190318641285237226L;

	private final JCheckBox split = new JCheckBox(StringManager.getString("split"));
	private final JCheckBox trace = new JCheckBox(StringManager.getString("trace"));

	private final JComboBox barColor = new JComboBox(UpDownColorType.values());
	private final JComboBox lineColor = new JComboBox(new UpDownColorType[]{ UpDownColorType.GREEN_RED, UpDownColorType.RED_BLUE });

	public final JCheckBox advancedOptions = new JCheckBox(StringManager.getString("option.all"));

	// ----------------------------------------

	/**
	 * デフォルトコンストラクタです。
	 */
	public Option() {
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		setLayout(layout);
		int y = 0;

		addCheckBox(layout, c, y++, this.split);
//		this.split.setVisible(false);
		addCheckBox(layout, c, y++, this.trace);

		// [陰陽線の色]
		addSeparator(layout, c, y++);
		addLabel(layout, c, y++, new JLabel(StringManager.getString("label.color")));
		addComboBox(layout, c, y++, new JLabel(StringManager.getString("color.bar")), this.barColor);
		addComboBox(layout, c, y++, new JLabel(StringManager.getString("color.line")), this.lineColor);

		addSeparator(layout, c, y++);
		addCheckBox(layout, c, y++, this.advancedOptions);

		addLastSpace(layout, c, y);
	}

	// ------------------------------------------------------------

	/**
	 * 各コントロールの状態を指定された設定情報へ設定します。
	 * 
	 * @param s 設定情報
	 */
	@Override
	public void save(final ChartSettings s) {
		s.split = this.split.isSelected();
		s.trace = this.trace.isSelected();
		s.updownBarColors = (UpDownColorType) this.barColor.getSelectedItem();
		s.updownLineColors = (UpDownColorType) this.lineColor.getSelectedItem();
		s.advancedOptions = this.advancedOptions.isSelected();
	}

	@Override
	public void load(final ChartSettings s) {
		this.split.setSelected(s.split);
		this.trace.setSelected(s.trace);
		this.barColor.setSelectedItem(s.updownBarColors);
		this.lineColor.setSelectedItem(s.updownLineColors);
		this.advancedOptions.setSelected(s.advancedOptions);
	}

	@Override
	public void datasetSwitch(final ChartEvent e) {
		super.notify = false;
		final boolean enabled = e.getDataset() != null;

		this.split.setEnabled(enabled);
		this.trace.setEnabled(enabled);
		this.barColor.setEnabled(enabled);
		this.lineColor.setEnabled(enabled);
		this.advancedOptions.setEnabled(enabled);

		if (enabled)
			load(e.getSettings());

		super.notify = true;
	}

	/**
	 * この実装は何も行いません。
	 */
	@Override public void periodSwitch(final ChartEvent e) {}

	/**
	 * この実装は何も行いません。
	 */
	@Override public void settingChanged(final ChartEvent e) {}

	/**
	 * この実装は何も行いません。
	 */
	@Override public void positionChanged(final ChartScreenEvent e) {}

}
