/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui;

import jp.sf.orangesignal.chart.util.StringManager;

/**
 * 価格チャートの種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum PriceChartType {

	/**
	 * 止め足(終値線)を表します。
	 */
	LINE { @Override public String toString() { return StringManager.getString("chart.line"); } },

	/**
	 * OHLC バーを表します。
	 */
	BAR { @Override public String toString() { return StringManager.getString("chart.bar"); } },

	/**
	 * 棒足を表します。
	 */
	BOH { @Override public String toString() { return StringManager.getString("chart.boh"); } },

	/**
	 * ローソク足を表します。
	 */
	CANDLESTICK { @Override public String toString() { return StringManager.getString("chart.candle"); } },

	/**
	 * 平均足を表します。
	 */
	HEIKIN { @Override public String toString() { return StringManager.getString("chart.heikin"); } };

}
