/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui;

import jp.sf.orangesignal.chart.util.StringManager;

/**
 * バンド系テクニカル指標の種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum BandType {

	/**
	 * (なし)を表します。
	 */
	NONE {
		@Override public String getLabel() { return StringManager.getString("band.none"); }
		@Override public String toString() { return getLabel(); }
	},

	/**
	 * ボリンジャーバンドを表します。
	 */
	BOLLINGER_BANDS {
		@Override public String getLabel() { return StringManager.getString("band.bb"); }
		@Override public String toString() { return getLabel() + StringManager.getString("marker.signal.mark"); }
	},

	/**
	 * ドンチャンズを表します。
	 */
	DONCHIAN {
		@Override public String getLabel() { return StringManager.getString("band.donchian"); }
		@Override public String toString() { return getLabel() + StringManager.getString("marker.signal.mark"); }
	},

	/**
	 * エンベロープを表します。
	 */
	ENVELOPE {
		@Override public String getLabel() { return StringManager.getString("band.envelope"); }
		@Override public String toString() { return getLabel() + StringManager.getString("marker.signal.mark"); }
	},

	/**
	 * チャネルシステムを表します。
	 */
	HIGH_LOW_MOVING_AVERAGE {
		@Override public String getLabel() { return StringManager.getString("band.hlma"); }
		@Override public String toString() { return getLabel() + StringManager.getString("marker.signal.mark"); }
	},

	/**
	 * 一目均衡表を表します。
	 */
	ICHIMOKU {
		@Override public String getLabel() { return StringManager.getString("band.ichimoku"); }
		@Override public String toString() { return getLabel(); }
	},

	/**
	 * パラボリック・タイム/プライスを表します。
	 */
	PARABOLIC_TIME_PRICE {
		@Override public String getLabel() { return StringManager.getString("band.parabolic"); }
		@Override public String toString() { return getLabel(); }
	},

	/**
	 * ピボットを表します。
	 */
	PIVOT {
		@Override public String getLabel() { return StringManager.getString("band.pivot"); }
		@Override public String toString() { return getLabel(); }
	},

	/**
	 * ボラティリティ・システムを表します。
	 */
	VIX {
		@Override public String getLabel() { return StringManager.getString("band.vix"); }
		@Override public String toString() { return getLabel() + StringManager.getString("marker.signal.mark"); }
	},

	/**
	 * MESA 適応移動平均を表します。
	 */
	MESA {
		@Override public String getLabel() { return StringManager.getString("band.mesa"); }
		@Override public String toString() { return getLabel() + StringManager.getString("marker.signal.mark"); }
	},

	/**
	 * VIDYA を表します。
	 */
	VIDYA {
		@Override public String getLabel() { return StringManager.getString("band.vidya"); }
		@Override public String toString() { return getLabel(); }
	};

	/**
	 * 見出し文字列を返します。
	 * 
	 * @return 見出し文字列
	 */
	public abstract String getLabel();

}
