/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 *
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 *
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

import jp.sf.orangesignal.csv.CsvListHandler;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;

/**
 * 項目位置と項目値のマップのリストで区切り文字形式データアクセスを行うハンドラを提供します。
 *
 * @author 杉澤 浩二
 * @since 1.1
 */
public class ColumnPositionMapListHandler implements CsvListHandler<Map<Integer, String>> {

	/**
	 * デフォルトコンストラクタです。
	 */
	public ColumnPositionMapListHandler() {}

	@Override
	public List<Map<Integer, String>> load(final CsvReader reader) throws IOException {
		// TODO: 必要があればここに入力パラメータを検証するコードを記述します。

		// データ部を処理します。
		final List<Map<Integer, String>> results = new ArrayList<Map<Integer, String>>();
		List<String> values;
		while ((values = reader.readValues()) != null) {
			final SortedMap<Integer, String> map = new TreeMap<Integer, String>();
			final int len = values.size();
			for (int pos = 0; pos < len; pos++) {
				map.put(pos, values.get(pos));
			}
			results.add(map);
		}
		return results;
	}

	@Override
	public void save(final List<Map<Integer, String>> list, final CsvWriter writer) throws IOException {
		// TODO: 必要があればここに入力パラメータを検証するコードを記述します。

		// データ部を処理します。
		for (final Map<Integer, String> map : list) {
			// 要素が null の場合は null 出力します。
			if (map == null) {
				writer.writeValues(null);
				continue;
			}
			final String[] values = new String[getMaxColumnPosition(map) + 1];
			for (final Map.Entry<Integer, String> e : map.entrySet()) {
				final int pos = e.getKey();
				if (pos >= 0) {
					values[pos] = e.getValue();
				}
			}
			writer.writeValues(Arrays.asList(values));
		}
	}

	private static int getMaxColumnPosition(final Map<Integer, String> map) {
		final SortedMap<Integer, String> m;
		if (map instanceof SortedMap) {
			m = (SortedMap<Integer, String>) map;
		} else {
			m = new TreeMap<Integer, String>(map);
		}
		return Math.max(m.lastKey().intValue(), 0);
	}

}
