/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 *
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 *
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.csv.handlers;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import java.io.IOException;
import java.lang.reflect.Field;

import org.junit.Test;

/**
 * {@link BeanListHandlerSupport} クラスの単体テストです。
 *
 * @author 杉澤 浩二
 */
public class BeanListHandlerSupportTest {

	@Test
	public void test() throws IOException {
		final SampleBean obj = new SampleBean("AAAA", "aaa", 10000, 10);

		final Field f = BeanListHandlerSupport.getField(SampleBean.class, "price");
		assertThat(f.getName(), is("price"));
		assertThat(f.getDeclaringClass().getName(), is(SampleBean.class.getName()));

		BeanListHandlerSupport.setFieldValue(obj, f, 100);
		final Object o = BeanListHandlerSupport.getFieldValue(obj, f);
		assertThat(((Number) o).intValue(), is(100));
	}

}
