/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.strategy.stop;

import java.util.LinkedList;

import jp.sf.orangesignal.trading.Position;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

/**
 * ポジションの保有期間が、指定された期間を経過した場合に、
 * 成行注文で決済するロスカットルールのストラテジーを提供します。
 * 
 * @author 杉澤 浩二
 */
public class InactivityStop extends TradingStrategySupport {

	/**
	 * 期間を保持します。
	 */
	private int period = 5;

	/**
	 * 期間を返します。
	 * 
	 * @return 期間
	 */
	public int getPeriod() { return period; }

	/**
	 * 期間を設定します。
	 * 
	 * @param period 期間
	 */
	public void setPeriod(final int period) { this.period = period; }

	@Override
	public boolean execute() {
		// ポジション毎に経過期間を検証します。
		final LinkedList<Position> positions = getCurrentPositions();
		for (final Position p : positions) {
			final int hold = getCurrentDataIndex() - getDataset().indexOf(p.getEntryDate());
			if (hold >= period) {
				switch (p.getType()) {
					case LONG:
						sell(getStrategyName());
						break;
					case SHORT:
						buyToCover(getStrategyName());
						break;
				}
			}
		}
		return false;
	}

}
