/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data.annotation;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertThat;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import jp.sf.orangesignal.ta.data.CsvPriceLoader;
import jp.sf.orangesignal.ta.data.DatasetSource;
import jp.sf.orangesignal.ta.data.model.Price;
import jp.sf.orangesignal.ta.data.model.PriceDataset;
import jp.sf.orangesignal.ta.data.sample.CollectionDataset;

import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * {@link AnnotationParser} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class AnnotationParserTest {

	private static PriceDataset dataset;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		final CsvPriceLoader loader = (CsvPriceLoader) new ClassPathXmlApplicationContext("applicationContext.xml").getBean("loader", CsvPriceLoader.class);
		dataset = PriceDataset.newInstance(loader.load("n225").toArray(new Price[0]));
	}

	@Test
	public void testParseObject() throws ParseException {
		final SimpleDateFormat ymd = new SimpleDateFormat("yyyy/MM/dd");

		// Arrange
		final PriceDataset arrayDataset = new PriceDataset();
		arrayDataset.setDate(dataset.getDate());
		arrayDataset.setOpen(dataset.getOpen());
		arrayDataset.setHigh(dataset.getHigh());
		arrayDataset.setLow(dataset.getLow());
		arrayDataset.setClose(dataset.getClose());
		arrayDataset.setVolume(dataset.getVolume());
		// Act
		final DatasetSource items1 = AnnotationParser.parse(arrayDataset);
		// Assert
		assertNotNull(items1);
		assertThat(items1.getDate("date")[0], is(ymd.parse("1998/01/05")));
		assertThat(items1.getNumber("open")[0].intValue(), is(15268));
		assertThat(items1.getNumber("high")[0].intValue(), is(15307));
		assertThat(items1.getNumber("low")[0].intValue(), is(14956));
		assertThat(items1.getNumber("close")[0].intValue(), is(14956));
		assertThat(items1.getNumber("volume")[0].intValue(), is(156617100));
		assertThat(items1.getDate("date")[1], is(ymd.parse("1998/01/06")));
		assertThat(items1.getNumber("open")[1].intValue(), is(15007));
		assertThat(items1.getNumber("high")[1].intValue(), is(15066));
		assertThat(items1.getNumber("low")[1].intValue(), is(14714));
		assertThat(items1.getNumber("close")[1].intValue(), is(14896));
		assertThat(items1.getNumber("volume")[1].intValue(), is(346720500));

		// Arrange
		final CollectionDataset collectionDataset = new CollectionDataset();
		collectionDataset.date = Arrays.asList(dataset.getDate());
		collectionDataset.open = Arrays.asList(dataset.getOpen());
		collectionDataset.high = Arrays.asList(dataset.getHigh());
		collectionDataset.low = Arrays.asList(dataset.getLow());
		collectionDataset.close = Arrays.asList(dataset.getClose());
		collectionDataset.volume = Arrays.asList(dataset.getVolume());
		// Act
		final DatasetSource items2 = AnnotationParser.parse(collectionDataset);
		// Assert
		assertNotNull(items2);
		assertThat(items2.getDate("date")[0], is(ymd.parse("1998/01/05")));
		assertThat(items2.getNumber("open")[0].intValue(), is(15268));
		assertThat(items2.getNumber("high")[0].intValue(), is(15307));
		assertThat(items2.getNumber("low")[0].intValue(), is(14956));
		assertThat(items2.getNumber("close")[0].intValue(), is(14956));
		assertThat(items2.getNumber("volume")[0].intValue(), is(156617100));
		assertThat(items2.getDate("date")[1], is(ymd.parse("1998/01/06")));
		assertThat(items2.getNumber("open")[1].intValue(), is(15007));
		assertThat(items2.getNumber("high")[1].intValue(), is(15066));
		assertThat(items2.getNumber("low")[1].intValue(), is(14714));
		assertThat(items2.getNumber("close")[1].intValue(), is(14896));
		assertThat(items2.getNumber("volume")[1].intValue(), is(346720500));
	}

	@Test
	public void testParseCollection() throws ParseException {
		// Arrange
		final int length = dataset.getDate().length;
		final List<Price> list1 = new ArrayList<Price>(length);
		for (int i = 0; i < length; i++) {
			final Price data = new Price();
			data.setDate(dataset.getDate()[i]);
			data.setOpen(dataset.getOpen()[i]);
			data.setHigh(dataset.getHigh()[i]);
			data.setLow(dataset.getLow()[i]);
			data.setClose(dataset.getClose()[i]);
			data.setVolume(dataset.getVolume()[i]);
			list1.add(data);
		}

		// Act
		final DatasetSource items = AnnotationParser.parse(list1);

		// Assert
		final SimpleDateFormat ymd = new SimpleDateFormat("yyyy/MM/dd");
		assertNotNull(items);
		assertThat(items.getDate("date")[0], is(ymd.parse("1998/01/05")));
		assertThat(items.getNumber("open")[0].intValue(), is(15268));
		assertThat(items.getNumber("high")[0].intValue(), is(15307));
		assertThat(items.getNumber("low")[0].intValue(), is(14956));
		assertThat(items.getNumber("close")[0].intValue(), is(14956));
		assertThat(items.getNumber("volume")[0].intValue(), is(156617100));
		assertThat(items.getDate("date")[1], is(ymd.parse("1998/01/06")));
		assertThat(items.getNumber("open")[1].intValue(), is(15007));
		assertThat(items.getNumber("high")[1].intValue(), is(15066));
		assertThat(items.getNumber("low")[1].intValue(), is(14714));
		assertThat(items.getNumber("close")[1].intValue(), is(14896));
		assertThat(items.getNumber("volume")[1].intValue(), is(346720500));
	}

	@Test
	public void testParseObjectArray() throws ParseException {
		// Arrange
		final int length = dataset.getDate().length;
		final List<Price> list1 = new ArrayList<Price>(length);
		for (int i = 0; i < length; i++) {
			final Price data = new Price();
			data.setDate(dataset.getDate()[i]);
			data.setOpen(dataset.getOpen()[i]);
			data.setHigh(dataset.getHigh()[i]);
			data.setLow(dataset.getLow()[i]);
			data.setClose(dataset.getClose()[i]);
			data.setVolume(dataset.getVolume()[i]);
			list1.add(data);
		}

		// Act
		final DatasetSource items = AnnotationParser.parse(list1.toArray());

		// Assert
		final SimpleDateFormat ymd = new SimpleDateFormat("yyyy/MM/dd");
		assertNotNull(items);
		assertThat(items.getDate("date")[0], is(ymd.parse("1998/01/05")));
		assertThat(items.getNumber("open")[0].intValue(), is(15268));
		assertThat(items.getNumber("high")[0].intValue(), is(15307));
		assertThat(items.getNumber("low")[0].intValue(), is(14956));
		assertThat(items.getNumber("close")[0].intValue(), is(14956));
		assertThat(items.getNumber("volume")[0].intValue(), is(156617100));
		assertThat(items.getDate("date")[1], is(ymd.parse("1998/01/06")));
		assertThat(items.getNumber("open")[1].intValue(), is(15007));
		assertThat(items.getNumber("high")[1].intValue(), is(15066));
		assertThat(items.getNumber("low")[1].intValue(), is(14714));
		assertThat(items.getNumber("close")[1].intValue(), is(14896));
		assertThat(items.getNumber("volume")[1].intValue(), is(346720500));
	}

}
