/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data;

import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsNull.notNullValue;
import static org.hamcrest.core.IsNull.nullValue;
import static org.junit.Assert.assertThat;

import org.junit.Test;

/**
 * {@link DatasetGenerateException} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class DatasetGenerateExceptionTest {

	@Test
	public void test() {
		final DatasetGenerateException ex1 = new DatasetGenerateException();
		assertThat(ex1.getMessage(), nullValue());
		assertThat(ex1.getCause(), nullValue());

		final DatasetGenerateException ex2 = new DatasetGenerateException("xxx");
		assertThat(ex2.getMessage(), is("xxx"));
		assertThat(ex2.getCause(), nullValue());

		final DatasetGenerateException ex3 = new DatasetGenerateException("xxx", new Throwable());
		assertThat(ex3.getMessage(), is("xxx"));
		assertThat(ex3.getCause(), notNullValue());

		final DatasetGenerateException ex4 = new DatasetGenerateException(new Throwable());
		assertThat(ex4.getMessage(), notNullValue());
		assertThat(ex4.getCause(), notNullValue());
	}

}
