/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta;

import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsNot.not;
import static org.hamcrest.core.IsNull.notNullValue;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.fail;

import java.util.List;
import java.util.Map;

import jp.sf.orangesignal.ta.data.CsvPriceLoader;
import jp.sf.orangesignal.ta.data.model.Price;
import jp.sf.orangesignal.ta.data.model.TechnicalPriceDataset;

import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.theories.Theories;
import org.junit.runner.RunWith;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * {@link TechnicalAnalysis} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
@RunWith(Theories.class)
public class TechnicalAnalysisTest {

	private static TechnicalPriceDataset dataset;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		final CsvPriceLoader loader = (CsvPriceLoader) new ClassPathXmlApplicationContext("applicationContext.xml").getBean("loader", CsvPriceLoader.class);
		dataset = TechnicalPriceDataset.newInstance(loader.load("n225").toArray(new Price[0]));
	}

	@Test
	public void testTechnicalAnalysis() {
		new TechnicalAnalysis();
	}

	@Test()
	public void testAddNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.add(dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testAddNumberArrayNumber() {
		final Number[] results = TechnicalAnalysis.add(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testSubNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.sub(dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testSubNumberArrayNumber() {
		final Number[] results = TechnicalAnalysis.sub(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testMultNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.mult(dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testMultNumberArrayNumber() {
		final Number[] results = TechnicalAnalysis.mult(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testDivNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.div(dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testDivNumberArrayNumber() {
		final Number[] results = TechnicalAnalysis.div(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testAvgNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.avg(dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testAvgNumberArrayNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.avg(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testAvgNumberArrayNumberArrayNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.avg(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testSin() {
		final Number[] results = TechnicalAnalysis.sin(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCos() {
		final Number[] results = TechnicalAnalysis.cos(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testTan() {
		final Number[] results = TechnicalAnalysis.tan(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testAsin() {
		final Number[] results = TechnicalAnalysis.asin(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testAcos() {
		final Number[] results = TechnicalAnalysis.acos(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testAtan() {
		final Number[] results = TechnicalAnalysis.atan(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testExp() {
		final Number[] results = TechnicalAnalysis.exp(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testLog() {
		final Number[] results = TechnicalAnalysis.log(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testLog10() {
		final Number[] results = TechnicalAnalysis.log10(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testSqrt() {
		final Number[] results = TechnicalAnalysis.sqrt(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCeil() {
		final Number[] results = TechnicalAnalysis.ceil(TechnicalAnalysis.div(dataset.getTechnicalClose(), 2));
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testFloor() {
		final Number[] results = TechnicalAnalysis.floor(TechnicalAnalysis.div(dataset.getTechnicalClose(), 2));
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testRound() {
		final Number[] results = TechnicalAnalysis.round(TechnicalAnalysis.div(dataset.getTechnicalClose(), 2));
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test
	public void testAbs() {
		final Number[] results1 = TechnicalAnalysis.abs(dataset.getTechnicalClose());
		assertThat(results1, notNullValue());
		assertThat(results1.length, is(dataset.getDate().length));

		final Number[] results2 = TechnicalAnalysis.abs(TechnicalAnalysis.mult(dataset.getTechnicalClose(), -1));
		assertThat(results2, notNullValue());
		assertThat(results2.length, is(dataset.getDate().length));
	}

	@Test()
	public void testMax() {
		final Number[] results = TechnicalAnalysis.max(dataset.getTechnicalOpen(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testMin() {
		final Number[] results = TechnicalAnalysis.min(dataset.getTechnicalOpen(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testSinh() {
		final Number[] results = TechnicalAnalysis.sinh(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCosh() {
		final Number[] results = TechnicalAnalysis.cosh(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testTanh() {
		final Number[] results = TechnicalAnalysis.tanh(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testSum() {
		final Number[] results = TechnicalAnalysis.sum(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testHighest() {
		final Number[] results = TechnicalAnalysis.highest(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testLowest() {
		final Number[] results = TechnicalAnalysis.lowest(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPeriodsSinceHighest() {
		final Number[] results = TechnicalAnalysis.periodsSinceHighest(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPeriodsSinceLowest() {
		final Number[] results = TechnicalAnalysis.periodsSinceLowest(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testMidpoint() {
		final Number[] results = TechnicalAnalysis.midpoint(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testMidprice() {
		final Number[] results = TechnicalAnalysis.midprice(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test
	public void testVarNumberArrayIntBoolean() {
		final Number[] results1 = TechnicalAnalysis.var(dataset.getTechnicalClose(), 5, false);
		assertThat(results1, notNullValue());
		assertThat(results1.length, is(dataset.getDate().length));

		final Number[] results2 = TechnicalAnalysis.var(dataset.getTechnicalClose(), 5, true);
		assertThat(results2, notNullValue());
		assertThat(results2.length, is(dataset.getDate().length));
	}

	@Test()
	public void testVarNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.var(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testVarp() {
		final Number[] results = TechnicalAnalysis.varp(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testStddev() {
		final Number[] results = TechnicalAnalysis.stddev(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testStddevp() {
		final Number[] results = TechnicalAnalysis.stddevp(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test
	public void testCovarNumberArrayNumberArrayIntBoolean() {
		final Number[] results1 = TechnicalAnalysis.covar(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5, true);
		assertThat(results1, notNullValue());
		assertThat(results1.length, is(dataset.getDate().length));

		final Number[] results2 = TechnicalAnalysis.covar(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5, false);
		assertThat(results2, notNullValue());
		assertThat(results1.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCovarNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.covar(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCovarn() {
		final Number[] results = TechnicalAnalysis.covarn(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test
	public void testCorrelNumberArrayNumberArrayIntBoolean() {
		final Number[] results1 = TechnicalAnalysis.correl(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5, true);
		assertThat(results1, notNullValue());
		assertThat(results1.length, is(dataset.getDate().length));

		final Number[] results2 = TechnicalAnalysis.correl(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5, false);
		assertThat(results2, notNullValue());
		assertThat(results2.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCorrelNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.correl(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPearson() {
		final Number[] results = TechnicalAnalysis.pearson(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testLr() {
		fail("まだ実装されていません");
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testBetaNumberArrayNumberArrayIntBoolean() {
		fail("まだ実装されていません");
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testBetaNumberArrayNumberArrayInt() {
		fail("まだ実装されていません");
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testBeta2() {
		fail("まだ実装されていません");
	}

	@Test()
	public void testAvgprice() {
		final Number[] results = TechnicalAnalysis.avgprice(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testHeikin() {
		final Map<FourPrice, Number[]> results = TechnicalAnalysis.heikin(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
	}

	@Test()
	public void testMp() {
		final Number[] results = TechnicalAnalysis.mp(dataset.getTechnicalHigh(), dataset.getTechnicalLow());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testTp() {
		final Number[] results = TechnicalAnalysis.tp(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testWtcl() {
		final Number[] results = TechnicalAnalysis.wtcl(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testTh() {
		final Number[] results = TechnicalAnalysis.th(dataset.getTechnicalHigh(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testTl() {
		final Number[] results = TechnicalAnalysis.th(dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testTr() {
		final Number[] results = TechnicalAnalysis.tr(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test
	public void testMa() {
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.SMA);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.SMMA);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.GMA);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.RMA);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.WWMA);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.WMA);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.HMA);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.TMA);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.EMA);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.DEMA);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.TEMA);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.ZLEMA);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.EPMA);
		TechnicalAnalysis.ma(dataset.getTechnicalClose(), 5, MovingAverage.T3);
	}

	@Test()
	public void testDoubleSmoothNumberArrayIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.doubleSmooth(dataset.getTechnicalClose(), 5, MovingAverage.EMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testDoubleSmoothNumberArrayIntMovingAverageIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.doubleSmooth(dataset.getTechnicalClose(), 5, MovingAverage.EMA, 5, MovingAverage.EMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testTripleSmoothNumberArrayIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.tripleSmooth(dataset.getTechnicalClose(), 5, MovingAverage.EMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testTripleSmoothNumberArrayIntMovingAverageIntMovingAverageIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.tripleSmooth(dataset.getTechnicalClose(), 5, MovingAverage.EMA, 5, MovingAverage.EMA, 5, MovingAverage.EMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testDmaNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.dma(dataset.getTechnicalClose(), 5, 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testDmaNumberArrayIntMovingAverageInt() {
		final Number[] results = TechnicalAnalysis.dma(dataset.getTechnicalClose(), 5, MovingAverage.SMA, 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testSma() {
		final Number[] results = TechnicalAnalysis.sma(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testSmma() {
		final Number[] results = TechnicalAnalysis.smma(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test
	public void testGma() {
		fail("まだ実装されていません");
	}

	@Test()
	public void testRma() {
		final Number[] results = TechnicalAnalysis.rma(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testWwma() {
		final Number[] results = TechnicalAnalysis.wwma(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testWma() {
		final Number[] results = TechnicalAnalysis.wma(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testHma() {
		final Number[] results = TechnicalAnalysis.hma(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testTma() {
		final Number[] results = TechnicalAnalysis.tma(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testEma() {
		final Number[] results = TechnicalAnalysis.ema(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testDema() {
		final Number[] results = TechnicalAnalysis.dema(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testTema() {
		final Number[] results = TechnicalAnalysis.tema(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testZlema() {
		final Number[] results = TechnicalAnalysis.zlema(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testEpma() {
		final Number[] results = TechnicalAnalysis.epma(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testT3NumberArrayInt() {
		final Number[] results = TechnicalAnalysis.t3(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testT3NumberArrayIntDouble() {
		final Number[] results = TechnicalAnalysis.t3(dataset.getTechnicalClose(), 5, 1.2);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testMamaNumberArray() {
		final Map<MESA, Number[]> results = TechnicalAnalysis.mama(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
	}

	@Test()
	public void testMamaNumberArrayDoubleDouble() {
		final Map<MESA, Number[]> results = TechnicalAnalysis.mama(dataset.getTechnicalClose(), 0.5, 0.05);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testVwma() {
		final Number[] results = TechnicalAnalysis.vwma(dataset.getTechnicalClose(), dataset.getTechnicalVolume(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCrossNumberArrayNumberArray() {
		final CrossSignal[] results = TechnicalAnalysis.cross(TechnicalAnalysis.sma(dataset.getTechnicalClose(), 5), TechnicalAnalysis.sma(dataset.getTechnicalClose(), 25));
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCrossNumberArrayDouble() {
		final CrossSignal[] results = TechnicalAnalysis.cross(TechnicalAnalysis.sma(dataset.getTechnicalClose(), 5), 10000);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testGc() {
		fail("まだ実装されていません");
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testDc() {
		fail("まだ実装されていません");
	}

	@Test()
	public void testZigzag() {
		final Number[] results = TechnicalAnalysis.zigzag(dataset.getTechnicalClose(), 5);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testBbandsNumberArrayNumberArrayNumberArrayIntDouble() {
		final Map<Bands5, Number[]> results = TechnicalAnalysis.bbands(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 5, 0.2);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testBbandsNumberArrayIntDouble() {
		final Map<Bands5, Number[]> results = TechnicalAnalysis.bbands(TechnicalAnalysis.tp(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose()), 5, 0.2);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testEnvelopeNumberArrayIntMovingAverageDouble() {
		final Map<Bands5, Number[]> results = TechnicalAnalysis.envelope(dataset.getTechnicalClose(), 25, MovingAverage.SMA, 5.0D);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testEnvelopeNumberArrayDouble() {
		final Number[] results = TechnicalAnalysis.envelope(TechnicalAnalysis.sma(dataset.getTechnicalClose(), 5), 5.0D);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testIchimoku() {
		final Map<Ichimoku, Number[]> results = TechnicalAnalysis.ichimoku(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 26, 9, 26);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testDisplace() {
		final Number[] results = TechnicalAnalysis.displace(dataset.getTechnicalClose(), 26);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPivot() {
		final Map<Bands7, Number[]> results = TechnicalAnalysis.pivot(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
	}

	@Test()
	public void testSar() {
		final Number[] results = TechnicalAnalysis.sar(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 0.02D);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testVolatility() {
		final Map<Bands2, Number[]> results = TechnicalAnalysis.volatility(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 5, 2.0D);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testAtr() {
		final Number[] results = TechnicalAnalysis.atr(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 14);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testChvNumberArrayNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.chv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 10, 10);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testChvNumberArrayNumberArrayIntIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.chv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 10, 10, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testHv() {
		final Number[] results = TechnicalAnalysis.hv(dataset.getTechnicalClose(), 20, 365);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testNatrNumberArrayNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.natr(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 14);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testNatrNumberArrayNumberArrayNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.natr(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 14, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	/* ---------------------------------------------------------------------- */
	/* モメンタム指標 */

	@Test()
	public void testApoNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.apo(dataset.getTechnicalClose(), 10, 30);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testApoNumberArrayIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.apo(dataset.getTechnicalClose(), 10, 30, MovingAverage.EMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testAsi() {
	}

	@Test()
	public void testAroonNumberArrayInt() {
		final Map<Aroon, Number[]> results = TechnicalAnalysis.aroon(dataset.getTechnicalClose(), 14);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testAroonNumberArrayIntPercentageScale() {
		final Map<Aroon, Number[]> results = TechnicalAnalysis.aroon(dataset.getTechnicalClose(), 14, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testBmpNumberArrayNumberArrayNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.bmp(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testBmpNumberArrayNumberArrayNumberArrayNumberArrayPercentageScale() {
		final Number[] results = TechnicalAnalysis.bmp(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testBopNumberArrayNumberArrayNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.bop(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testBopNumberArrayNumberArrayNumberArrayNumberArrayPercentageScale() {
		final Number[] results = TechnicalAnalysis.bop(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCci() {
		final Number[] results = TechnicalAnalysis.cci(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 20);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testChg() {
		final Number[] results = TechnicalAnalysis.chg(dataset.getClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testChgcnt() {
	}

	@Test()
	public void testCmf() {
		final Number[] results = TechnicalAnalysis.cmf(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), dataset.getTechnicalVolume(), 21);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCmoNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.cmo(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 25);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCmoNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.cmo(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 25, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCoppockNumberArrayIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.coppock(dataset.getTechnicalClose(), 12, 10, MovingAverage.WMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCoppockNumberArray() {
		final Number[] results = TechnicalAnalysis.coppock(dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testCoppockNumberArrayIntIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.coppock(dataset.getTechnicalClose(), 11, 14, 10, MovingAverage.WMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testCrsiNumberArrayIntInt() {
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testCrsiNumberArrayIntIntInt() {
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testCrsiNumberArrayIntIntIntPercentageScale() {
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testCsi() {
	}

	@Test()
	public void testDmiNumberArrayNumberArrayNumberArrayIntInt() {
		final Map<DMI, Number[]> results = TechnicalAnalysis.dmi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 14, 9);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testDmiNumberArrayNumberArrayNumberArrayIntIntPercentageScale() {
		final Map<DMI, Number[]> results = TechnicalAnalysis.dmi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 14, 9, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testDmiNumberArray() {
		fail("まだ実装されていません");
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testDmiNumberArrayIntIntMovingAverageIntDoubleDoublePercentageScale() {
		fail("まだ実装されていません");
	}

	@Test()
	public void testDpoNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.dpo(dataset.getTechnicalClose(), 10);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testDpoNumberArrayIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.dpo(dataset.getTechnicalClose(), 10, MovingAverage.SMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testEmv() {
		final Number[] results = TechnicalAnalysis.emv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalVolume(), 1);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testKairiNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.kairi(dataset.getTechnicalClose(), TechnicalAnalysis.ma(dataset.getTechnicalClose(), 25, MovingAverage.SMA));
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testKairiNumberArrayNumberArrayPercentageScale() {
		final Number[] results = TechnicalAnalysis.kairi(dataset.getTechnicalClose(), TechnicalAnalysis.ma(dataset.getTechnicalClose(), 25, MovingAverage.SMA), PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testMacdNumberArrayIntIntInt() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.macd(dataset.getTechnicalClose(), 25, 75, 9);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testMacdNumberArrayIntIntIntMovingAverage() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.macd(dataset.getTechnicalClose(), 25, 75, 9, MovingAverage.SMA);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testMacdNumberArrayIntMovingAverageIntMovingAverageIntMovingAverage() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.macd(dataset.getTechnicalClose(), 25, MovingAverage.EMA, 75, MovingAverage.EMA, 9, MovingAverage.SMA);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testMfi() {
		final Number[] results = TechnicalAnalysis.mfi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), dataset.getTechnicalVolume(), 14);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testMiNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.mi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 25);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testMiNumberArrayNumberArrayIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.mi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), 25, 9, MovingAverage.EMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testMom() {
		final Number[] results = TechnicalAnalysis.mom(dataset.getTechnicalClose(), 25);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPain() {
		final Number[] results = TechnicalAnalysis.pain(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPchgNumberArray() {
		final Number[] results = TechnicalAnalysis.pchg(dataset.getClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPchgNumberArrayPercentageScale() {
		final Number[] results = TechnicalAnalysis.pchg(dataset.getClose(), PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPcrNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.pcr(dataset.getTechnicalClose(), 9);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPcrNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.pcr(dataset.getTechnicalClose(), 9, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testPerformanceNumberArrayInt() {
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testPerformanceNumberArrayIntPercentageScale() {
	}

	@Test()
	public void testPpoNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.ppo(dataset.getTechnicalClose(), 10, 30);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPpoNumberArrayIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.ppo(dataset.getTechnicalClose(), 10, 30, MovingAverage.EMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPpoNumberArrayIntIntMovingAveragePercentageScale() {
		final Number[] results = TechnicalAnalysis.ppo(dataset.getTechnicalClose(), 10, 30, MovingAverage.EMA, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPsyNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.psy(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 12);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPsyNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.psy(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 12, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testQstickNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.qstick(dataset.getTechnicalOpen(), dataset.getTechnicalClose(), 8);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testQstickNumberArrayNumberArrayIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.qstick(dataset.getTechnicalOpen(), dataset.getTechnicalClose(), 8, MovingAverage.SMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testRciNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.rci(dataset.getTechnicalClose(), 9);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testRciNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.rci(dataset.getTechnicalClose(), 9, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testRocNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.roc(dataset.getTechnicalClose(), 25);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testRocNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.roc(dataset.getTechnicalClose(), 25, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testRsiNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.rsi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 14);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testRsiNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.rsi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 14, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testRviNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.rvi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 14);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testRviNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.rvi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 14, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testShinoharaNumberArrayNumberArrayNumberArrayNumberArrayInt() {
		final Map<Shinohara, Number[]> results = TechnicalAnalysis.shinohara(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 26);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testShinoharaNumberArrayNumberArrayNumberArrayNumberArrayIntPercentageScale() {
		final Map<Shinohara, Number[]> results = TechnicalAnalysis.shinohara(dataset.getTechnicalOpen(), dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 26, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testCratio() {
	}

	@Test()
	public void testSrvNumberArrayNumberArrayNumberArrayIntInt() {
		final Map<Stochastics, Number[]> results = TechnicalAnalysis.srv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 9, 9);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testSrvNumberArrayNumberArrayNumberArrayIntIntPercentageScale() {
		final Map<Stochastics, Number[]> results = TechnicalAnalysis.srv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 9, 9, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testSrvNumberArrayNumberArrayNumberArrayIntIntMovingAveragePercentageScale() {
		final Map<Stochastics, Number[]> results = TechnicalAnalysis.srv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 9, 9, MovingAverage.SMA, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
	}

	@Ignore("まだ実装されていません")
	@Test()
	public void testSrvrsi() {
	}

	@Test()
	public void testTiiNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.tii(dataset.getTechnicalClose(), 30);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testTiiNumberArrayIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.tii(dataset.getTechnicalClose(), 30, MovingAverage.SMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testTiiNumberArrayIntMovingAveragePercentageScale() {
		final Number[] results = TechnicalAnalysis.tii(dataset.getTechnicalClose(), 30, MovingAverage.SMA, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testTrix() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.trix(dataset.getTechnicalClose(), 25, 9, MovingAverage.SMA);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testTsiNumberArrayIntIntIntMovingAverage() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.tsi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 13, 25, 7, MovingAverage.SMA);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testTsiNumberArrayIntIntMovingAverageIntMovingAverage() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.tsi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 13, 25, MovingAverage.EMA, 7, MovingAverage.SMA);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testTsiNumberArrayIntMovingAverageIntMovingAverageIntMovingAveragePercentageScale() {
		final Map<Histogram, Number[]> results = TechnicalAnalysis.tsi(TechnicalAnalysis.chg(dataset.getTechnicalClose()), 13, MovingAverage.EMA, 25, MovingAverage.EMA, 7, MovingAverage.SMA, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
	}

	@Test()
	public void testUltimateNumberArrayNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.ultimate(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 7);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testUltimateNumberArrayNumberArrayNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.ultimate(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 7, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testVidyaNumberArrayInt() {
		fail("まだ実装されていません");
	}

	@Ignore("現バージョンではテスト対象外とする")
	@Test()
	public void testVidyaNumberArrayIntInt() {
		fail("まだ実装されていません");
	}

	@Test()
	public void testWad() {
		final Number[] results = TechnicalAnalysis.wad(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testWrNumberArrayNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.wr(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 20);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testWrNumberArrayNumberArrayNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.wr(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), 20, PercentageScale.REVERSE_PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	/* ---------------------------------------------------------------------- */
	/* 出来高指標 */

	@Test()
	public void testAd() {
		final Number[] results = TechnicalAnalysis.ad(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), dataset.getTechnicalVolume());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testClv() {
		final Number[] results = TechnicalAnalysis.clv(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testChoNumberArrayNumberArrayNumberArrayNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.cho(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), dataset.getTechnicalVolume(), 3, 10);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testChoNumberArrayNumberArrayNumberArrayNumberArrayIntMovingAverageIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.cho(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), dataset.getTechnicalVolume(), 3, MovingAverage.EMA, 10, MovingAverage.EMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testAvoNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.avo(dataset.getTechnicalVolume(), 10, 30);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testAvoNumberArrayIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.avo(dataset.getTechnicalVolume(), 10, 30, MovingAverage.EMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testBwmfiNumberArrayNumberArrayNumberArray() {
		final Number[] results = TechnicalAnalysis.bwmfi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalVolume());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testBwmfiNumberArrayNumberArrayNumberArrayPercentageScale() {
		final Number[] results = TechnicalAnalysis.bwmfi(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalVolume(), PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPvoNumberArrayIntInt() {
		final Number[] results = TechnicalAnalysis.pvo(dataset.getTechnicalVolume(), 10, 30);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPvoNumberArrayIntIntMovingAverage() {
		final Number[] results = TechnicalAnalysis.pvo(dataset.getTechnicalVolume(), 10, 30, MovingAverage.EMA);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPvoNumberArrayIntIntMovingAveragePercentageScale() {
		final Number[] results = TechnicalAnalysis.pvo(dataset.getTechnicalVolume(), 10, 30, MovingAverage.EMA, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPvt() {
		final Number[] results = TechnicalAnalysis.pvt(dataset.getTechnicalClose(), dataset.getTechnicalVolume());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testVao() {
		final Number[] results = TechnicalAnalysis.vao(dataset.getTechnicalHigh(), dataset.getTechnicalLow(), dataset.getTechnicalClose(), dataset.getTechnicalVolume());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testVr1NumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.vr1(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 25);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testVr1NumberArrayNumberArrayIntDoubleDouble() {
		final Number[] results = TechnicalAnalysis.vr1(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 25, 450, 70);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testVr2NumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.vr2(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 14);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testVr2NumberArrayNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.vr2(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 14, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testWvrNumberArrayNumberArrayInt() {
		final Number[] results = TechnicalAnalysis.wvr(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 25);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testWvrNumberArrayNumberArrayIntPercentageScale() {
		final Number[] results = TechnicalAnalysis.wvr(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 25, PercentageScale.PERCENT);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testPvi() {
		final Number[] results = TechnicalAnalysis.pvi(dataset.getTechnicalClose(), dataset.getTechnicalVolume());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testNvi() {
		final Number[] results = TechnicalAnalysis.nvi(dataset.getTechnicalClose(), dataset.getTechnicalVolume());
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	@Test()
	public void testObv() {
		final Number[] results = TechnicalAnalysis.obv(TechnicalAnalysis.chg(dataset.getTechnicalClose()), dataset.getTechnicalVolume(), 75);
		assertThat(results, notNullValue());
		assertThat(results.length, is(dataset.getDate().length));
	}

	/* ---------------------------------------------------------------------- */
	/* 時系列 */

	@Ignore("過去散々テストしてから変更がないためテスト対象外とする")
	@Test()
	public void testSplit() {
		fail("まだ実装されていません");
	}

	/* ---------------------------------------------------------------------- */
	/* 非時系列 */

	@Test()
	public void testPf() {
		final List<Step> results = TechnicalAnalysis.pf(dataset.getDate(), dataset.getClose(), 2.0D, 3);
		assertThat(results, notNullValue());
		assertThat(results.size(), is(not(0)));
	}

	@Test()
	public void testKagi() {
		final List<Step> results = TechnicalAnalysis.kagi(dataset.getDate(), dataset.getClose(), 3.0D);
		assertThat(results, notNullValue());
		assertThat(results.size(), is(not(0)));
	}

	@Test()
	public void testRenkoh() {
		final List<Step> results = TechnicalAnalysis.renkoh(dataset.getDate(), dataset.getClose(), 3.0D);
		assertThat(results, notNullValue());
		assertThat(results.size(), is(not(0)));
	}

	@Test()
	public void testShinne() {
		final List<Step> results = TechnicalAnalysis.shinne(dataset.getDate(), dataset.getClose(), 3);
		assertThat(results, notNullValue());
		assertThat(results.size(), is(not(0)));
	}

}
