/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

/**
 * {@link BandType} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class BandTypeTest {

	@Test
	public void testValues() {
		final BandType[] values = BandType.values();
		for (final BandType value : values) {
			switch (value) {
				case NONE:
				case BOLLINGER_BANDS:
				case DONCHIAN:
				case ENVELOPE:
				case HIGH_LOW_MOVING_AVERAGE:
				case ICHIMOKU:
				case PARABOLIC_TIME_PRICE:
				case PIVOT:
				case VIX:
				case MESA:
				case VIDYA:
					assertTrue(true);
					break;
				default:
					assertTrue(false);
			}
		}
	}

	@Test
	public void testGetLabel() {
		assertNotNull(BandType.NONE.getLabel());
		assertNotNull(BandType.BOLLINGER_BANDS.getLabel());
		assertNotNull(BandType.DONCHIAN.getLabel());
		assertNotNull(BandType.ENVELOPE.getLabel());
		assertNotNull(BandType.HIGH_LOW_MOVING_AVERAGE.getLabel());
		assertNotNull(BandType.ICHIMOKU.getLabel());
		assertNotNull(BandType.PARABOLIC_TIME_PRICE.getLabel());
		assertNotNull(BandType.PIVOT.getLabel());
		assertNotNull(BandType.VIX.getLabel());
		assertNotNull(BandType.MESA.getLabel());
		assertNotNull(BandType.VIDYA.getLabel());
	}

	@Test
	public void testToString() {
		assertNotNull(BandType.NONE.toString());
		assertNotNull(BandType.BOLLINGER_BANDS.toString());
		assertNotNull(BandType.DONCHIAN.toString());
		assertNotNull(BandType.ENVELOPE.toString());
		assertNotNull(BandType.HIGH_LOW_MOVING_AVERAGE.toString());
		assertNotNull(BandType.ICHIMOKU.toString());
		assertNotNull(BandType.PARABOLIC_TIME_PRICE.toString());
		assertNotNull(BandType.PIVOT.toString());
		assertNotNull(BandType.VIX.toString());
		assertNotNull(BandType.MESA.toString());
		assertNotNull(BandType.VIDYA.toString());
	}

}
