/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import jp.sf.orangesignal.chart.ChartColor;
import jp.sf.orangesignal.chart.FontConstants;

/**
 * テキスト描画用のユーティリティクラスです。
 * 
 * @author 杉澤 浩二
 */
public abstract class DrawUtils {

	public static void drawText(final Graphics2D g2, final String text, final float x, final float y) {
		drawText(g2, text, x, y, Color.BLACK, Color.LIGHT_GRAY);
	}

	public static void drawText(final Graphics2D g2, final String text, final float x, final float y, final Color color) {
		drawText(g2, text, x, y, color, Color.LIGHT_GRAY);
	}

	/**
	 * 透明度 50% の Composite オブジェクトです。
	 */
	private static final Composite COMPOSITE = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.5F);

	private static void drawText(final Graphics2D g2, final String text, final float x, final float y, final Color color, final Color shadow) {
		final Composite originalComposite = g2.getComposite();
		g2.setComposite(COMPOSITE);
		g2.setColor(shadow);
		g2.drawString(text, x + 1, y    );
		g2.drawString(text, x,     y + 1);
		g2.drawString(text, x + 1, y + 1);
		g2.setComposite(originalComposite);

		g2.setColor(color);
		g2.drawString(text, x, y);
	}

	/**
	 * チャートの説明を描画します。
	 * 
	 * @param g2 グラフィックスオブジェクト
	 * @param area 描画領域
	 * @param text チャートの説明文
	 */
	public static void drawDescription(final Graphics2D g2, final Rectangle2D area, final String text) {
		g2.setFont(FontConstants.FONT_GUI);
		final float x = (float) area.getMinX();
		final float y = (float) area.getMinY() + g2.getFontMetrics().getAscent();
		DrawUtils.drawText(g2, text, x, y, ChartColor.GRAY);
	}

}
