/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.cross;
import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.macd;
import static jp.sourceforge.orangesignal.ta.result.Histogram.HISTOGRAM;

import java.util.Map;

import jp.sourceforge.orangesignal.ta.CrossSignal;
import jp.sourceforge.orangesignal.ta.result.Histogram;
import jp.sourceforge.orangesignal.trading.strategy.TradingStrategySupport;

public abstract class MACD extends TradingStrategySupport {

	private int fast = 12;
	public int getFast() { return fast; }
	public void setFast(final int fast) { this.fast = fast; }

	private int slow = 26;
	public int getSlow() { return slow; }
	public void setSlow(final int slow) { this.slow = slow; }

	private int signal = 9;
	public int getSignal() { return signal; }
	public void setSignal(final int signal) { this.signal = signal; }

	// ----------------------------------------------------------------------

	protected CrossSignal[] cross;

	@Override
	public void prepare() {
		final Map<Histogram, Number[]> map = macd(getDataset().getTechnicalClose(), fast, slow, signal);
		final Number[] histogram = map.get(HISTOGRAM);
		this.cross = cross(histogram, 0);
	}

	@Override
	public void close() {
		this.cross = null;
	}

}
