/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import jp.sourceforge.orangesignal.ta.candle.Candlestick;
import jp.sourceforge.orangesignal.trading.strategy.TradingStrategySupport;

public class GapUpLongEntry extends TradingStrategySupport {

	protected Candlestick[] c;

	@Override
	public void prepare() {
		this.c = getDataset().getCandlestick();
	}

	@Override
	public boolean execute() {
		final int i = getCurrentDataIndex();
		if (i > 0 && c[i - 1] != null && c[i] != null && c[i - 1].gapUp(c[i]))
			buy(getStrategyName());
		return false;
	}

	@Override
	public void close() {
		this.c = null;
	}

}
