/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.order;

import java.util.Date;

/**
 * 注文情報の基底のインターフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface Order extends Comparable<Order> {

	/**
	 * シンボルを返します。
	 * 
	 * @return シンボル
	 */
	public String getSymbol();

	/**
	 * 注文の種類を返します。
	 * 
	 * @return 注文の種類
	 */
	public OrderType getOrderType();

	/**
	 * ラベルを返します。
	 * 
	 * @return ラベル。又は <code>null</code>
	 */
	public String getLabel();

	/**
	 * 注文日時を返します。
	 * 
	 * @return 注文日時
	 */
	public Date getDate();

	/**
	 * 注文数量を返します。
	 * 
	 * @return 注文数量。デフォルトの数量の場合は <code>0</code>
	 */
	public int getQuantity();

	/**
	 * 決済注文IDを返します。
	 * 
	 * @return 決済注文ID。又は <code>null</code>
	 */
	public Integer getFindId();

	/**
	 * 決済注文ラベルを返します。
	 * 
	 * @return 決済注文ラベル。又は <code>null</code>
	 */
	public String getFindLabel();

	/**
	 * <p>注文日時から実際に注文が受付けられる日時までの期間を返します。</p>
	 * 実装は必ず <code>0</code> 以上の値を返す必要があります。
	 * 
	 * @return 期間
	 */
	public int getPeriod();

}
