/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.dataset.loader;

/**
 * データ列の種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 * @see PriceDataLoader
 * @since 1.1
 */
public enum PriceDataColumnType {

	/**
	 * 日付を表します。
	 */
	DATE,

	/**
	 * 始値を表します。
	 */
	OPEN,

	/**
	 * 高値を表します。
	 */
	HIGH,

	/**
	 * 安値を表します。
	 */
	LOW,

	/**
	 * 終値を表します。
	 */
	CLOSE,

	/**
	 * 出来高を表します。
	 */
	VOLUME

}
