/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.CrossSignal.GOLDEN_CROSS;
import static jp.sourceforge.orangesignal.trading.strategy.StrategyStatus.NEXT;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;

/**
 * 価格と移動平均のゴールデンクロスで売りポジションを決済するストラテジーを提供します。
 */
public class MovingAverageCrossShortExit extends MovingAverageCross {

	@Override
	public StrategyStatus process() {
		final int i = getCurrentDataIndex();
		if (cross[i] != null && cross[i] == GOLDEN_CROSS)
			buyToCover(getStrategyName());
		return NEXT;
	}

}
