/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.lowest;
import static jp.sourceforge.orangesignal.trading.order.OrderTiming.NEXT_STOP;
import static jp.sourceforge.orangesignal.trading.strategy.StrategyStatus.NEXT;
import jp.sourceforge.orangesignal.ta.result.FourPrice;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;
import jp.sourceforge.orangesignal.trading.strategy.StrategySupport;

public class ChannelBreakoutShortEntry extends StrategySupport {

	/**
	 * 4本値の種類を保持します。
	 */
	private FourPrice price = FourPrice.LOW;

	/**
	 * 4本値の種類を返します。
	 * 
	 * @return 4本値の種類
	 */
	public FourPrice getPrice() { return price; }

	/**
	 * 4本値の種類を設定します。
	 * 
	 * @param price 4本値の種類
	 */
	public void setPrice(final FourPrice price) { this.price = price; }

	/**
	 * 期間を保持します。
	 */
	private int period = 20;

	/**
	 * 期間を返します。
	 * 
	 * @return 期間
	 */
	public int getPeriod() { return period; }

	/**
	 * 期間を設定します。
	 * 
	 * @param period 期間
	 */
	public void setPeriod(final int period) { this.period = period; }

	// ----------------------------------------------------------------------

	protected Number[] lowest;

	@Override
	public void init() {
		this.lowest = lowest(getDataset().getTechnicalPrice(this.price), this.period);
	}

	@Override
	public StrategyStatus process() {
		final int i = getCurrentDataIndex();
		if (lowest[i] != null)
			sellShort(getStrategyName(), NEXT_STOP, lowest[i].doubleValue() - 1);
		return NEXT;
	}

	@Override
	public void terminate() {
		this.lowest = null;
	}

}
