/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.filters;

import jp.sourceforge.orangesignal.ta.candle.Candlestick;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;
import jp.sourceforge.orangesignal.trading.strategy.StrategySupport;

/**
 * 指定された直近期間内の取組有無でフィルターするストラテジーを提供します。
 * 
 * @author 杉澤 浩二
 */
public class NoPriceFilter extends StrategySupport {

	/**
	 * デフォルトコンストラクタです。
	 */
	public NoPriceFilter() {}

	/**
	 * 直近期間を保持します。
	 */
	private int period = 5;

	/**
	 * 直近期間を返します。
	 * 
	 * @return 直近期間
	 */
	public int getPeriod() { return period; }

	/**
	 * 直近期間を設定します。
	 * 
	 * @param period 直近期間
	 */
	public void setPeriod(final int period) { this.period = period; }

	/**
	 * ローソク足データを保持します。
	 */
	private Candlestick[] c;

	@Override
	public void init() {
		c = getDataset().getCandlestick();
	}

	@Override
	public StrategyStatus process() {
		final int end = getCurrentDataIndex();
		final int start = Math.max(end - period + 1, getStartDataIndex());
		for (int i = start; i <= end; i++) {
			if (c[i] == null)
				return StrategyStatus.FILTER;
		}
		return StrategyStatus.NEXT;
	}

	@Override
	public void terminate() {
		c = null;
	}

}
