/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.commission;

import java.io.Serializable;

/**
 * <p>体系化手数料の個別手数料情報の基底クラスを提供します。</p>
 * 
 * @author 杉澤 浩二
 * @see CommissionSystem
 */
public abstract class CommissionUnit implements Commission, Serializable, Comparable<CommissionUnit> {

	private static final long serialVersionUID = -6489129757386613168L;

	/**
	 * デフォルトコンストラクタです。
	 */
	protected CommissionUnit() {}

	/**
	 * コンストラクタです。
	 * 
	 * @param base 基準価格
	 */
	protected CommissionUnit(final double base) {
		this.base = base;
	}

	/**
	 * 基準価格を保持します。
	 */
	private double base;

	/**
	 * 基準価格を返します。
	 * 
	 * @return 基準価格
	 */
	public double getBase() { return base; }

	/**
	 * 基準価格を設定します。
	 * 
	 * @param base 基準価格
	 */
	public void setBase(final double base) { this.base = base; }

//	/**
//	 * スリッページを保持します。
//	 */
//	private double slippage;

//	/**
//	 * スリッページを返します。
//	 * 
//	 * @return スリッページ
//	 */
//	public double getSlippage() { return slippage; }

	/**
	 * <p>
	 * この個別手数料情報と指定された個別手数料情報の順序を比較します。
	 * この個別手数料情報が指定された個別手数料情報より小さい場合は負の整数、等しい場合はゼロ、大きい場合は正の整数を返します。
	 * </p>
	 * <p>実装は基準価格で比較します。</p>
	 * 
	 * @param o 比較対照の個別手数料情報
	 * @return この個別手数料情報が指定された個別手数料情報より小さい場合は負の整数、等しい場合はゼロ、大きい場合は正の整数
	 * @throws NullPointerException パラメーターに <code>null</code> が指定された場合
	 */
	@Override
	public int compareTo(final CommissionUnit o) {
		if (o == null)
			throw new NullPointerException();
		if (base > o.base)
			return 1;
		else if (base < o.base)
			return -1;
		return 0;
	}

}
