package jp.sourceforge.orangesignal.ta.dataset.loader;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;

import java.io.File;
import java.io.IOException;
import java.util.List;

import org.junit.Test;

public class TextDataUtilsTest {

	private static final String PATH = "src/test/resources/data/";

	@Test
	public void testReadStringStringString() throws IOException {
		final List<String[]> results1 = TextDataUtils.read(PATH + "n225.csv", "Windows-31J", ",");
		assertNotNull(results1);
		assertFalse(results1.isEmpty());

		final List<String[]> results2 = TextDataUtils.read(PATH + "n225.zip", "Windows-31J", ",");
		assertNotNull(results2);
		assertFalse(results2.isEmpty());

		final List<String[]> results3 = TextDataUtils.read(PATH + "n225.lzh", "Windows-31J", ",");
		assertNotNull(results3);
		assertFalse(results3.isEmpty());
	}

	@Test
	public void testReadFileStringString() throws IOException {
		final List<String[]> results1 = TextDataUtils.read(new File(PATH + "n225.csv"), "Windows-31J", ",");
		assertNotNull(results1);
		assertFalse(results1.isEmpty());

		final List<String[]> results2 = TextDataUtils.read(new File(PATH + "n225.zip"), "Windows-31J", ",");
		assertNotNull(results2);
		assertFalse(results2.isEmpty());

		final List<String[]> results3 = TextDataUtils.read(new File(PATH + "n225.lzh"), "Windows-31J", ",");
		assertNotNull(results3);
		assertFalse(results3.isEmpty());
	}

}
