package jp.sourceforge.orangesignal.ta.candle.generator;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import org.junit.Test;

public class TrendProcessorExceptionTest {

	@Test
	public void デフォルトコンストラクタ() {
		TrendProcessorException e = new TrendProcessorException();
		assertNull(e.getMessage());
		assertNull(e.getCause());
	}

	@Test
	public void 詳細なエラーメッセージを指定するコンストラクタ() {
		TrendProcessorException e = new TrendProcessorException("xxx");
		assertEquals(e.getMessage(), "xxx");
		assertNull(e.getCause());
	}

	@Test
	public void 詳細なエラーメッセージと原因を指定するコンストラクタ() {
		TrendProcessorException e = new TrendProcessorException("xxx", new Throwable());
		assertEquals(e.getMessage(), "xxx");
		assertNotNull(e.getCause());
	}

	@Test
	public void 原因を指定するコンストラクタ() {
		TrendProcessorException e = new TrendProcessorException(new Throwable());
		assertNotNull(e.getMessage());
		assertNotNull(e.getCause());
	}

}
