/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.candle.generator;

import java.util.List;

import jp.sourceforge.orangesignal.ta.candle.TrendType;
import jp.sourceforge.orangesignal.ta.result.Step;


/**
 * カギ足データからトレンド情報を処理するトレンドプロセッサークラスを提供します。
 * 
 * @author 杉澤 浩二
 */
public final class KagiTrendProcessor extends StepTrendProcessor {

	/**
	 * コンストラクタです。
	 * 
	 * @param kagi カギ足データ
	 */
	public KagiTrendProcessor(final List<Step> kagi) {
		super(kagi);
	}

	@Override
	protected TrendType getTrend(final Step kagi) {
		if (kagi.open < kagi.high)
			return TrendType.UP;
		return TrendType.DOWN;
	}

}
