/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.highest;
import static jp.sourceforge.orangesignal.trading.order.OrderTiming.NEXT_STOP;
import jp.sourceforge.orangesignal.ta.result.FourPrice;
import jp.sourceforge.orangesignal.trading.strategy.TradingStrategySupport;

public class ChannelBreakoutLongEntry extends TradingStrategySupport {

	/**
	 * 4本値の種類を保持します。
	 */
	private FourPrice price = FourPrice.HIGH;

	/**
	 * 4本値の種類を返します。
	 * 
	 * @return 4本値の種類
	 */
	public FourPrice getPrice() { return price; }

	/**
	 * 4本値の種類を設定します。
	 * 
	 * @param price 4本値の種類
	 */
	public void setPrice(final FourPrice price) { this.price = price; }

	/**
	 * 期間を保持します。
	 */
	private int period = 20;

	/**
	 * 期間を返します。
	 * 
	 * @return 期間
	 */
	public int getPeriod() { return period; }

	/**
	 * 期間を設定します。
	 * 
	 * @param period 期間
	 */
	public void setPeriod(final int period) { this.period = period; }

	// ----------------------------------------------------------------------

	protected Number[] highest;

	@Override
	public void prepare() {
		this.highest = highest(getDataset().getTechnicalPrice(this.price), this.period);
	}

	@Override
	public boolean execute() {
		final int i = getCurrentDataIndex();
		if (highest[i] != null)
			buy(getStrategyName(), NEXT_STOP, highest[i].doubleValue() + 1);
		return false;
	}

	@Override
	public void close() {
		this.highest = null;
	}

}
