/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy;

import java.util.Date;

import jp.sourceforge.orangesignal.ta.dataset.StandardDataset;
import jp.sourceforge.orangesignal.trading.Trader;
import jp.sourceforge.orangesignal.trading.order.OrderTiming;

/**
 * トレーディングストラテジーのインターフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface TradingStrategy {

//	/**
//	 * 売買管理オブジェクトを返します。
//	 * 
//	 * @return 売買管理オブジェクト
//	 */
//	public Trader getTrader();

	/**
	 * 売買管理オブジェクトを設定します。
	 * 
	 * @param trader 売買管理オブジェクト
	 */
	public void setTrader(Trader trader);

//	/**
//	 * デフォルトの注文方法を返します。
//	 * 
//	 * @return デフォルトの注文方法
//	 */
//	public OrderTiming getDefaultOrderTiming();

	/**
	 * デフォルトの注文方法を設定します。
	 * 
	 * @param defaultOrderTiming デフォルトの注文方法
	 */
	public void setDefaultOrderTiming(OrderTiming defaultOrderTiming);

//	/**
//	 * シンボルを返します。
//	 * 
//	 * @return シンボル
//	 */
//	public String getSymbol();

	/**
	 * シンボルを設定します。
	 * 
	 * @param symbol シンボル
	 */
	public void setSymbol(String symbol);

	/**
	 * データセットを設定します。
	 * 
	 * @param dataset データセット
	 */
	public void setDataset(StandardDataset dataset);

	/**
	 * 開始データのインデックスを設定します。
	 * 
	 * @param index 開始データのインデックス
	 */
	public void setStartDataIndex(int index);

	/**
	 * 終了データのインデックスを設定します。
	 * 
	 * @param index 終了データのインデックス
	 */
	public void setEndDataIndex(int index);

	/**
	 * 当日データのインデックスを設定します。
	 * 
	 * @param index 当日データのインデックス
	 */
	public void setCurrentDataIndex(int index);

	/**
	 * 当日データの日時を設定します。
	 * 
	 * @param date 当日データの日時
	 */
	public void setDate(Date date);

	/**
	 * ストラテジーの名前を返します。
	 * 
	 * @return ストラテジーの名前
	 */
	public String getStrategyName();

	/**
	 * <p>ストラテジーを初期化します。</p>
	 */
	public void prepare();

	/**
	 * <p>ストラテジーを処理します。</p>
	 * 
	 * @return 処理を継続する場合は <code>false</code>。それ以外の場合は <code>true</code>。
	 * @throws Exception 例外が発生した場合
	 */
	public boolean execute() throws Exception;

	/**
	 * <p>ストラテジーを終了します。</p>
	 */
	public void close();

}
