/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.order;

import java.util.Date;

import jp.sourceforge.orangesignal.ta.result.FourPrice;

/**
 * 翌日の終値で成行注文する注文情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public final class NextCloseOrder extends AbstractMarketOrder {

	private static final long serialVersionUID = 5518749922753214951L;

	/**
	 * コンストラクタです。
	 * 
	 * @param symbol シンボル
	 * @param label ラベル
	 * @param date 注文日時
	 * @param quantity 数量
	 * @param findId 決済注文ID
	 * @param findLabel 決済注文ラベル
	 * @throws NullPointerException パラメーターに <code>null</code> を指定した場合
	 */
	public NextCloseOrder(
			final String symbol,
			final String label,
			final Date date,
			final int quantity,
			final Integer findId,
			final String findLabel)
	{
		super(symbol, label, date, quantity, findId, findLabel);
	}

	/**
	 * この実装は必ず <code>1</code> を返します。
	 */
	@Override public int getPeriod() { return 1; }

	/**
	 * この実装は必ず {@link FourPrice#CLOSE} を返します。
	 */
	@Override public FourPrice getPriceType() { return FourPrice.CLOSE; }

}
