package jp.sourceforge.orangesignal.ta.result;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import org.junit.Test;

public class StepTest {

	@Test
	public void newInstance0() {
		final Step step = new Step();

		// assert
		assertNull(step.openDate);
		assertNull(step.highDate);
		assertNull(step.lowDate);
		assertNull(step.closeDate);
		assertTrue(step.open == 0);
		assertTrue(step.high == 0);
		assertTrue(step.low == 0);
		assertTrue(step.close == 0);
		assertTrue(step.period == 0);
	}

	@Test
	public void newInstance1() {
		final Date now = new Date();
		final double price = 100D;
		final Step step = new Step(now, price);

		// assert
		assertEquals(step.openDate, now);
		assertEquals(step.highDate, now);
		assertEquals(step.lowDate, now);
		assertEquals(step.closeDate, now);
		assertTrue(step.open == price);
		assertTrue(step.high == price);
		assertTrue(step.low == price);
		assertTrue(step.close == price);
		assertTrue(step.period == 1);
	}

	@Test
	public void newInstance2() {
		final Date now = new Date();
		final double price = 100D;
		final int period = 5;
		final Step step = new Step(now, price, period);

		// assert
		assertEquals(step.openDate, now);
		assertEquals(step.highDate, now);
		assertEquals(step.lowDate, now);
		assertEquals(step.closeDate, now);
		assertTrue(step.open == price);
		assertTrue(step.high == price);
		assertTrue(step.low == price);
		assertTrue(step.close == price);
		assertTrue(step.period == period);
	}

}
