package jp.sourceforge.orangesignal.ta.dataset;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

public class DefaultDataTypeTest {

	@Test
	public void values() {
		final DefaultDataType[] values = DefaultDataType.values();
		for (final DefaultDataType value : values) {
			switch (value) {
				case OPEN: case HIGH: case LOW: case CLOSE: case VOLUME:
				case TECHNICAL_OPEN: case TECHNICAL_HIGH: case TECHNICAL_LOW: case TECHNICAL_CLOSE: case TECHNICAL_VOLUME:
				case SOLD: case BOUGHT: case SPLIT:
					assertTrue(true);
					break;
				default:
					assertTrue(false);
			}
		}
	}

	@Test
	public void getCompressType_OPEN() {
		assertEquals(DefaultDataType.OPEN.getCompressType(), CompressType.FIRST);
	}

	@Test
	public void getCompressType_HIGH() {
		assertEquals(DefaultDataType.HIGH.getCompressType(), CompressType.HIGHEST);
	}

	@Test
	public void getCompressType_LOW() {
		assertEquals(DefaultDataType.LOW.getCompressType(), CompressType.LOWEST);
	}

	@Test
	public void getCompressType_CLOSE() {
		assertEquals(DefaultDataType.CLOSE.getCompressType(), CompressType.LAST);
	}

	@Test
	public void getCompressType_VOLUME() {
		assertEquals(DefaultDataType.VOLUME.getCompressType(), CompressType.SUM);
	}

	@Test
	public void getCompressType_TECHNICAL_OPEN() {
		assertEquals(DefaultDataType.TECHNICAL_OPEN.getCompressType(), CompressType.FIRST);
	}

	@Test
	public void getCompressType_TECHNICAL_HIGH() {
		assertEquals(DefaultDataType.TECHNICAL_HIGH.getCompressType(), CompressType.HIGHEST);
	}

	@Test
	public void getCompressType_TECHNICAL_LOW() {
		assertEquals(DefaultDataType.TECHNICAL_LOW.getCompressType(), CompressType.LOWEST);
	}

	@Test
	public void getCompressType_TECHNICAL_CLOSE() {
		assertEquals(DefaultDataType.TECHNICAL_CLOSE.getCompressType(), CompressType.LAST);
	}

	@Test
	public void getCompressType_TECHNICAL_VOLUME() {
		assertEquals(DefaultDataType.TECHNICAL_VOLUME.getCompressType(), CompressType.SUM);
	}

	@Test
	public void getCompressType_SOLD() {
		assertEquals(DefaultDataType.SOLD.getCompressType(), CompressType.SUM);
	}

	@Test
	public void getCompressType_BOUGHT() {
		assertEquals(DefaultDataType.BOUGHT.getCompressType(), CompressType.SUM);
	}

	@Test
	public void getCompressType_SPLIT() {
		assertEquals(DefaultDataType.SPLIT.getCompressType(), CompressType.SUM);
	}

}
