/**
 * <p>ローソク足情報生成用の既定クラスを提供します。</p>
 * <p>以下はとりあえずコードを実行してみたい人向けの最も簡単な使用例です。<br></p>
 * <pre style="border:1px solid gray">
<font color="green">// 4本値データを用意します。</font>
Number[] open  = new Number[]{ ... };
Number[] high  = new Number[]{ ... };
Number[] low   = new Number[]{ ... };
Number[] close = new Number[]{ ... };
<font color="green">// 4本値データからローソク足情報を生成します。</font>
Candlestick[] candles = new CandlestickGenerator().generate(open, high, low, close);
<font color="green">// ローソク足情報を使用して、以下の例ではカラカサ線(たくり線)パターンを分析します。</font>
boolean[] bullishHammer = CandlestickPatterns.bullishHammer(candles);
</pre>
<p>
上記の例ではトレンド情報が分析に用いられない為、あまり実践的ではありません。<br>
以下はトレンド情報も分析に用いる使用例です。
</p>
<pre style="border:1px solid gray">
<font color="green">// 4本値データと日時データを用意します。</font>
Date[]   date  = new Date[]  { ... };
Number[] open  = new Number[]{ ... };
Number[] high  = new Number[]{ ... };
Number[] low   = new Number[]{ ... };
Number[] close = new Number[]{ ... };
<font color="green">// トレンドデータとしてポイント＆フィギュアデータを使用します。</font>
List&lt;Step&gt; pf = TechnicalAnalysis.pf(date, close, 2, 3);
<font color="green">// トレンドデータをトレンドプロセッサーへセットします。</font>
TrendProcessor processor = new PointFigureTrendProcessor(pf);
<font color="green">// 日時や4本値データ、トレンドプロセッサーを指定してローソク足情報を生成します。</font>
Candlestick[] candles = new CandlestickGenerator().generate(date, open, high, low, close, processor);
<font color="green">// ローソク足情報を使用して、以下の例ではカラカサ線(たくり線)パターンを分析します。</font>
boolean[] bullishHammer = CandlestickPatterns.bullishHammer(candles);
</pre>
 */
package jp.sourceforge.orangesignal.ta.candle.generator;
