/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta;

/**
 * 時系列データが交差するシグナルの種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum CrossSignal {

	/**
	 * <p>ゴールデンクロスを表します。</p>
	 * ゴールデンクロスとは短期指標が、長期指標を、
	 * 下から上へ突き抜けている形に交差した状態で、
	 * 一般的に上昇トレンドを示唆し、買いシグナルとされています。
	 */
	GOLDEN_CROSS,

	/**
	 * <p>デッドクロスを表します。</p>
	 * デッドクロスとは短期指標が、長期指標を、
	 * 上から下へ突き抜けている形に交差した状態で、
	 * 一般的に下降トレンドを示唆し、売りシグナルとされています。
	 */
	DEAD_CROSS;

}
