/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.screen;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;
import jp.sf.orangesignal.chart.data.TimeSeriesChartDataset;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.GlobalChartEvent;
import jp.sf.orangesignal.chart.event.GlobalChartListener;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.canvas.GlobalChartCanvas;
import jp.sf.orangesignal.chart.ui.canvas.TimeSeriesChartCanvas;
import jp.sf.orangesignal.chart.ui.screen.ChartScreen;

public class TimeSeriesScreen
extends ChartScreen
implements AdjustmentListener,
GlobalChartListener {
    private static final long serialVersionUID = -1491438659431552316L;
    private final TimeSeriesChartCanvas canvas;
    private final JScrollBar scrollbar = new JScrollBar(0, 0, 0, 0, 0);
    private final GlobalChartCanvas globalChartCanvas;

    public TimeSeriesScreen(Icons icons) {
        this.canvas = new TimeSeriesChartCanvas(icons, this);
        this.scrollbar.addAdjustmentListener(this);
        this.globalChartCanvas = new GlobalChartCanvas(icons);
        this.globalChartCanvas.addGlobalChartListener(this);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(layout);
        c.fill = 1;
        c.gridy = 0;
        c.weightx = 100.0;
        c.weighty = 100.0;
        layout.setConstraints(this.canvas, c);
        this.add(this.canvas);
        c.fill = 2;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        layout.setConstraints(this.scrollbar, c);
        this.add(this.scrollbar);
        c.anchor = 15;
        c.gridy = 2;
        c.weightx = 100.0;
        layout.setConstraints(this.globalChartCanvas, c);
        this.add(this.globalChartCanvas);
    }

    @Override
    public void datasetSwitch(ChartEvent e) {
        this.processChartEvent(e);
    }

    @Override
    public void periodSwitch(ChartEvent e) {
        this.processChartEvent(e);
    }

    @Override
    public void settingChanged(ChartEvent e) {
        this.processChartEvent(e);
    }

    private void processChartEvent(ChartEvent e) {
        if (!e.isIgnoreStart()) {
            TimeSeriesChartDataset dataset = (TimeSeriesChartDataset)e.getDataset();
            if (dataset == null) {
                this.scrollbar.setMaximum(0);
                this.scrollbar.setVisibleAmount(0);
                this.scrollbar.setValue(0);
                this.scrollbar.setBlockIncrement(0);
                this.scrollbar.setEnabled(false);
            } else if (!e.isIgnoreStart()) {
                this.scrollbar.setValue(0);
                this.scrollbar.setMaximum(dataset.getCount());
                this.scrollbar.setVisibleAmount(e.getPeriod());
                this.scrollbar.setValue(e.getStart());
                this.scrollbar.setBlockIncrement(e.getPeriod() / 2);
                this.scrollbar.setEnabled(true);
            }
        }
        this.globalChartCanvas.switchDataset(e);
        this.canvas.switchDataset(e);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.globalChartCanvas.setStart(e.getValue());
        this.canvas.setStart(e.getValue());
    }

    @Override
    public void scopeChanged(GlobalChartEvent e) {
        this.scrollbar.setValue(e.getPosition());
    }
}

