/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.screen;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.data.BasicChartDataset;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.screen.ChartScreen;
import jp.sf.orangesignal.chart.util.StringManager;
import jp.sf.orangesignal.ta.util.StringUtils;

public class HistoricalDataScreen
extends ChartScreen {
    private static final long serialVersionUID = 2858523354616362299L;
    private static final char SEPARATOR = '\t';
    private final JTextArea text = new JTextArea();

    public HistoricalDataScreen(Icons icons) {
        this.text.setEditable(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.getViewport().add(this.text);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
    }

    @Override
    public void datasetSwitch(ChartEvent e) {
        this.text.setText(this.createText((BasicChartDataset)e.getDataset(), e.getSettings()));
    }

    @Override
    public void periodSwitch(ChartEvent e) {
    }

    @Override
    public void settingChanged(ChartEvent e) {
        this.text.setText(this.createText((BasicChartDataset)e.getDataset(), e.getSettings()));
    }

    private String createText(BasicChartDataset dataset, ChartSettings settings) {
        if (dataset == null || dataset.getCount() <= 0) {
            return StringManager.getString("nodata", new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(StringManager.getString("_date", new Object[0]));
        sb.append('\t');
        sb.append(StringManager.getString("_open", new Object[0]));
        sb.append('\t');
        sb.append(StringManager.getString("_high", new Object[0]));
        sb.append('\t');
        sb.append(StringManager.getString("_low", new Object[0]));
        sb.append('\t');
        sb.append(StringManager.getString("_close", new Object[0]));
        sb.append('\t');
        sb.append(StringManager.getString("_volume", new Object[0]));
        sb.append("\n");
        String format = StringManager.getString("format.number", settings.precision);
        int max = dataset.getCount();
        for (int i = 0; i < max; ++i) {
            sb.append(StringUtils.defaultString((String)String.format(StringManager.getString("format.date", new Object[0]), dataset.date[i])));
            sb.append('\t');
            if (dataset.open[i] != null) {
                sb.append(StringUtils.defaultString((String)String.format(format, dataset.open[i].doubleValue())));
            }
            sb.append('\t');
            if (dataset.high[i] != null) {
                sb.append(StringUtils.defaultString((String)String.format(format, dataset.high[i].doubleValue())));
            }
            sb.append('\t');
            if (dataset.low[i] != null) {
                sb.append(StringUtils.defaultString((String)String.format(format, dataset.low[i].doubleValue())));
            }
            sb.append('\t');
            if (dataset.close[i] != null) {
                sb.append(StringUtils.defaultString((String)String.format(format, dataset.close[i].doubleValue())));
            }
            sb.append('\t');
            if (dataset.volume[i] != null) {
                sb.append(StringUtils.defaultString((String)String.format(format, dataset.volume[i].doubleValue())));
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

