/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.canvas;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.util.Date;
import jp.sf.orangesignal.chart.ChartColor;
import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.FontConstants;
import jp.sf.orangesignal.chart.data.AntiWatchChartDataset;
import jp.sf.orangesignal.chart.data.ChartDataset;
import jp.sf.orangesignal.chart.data.StepChartDataset;
import jp.sf.orangesignal.chart.data.TimeSeriesChartDataset;
import jp.sf.orangesignal.chart.data.VolumePriceHistogram;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.ChartScreenEvent;
import jp.sf.orangesignal.chart.ui.BandType;
import jp.sf.orangesignal.chart.ui.DatasetType;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.UpDownColorType;
import jp.sf.orangesignal.chart.ui.VolumeType;
import jp.sf.orangesignal.chart.ui.canvas.AbstractChartCanvas;
import jp.sf.orangesignal.chart.util.DrawUtils;
import jp.sf.orangesignal.chart.util.StringManager;

public class IndexCanvas
extends AbstractChartCanvas {
    private static final long serialVersionUID = -6936061295835378348L;
    private static final int DEFAULT_PRICE_PRECISION = 0;
    private static final int DEFAULT_RATIO_PRECISION = 4;
    private static final int DEFAULT_INDEX_PRECISION = 2;
    private static final int RATE_INDEX_PRECISION = 6;
    private static final String FORMAT_DECIMAL = StringManager.getString("format.number", 0);
    private static final String FORMAT_ENVELOPE = StringManager.getString("format.envelope", new Object[0]);
    private String formatPrice = StringManager.getString("format.number", 0);
    private String formatChange = StringManager.getString("format.change", 0);
    private String formatPercentChange = StringManager.getString("format.pchange", 2);
    private String formatRatio = StringManager.getString("format.number", 4);
    private String formatIndex = StringManager.getString("format.number", 2);
    private String formatRateIndex = StringManager.getString("format.number", 6);
    private ChartDataset dataset = null;
    private DatasetType type;
    private int start;
    private int period;
    private int position;
    private ChartSettings settings;
    private Object info;
    private int ascent;
    private static final int MARGIN = 4;
    private static final String FORMAT_DATE = StringManager.getString("format.date", new Object[0]);

    public IndexCanvas(Icons icons) {
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(216, 0));
    }

    @Override
    public void switchDataset(ChartEvent e) {
        this.dataset = e.getDataset();
        this.type = e.getType();
        if (!e.isIgnoreStart()) {
            this.start = e.getStart();
        }
        this.period = e.getPeriod();
        this.settings = e.getSettings();
        int precision = this.settings.precision;
        this.formatPrice = StringManager.getString("format.number", Math.max(precision, 0));
        this.formatChange = StringManager.getString("format.change", Math.max(precision, 0));
        this.formatPercentChange = StringManager.getString("format.pchange", Math.max(precision, 2));
        this.formatRatio = StringManager.getString("format.number", Math.max(precision, 4));
        this.formatIndex = StringManager.getString("format.number", Math.max(precision, 2));
        this.formatRateIndex = StringManager.getString("format.number", Math.max(precision, 6));
    }

    public void setup(ChartScreenEvent e) {
        this.start = e.getStart();
        this.position = e.getPosition();
        this.info = e.getInfo();
        this.repaint();
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public void draw(Graphics2D g2) {
        if (this.dataset == null || this.dataset.getCount() <= 0) {
            return;
        }
        this.ascent = g2.getFontMetrics(FontConstants.FONT_MESSAGE).getAscent();
        int y = 0;
        if (this.dataset instanceof TimeSeriesChartDataset) {
            TimeSeriesChartDataset dataset = (TimeSeriesChartDataset)this.dataset;
            Date startDate = dataset.date[this.start];
            Date endDate = dataset.date[this.start + this.period - 1];
            if (startDate == null && endDate == null) {
                return;
            }
            y += this.drawDateRange(g2, y, startDate, endDate);
            y += this.drawHorizontalLine(g2, y);
            y += this.drawDate(g2, y, StringManager.getString("_date", new Object[0]), dataset.date[this.position]);
            y += this.drawPrice(g2, y, StringManager.getString("_open", new Object[0]), dataset.open[this.position]);
            y += this.drawPrice(g2, y, StringManager.getString("_high", new Object[0]), dataset.high[this.position]);
            y += this.drawPrice(g2, y, StringManager.getString("_low", new Object[0]), dataset.low[this.position]);
            y += this.drawPrice(g2, y, StringManager.getString("_close", new Object[0]), dataset.close[this.position]);
            Color changeColor = Color.BLACK;
            if (dataset.change[this.position] != null) {
                UpDownColorType colors = this.settings.updownLineColors;
                if (dataset.change[this.position].doubleValue() > 0.0) {
                    changeColor = colors.getUpLineColor();
                } else if (dataset.change[this.position].doubleValue() < 0.0) {
                    changeColor = colors.getDownLineColor();
                }
            }
            y += this.drawChange(g2, y, this.type.getChangeLabel(), changeColor, dataset.change[this.position], dataset.percentChange[this.position]);
            ChartSettings.TimeSeriesSettings settings = this.settings.timeSeries;
            if (settings.volumeType != VolumeType.NONE) {
                if (dataset.volume != null) {
                    y += this.drawDecimal(g2, y, settings.volumeColor2, StringManager.getString("_volume", new Object[0]), dataset.volume[this.position], new int[0]);
                }
                if (settings.volumeType == VolumeType.MARGIN) {
                    if (dataset.bought != null) {
                        y += this.drawDecimal(g2, y, settings.boughtColor, StringManager.getString("_bought", new Object[0]), dataset.bought[this.position], new int[0]);
                    }
                    if (dataset.sold != null) {
                        y += this.drawDecimal(g2, y, settings.soldColor, StringManager.getString("_sold", new Object[0]), dataset.sold[this.position], new int[0]);
                    }
                }
            }
            y += this.drawHorizontalLine(g2, y);
            if (settings.avgprice && dataset.avgprice != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_avgprice", new Object[0]), dataset.avgprice[this.position], new int[0]);
            }
            if (settings.mp && dataset.mp != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_mp", new Object[0]), dataset.mp[this.position], new int[0]);
            }
            if (settings.tp && dataset.tp != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_tp", new Object[0]), dataset.tp[this.position], new int[0]);
            }
            if (settings.wc && dataset.wc != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_wc", new Object[0]), dataset.wc[this.position], new int[0]);
            }
            if (settings.zigzag && dataset.zigzag != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_zigzag", new Object[0]), dataset.zigzag[this.position], settings.zigzag_rate);
            }
            if (settings.ma) {
                if (dataset.ma1 != null) {
                    y += this.drawIndex(g2, y, settings.ma1Color, StringManager.getString("_ma", new Object[0]), dataset.ma1[this.position], settings.ma1Period);
                }
                if (dataset.ma2 != null) {
                    y += this.drawIndex(g2, y, settings.ma2Color, StringManager.getString("_ma", new Object[0]), dataset.ma2[this.position], settings.ma2Period);
                }
                if (dataset.ma_bias != null) {
                    y += this.drawIndex(g2, y, Color.BLACK, StringManager.getString("_ma.bias", new Object[0]), dataset.ma_bias[this.position], new int[0]);
                }
            }
            if (settings.bandType == BandType.ENVELOPE) {
                if (dataset.envelope_upper2 != null) {
                    y += this.drawIndex(g2, y, settings.envelopeUpper2Color, String.format(FORMAT_ENVELOPE, settings.envelopeRate * 2), dataset.envelope_upper2[this.position], new int[0]);
                }
                if (dataset.envelope_upper1 != null) {
                    y += this.drawIndex(g2, y, settings.envelopeUpper1Color, String.format(FORMAT_ENVELOPE, settings.envelopeRate), dataset.envelope_upper1[this.position], new int[0]);
                }
                if (dataset.envelope != null) {
                    y += this.drawIndex(g2, y, settings.envelopeColor, StringManager.getString("_ma", new Object[0]), dataset.envelope[this.position], settings.envelopePeriod);
                }
                if (dataset.envelope_lower1 != null) {
                    y += this.drawIndex(g2, y, settings.envelopeLower1Color, String.format(FORMAT_ENVELOPE, -settings.envelopeRate), dataset.envelope_lower1[this.position], new int[0]);
                }
                if (dataset.envelope_lower2 != null) {
                    y += this.drawIndex(g2, y, settings.envelopeLower2Color, String.format(FORMAT_ENVELOPE, -settings.envelopeRate * 2), dataset.envelope_lower2[this.position], new int[0]);
                }
            } else if (settings.bandType == BandType.HIGH_LOW_MOVING_AVERAGE) {
                if (dataset.hma != null) {
                    y += this.drawIndex(g2, y, settings.ma1Color, StringManager.getString("_support", new Object[0]), dataset.hma[this.position], settings.hmaPeriod);
                }
                if (dataset.lma != null) {
                    y += this.drawIndex(g2, y, settings.ma2Color, StringManager.getString("_resistance", new Object[0]), dataset.lma[this.position], settings.lmaPeriod);
                }
            } else if (settings.bandType == BandType.DONCHIAN) {
                if (dataset.donchian_upper != null) {
                    y += this.drawIndex(g2, y, settings.ma1Color, StringManager.getString("_support", new Object[0]), dataset.donchian_upper[this.position], settings.donchianPeriod);
                }
                if (dataset.donchian_lower != null) {
                    y += this.drawIndex(g2, y, settings.ma2Color, StringManager.getString("_resistance", new Object[0]), dataset.donchian_lower[this.position], settings.donchianPeriod);
                }
            } else if (settings.bandType == BandType.BOLLINGER_BANDS) {
                if (dataset.bb_upper2 != null) {
                    y += this.drawIndex(g2, y, settings.bbUpper2Color, StringManager.getString("_bb.upper2", new Object[0]), dataset.bb_upper2[this.position], new int[0]);
                }
                if (dataset.bb_upper1 != null) {
                    y += this.drawIndex(g2, y, settings.bbUpper1Color, StringManager.getString("_bb.upper1", new Object[0]), dataset.bb_upper1[this.position], new int[0]);
                }
                if (dataset.bb_tpma != null) {
                    y += this.drawIndex(g2, y, settings.bbColor, StringManager.getString("_bb.tpma", new Object[0]), dataset.bb_tpma[this.position], settings.bbPeriod);
                }
                if (dataset.bb_lower1 != null) {
                    y += this.drawIndex(g2, y, settings.bbLower1Color, StringManager.getString("_bb.lower1", new Object[0]), dataset.bb_lower1[this.position], new int[0]);
                }
                if (dataset.bb_lower2 != null) {
                    y += this.drawIndex(g2, y, settings.bbLower2Color, StringManager.getString("_bb.lower2", new Object[0]), dataset.bb_lower2[this.position], new int[0]);
                }
            } else if (settings.bandType == BandType.PARABOLIC_TIME_PRICE) {
                if (dataset.sar != null) {
                    y += this.drawIndex(g2, y, Color.BLACK, StringManager.getString("_parabolic", new Object[0]), dataset.sar[this.position], new int[0]);
                }
            } else if (settings.bandType == BandType.VIX) {
                if (dataset.vi_upper != null) {
                    y += this.drawIndex(g2, y, settings.viUpperColor, StringManager.getString("_vix.high", new Object[0]), dataset.vi_upper[this.position], settings.atrPeriod);
                }
                if (dataset.vi_lower != null) {
                    y += this.drawIndex(g2, y, settings.viLowerColor, StringManager.getString("_vix.low", new Object[0]), dataset.vi_lower[this.position], settings.atrPeriod);
                }
            } else if (settings.bandType == BandType.PIVOT) {
                if (dataset.pivot_hbop != null) {
                    y += this.drawIndex(g2, y, settings.pivotHBOPColor, StringManager.getString("_pivot.hbop", new Object[0]), dataset.pivot_hbop[this.position], new int[0]);
                }
                if (dataset.pivot_s2 != null) {
                    y += this.drawIndex(g2, y, settings.pivotS2Color, StringManager.getString("_pivot.s2", new Object[0]), dataset.pivot_s2[this.position], new int[0]);
                }
                if (dataset.pivot_s1 != null) {
                    y += this.drawIndex(g2, y, settings.pivotS1Color, StringManager.getString("_pivot.s1", new Object[0]), dataset.pivot_s1[this.position], new int[0]);
                }
                if (dataset.pivot != null) {
                    y += this.drawIndex(g2, y, settings.pivotColor, StringManager.getString("_pivot", new Object[0]), dataset.pivot[this.position], new int[0]);
                }
                if (dataset.pivot_b1 != null) {
                    y += this.drawIndex(g2, y, settings.pivotB1Color, StringManager.getString("_pivot.b1", new Object[0]), dataset.pivot_b1[this.position], new int[0]);
                }
                if (dataset.pivot_b2 != null) {
                    y += this.drawIndex(g2, y, settings.pivotB2Color, StringManager.getString("_pivot.b2", new Object[0]), dataset.pivot_b2[this.position], new int[0]);
                }
                if (dataset.pivot_lbop != null) {
                    y += this.drawIndex(g2, y, settings.pivotLBOPColor, StringManager.getString("_pivot.lbop", new Object[0]), dataset.pivot_lbop[this.position], new int[0]);
                }
            } else if (settings.bandType == BandType.ICHIMOKU) {
                if (dataset.kijun != null) {
                    y += this.drawIndex(g2, y, settings.ichimokuKijunColor, StringManager.getString("_ichimoku.kijun", new Object[0]), dataset.kijun[this.position], new int[0]);
                }
                if (dataset.tenkan != null) {
                    y += this.drawIndex(g2, y, settings.ichimokuTenkanColor, StringManager.getString("_ichimoku.tenkan", new Object[0]), dataset.tenkan[this.position], new int[0]);
                }
                if (dataset.senkou1 != null) {
                    y += this.drawIndex(g2, y, settings.ichimokuSenkou1Color, StringManager.getString("_ichimoku.senkou1", new Object[0]), dataset.senkou1[this.position], new int[0]);
                }
                if (dataset.senkou2 != null) {
                    y += this.drawIndex(g2, y, settings.ichimokuSenkou2Color, StringManager.getString("_ichimoku.senkou2", new Object[0]), dataset.senkou2[this.position], new int[0]);
                }
                if (dataset.chikou != null) {
                    y += this.drawIndex(g2, y, settings.ichimokuChikouColor, StringManager.getString("_ichimoku.chikou", new Object[0]), dataset.chikou[this.position], new int[0]);
                }
            } else if (settings.bandType == BandType.MESA) {
                if (dataset.mama != null) {
                    y += this.drawIndex(g2, y, settings.ma1Color, StringManager.getString("_mesa.mama", new Object[0]), dataset.mama[this.position], new int[0]);
                }
                if (dataset.fama != null) {
                    y += this.drawIndex(g2, y, settings.ma2Color, StringManager.getString("_mesa.fama", new Object[0]), dataset.fama[this.position], new int[0]);
                }
            }
            if (settings.volumeType == VolumeType.MOVING_AVERAGE) {
                if (dataset.vma1 != null) {
                    y += this.drawIndex(g2, y, settings.ma1Color, StringManager.getString("_vma", new Object[0]), dataset.vma1[this.position], settings.vma1Period);
                }
                if (dataset.vma2 != null) {
                    y += this.drawIndex(g2, y, settings.ma2Color, StringManager.getString("_vma", new Object[0]), dataset.vma2[this.position], settings.vma2Period);
                }
            }
            if (settings.aroon) {
                if (dataset.aroonUp != null) {
                    y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_aroon.up", new Object[0]), dataset.aroonUp[this.position], settings.aroonPeriod);
                }
                if (dataset.aroonDown != null) {
                    y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_aroon.down", new Object[0]), dataset.aroonDown[this.position], settings.aroonPeriod);
                }
                if (dataset.aroon != null) {
                    y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_aroon", new Object[0]), dataset.aroon[this.position], settings.aroonPeriod);
                }
            }
            if (settings.atr && dataset.atr != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_atr", new Object[0]), dataset.atr[this.position], settings.atr_period);
            }
            if (settings.natr && dataset.natr != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_natr", new Object[0]), dataset.natr[this.position], settings.natr_period);
            }
            if (settings.bop && dataset.bop != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_bmp", new Object[0]), dataset.bop[this.position], new int[0]);
            }
            if (settings.chv && dataset.chv != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_cv", new Object[0]), dataset.chv[this.position], settings.chv_period1, settings.chv_period2);
            }
            if (settings.cci && dataset.cci != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_cci", new Object[0]), dataset.cci[this.position], settings.cciPeriod);
            }
            if (settings.cmf && dataset.cmf != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_cmf", new Object[0]), dataset.cmf[this.position], settings.cmf_period);
            }
            if (settings.cmo && dataset.cmo != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_cmo", new Object[0]), dataset.cmo[this.position], settings.cmo_period);
            }
            if (settings.coppock && dataset.coppock != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_coppock", new Object[0]), dataset.coppock[this.position], settings.coppockPeriod);
            }
            if (settings.dpo && dataset.dpo != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_dpo", new Object[0]), dataset.dpo[this.position], settings.dpoPeriod);
            }
            if (settings.dmi) {
                if (dataset.pdi != null) {
                    y += this.drawIndex(g2, y, settings.pdiColor, StringManager.getString("_pdi", new Object[0]), dataset.pdi[this.position], settings.diPeriod);
                }
                if (dataset.mdi != null) {
                    y += this.drawIndex(g2, y, settings.mdiColor, StringManager.getString("_mdi", new Object[0]), dataset.mdi[this.position], settings.diPeriod);
                }
                if (dataset.adx != null) {
                    y += this.drawIndex(g2, y, settings.adxColor, StringManager.getString("_adx", new Object[0]), dataset.adx[this.position], settings.adxPeriod);
                }
            }
            if (settings.emv && dataset.emv != null) {
                y += this.drawRateIndex(g2, y, ChartColor.BLACK, StringManager.getString("_emv", new Object[0]), dataset.emv[this.position], settings.emv_period);
            }
            if (settings.hv && dataset.hv != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_hv", new Object[0]), dataset.hv[this.position], settings.hvPeriod);
            }
            if (settings.kairi && dataset.kairi != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_bias", new Object[0]), dataset.kairi[this.position], settings.biasPeriod);
            }
            if (settings.mi && dataset.mi != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_mi", new Object[0]), dataset.mi[this.position], settings.miMaPeriod, settings.miSumPeriod);
            }
            if (settings.mom && dataset.mom != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_momentum", new Object[0]), dataset.mom[this.position], settings.mom_period);
            }
            if (settings.mfi && dataset.mfi != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_mfi", new Object[0]), dataset.mfi[this.position], settings.mfiPeriod);
            }
            if (settings.macd) {
                if (dataset.macd != null) {
                    y += this.drawIndex(g2, y, settings.macdColor, StringManager.getString("_macd", new Object[0]), dataset.macd[this.position], settings.macdMa1Period, settings.macdMa2Period);
                }
                if (dataset.macdSignal != null) {
                    y += this.drawIndex(g2, y, settings.macdSignalColor, StringManager.getString("_signal", new Object[0]), dataset.macdSignal[this.position], settings.macdSignalPeriod);
                }
            }
            if (settings.pain && dataset.pain != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_pain", new Object[0]), dataset.pain[this.position], new int[0]);
            }
            if (settings.pcr && dataset.pcr != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_pcr", new Object[0]), dataset.pcr[this.position], settings.pcr_period);
            }
            if (settings.apo && dataset.apo != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_apo", new Object[0]), dataset.apo[this.position], settings.apoMa1Period, settings.apoMa2Period);
            }
            if (settings.ppo && dataset.ppo != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_ppo", new Object[0]), dataset.ppo[this.position], settings.ppoMa1Period, settings.ppoMa2Period);
            }
            if (settings.psy && dataset.psy != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_psychological", new Object[0]), dataset.psy[this.position], settings.psy_period);
            }
            if (settings.qstick && dataset.qstick != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_qstick", new Object[0]), dataset.qstick[this.position], settings.qstick_period);
            }
            if (settings.rci && dataset.rci != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_rci", new Object[0]), dataset.rci[this.position], settings.rciPeriod);
            }
            if (settings.roc && dataset.roc != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_roc", new Object[0]), dataset.roc[this.position], settings.rocPeriod);
            }
            if (settings.rsi && dataset.rsi != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_rsi", new Object[0]), dataset.rsi[this.position], settings.rsiPeriod);
            }
            if (settings.rvi && dataset.rvi != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_rvi", new Object[0]), dataset.rvi[this.position], settings.rvi_period);
            }
            if (settings.shinohara) {
                if (dataset.shinohara_a != null) {
                    y += this.drawIndex(g2, y, settings.oscillatorColor1, StringManager.getString("_shinohara.a", new Object[0]), dataset.shinohara_a[this.position], settings.shinoharaPeriod);
                }
                if (dataset.shinohara_b != null) {
                    y += this.drawIndex(g2, y, settings.oscillatorColor2, StringManager.getString("_shinohara.b", new Object[0]), dataset.shinohara_b[this.position], settings.shinoharaPeriod);
                }
            }
            if (settings.srv) {
                if (dataset.srvK != null) {
                    y += this.drawIndex(g2, y, settings.oscillatorColor1, StringManager.getString("_srv.k", new Object[0]), dataset.srvK[this.position], settings.srvKPeriod);
                }
                if (dataset.srvD != null) {
                    y += this.drawIndex(g2, y, settings.oscillatorColor2, StringManager.getString("_srv.d", new Object[0]), dataset.srvD[this.position], settings.srvDPeriod);
                }
                if (dataset.srvSD != null) {
                    y += this.drawIndex(g2, y, settings.oscillatorColor3, StringManager.getString("_srv.sd", new Object[0]), dataset.srvSD[this.position], new int[0]);
                }
            }
            if (settings.tii && dataset.tii != null) {
                y += this.drawIndex(g2, y, settings.oscillatorColor1, StringManager.getString("_tii", new Object[0]), dataset.tii[this.position], settings.tii_period);
            }
            if (settings.trix) {
                if (dataset.trix != null) {
                    y += this.drawIndex(g2, y, settings.macdColor, StringManager.getString("_trix", new Object[0]), dataset.trix[this.position], settings.trixPeriod);
                }
                if (dataset.trixSignal != null) {
                    y += this.drawIndex(g2, y, settings.macdSignalColor, StringManager.getString("_signal", new Object[0]), dataset.trixSignal[this.position], settings.trixSignalPeriod);
                }
            }
            if (settings.tsi) {
                if (dataset.tsi != null) {
                    y += this.drawIndex(g2, y, settings.macdColor, StringManager.getString("_tsi", new Object[0]), dataset.tsi[this.position], settings.tsi_period1, settings.tsi_period2);
                }
                if (dataset.tsi_signal != null) {
                    y += this.drawIndex(g2, y, settings.macdSignalColor, StringManager.getString("_signal", new Object[0]), dataset.tsi_signal[this.position], settings.tsi_signal_period);
                }
            }
            if (settings.ultimate && dataset.ultimate != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_ultimate", new Object[0]), dataset.ultimate[this.position], settings.ultimatePeriod);
            }
            if (settings.wad && dataset.wad != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_wad", new Object[0]), dataset.wad[this.position], new int[0]);
            }
            if (settings.williamsR && dataset.williamsR != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_williamsr", new Object[0]), dataset.williamsR[this.position], settings.williamsRPeriod);
            }
            if (settings.ad && dataset.ad != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_ad", new Object[0]), dataset.ad[this.position], new int[0]);
            }
            if (settings.cho && dataset.cho != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_cho", new Object[0]), dataset.cho[this.position], new int[0]);
            }
            if (settings.avo && dataset.avo != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_avo", new Object[0]), dataset.avo[this.position], settings.avoMa1Period, settings.avoMa2Period);
            }
            if (settings.pvo && dataset.pvo != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_pvo", new Object[0]), dataset.pvo[this.position], settings.pvoMa1Period, settings.pvoMa2Period);
            }
            if (settings.vkairi && dataset.vkairi != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_vbias", new Object[0]), dataset.vkairi[this.position], settings.vbiasPeriod);
            }
            if (settings.vr1 && dataset.vr1 != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_vr1", new Object[0]), dataset.vr1[this.position], settings.vr1Period);
            }
            if (settings.vr2 && dataset.vr2 != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_vr2", new Object[0]), dataset.vr2[this.position], settings.vr2Period);
            }
            if (settings.vroc && dataset.vroc != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_vroc", new Object[0]), dataset.vroc[this.position], settings.vrocPeriod);
            }
            if (settings.vrsi && dataset.vrsi != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_vrsi", new Object[0]), dataset.vrsi[this.position], settings.vrsiPeriod);
            }
            if (settings.wvr && dataset.wvr != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_wvr", new Object[0]), dataset.wvr[this.position], settings.wvrPeriod);
            }
            if (settings.pvi) {
                if (dataset.pvi != null) {
                    y += this.drawIndex(g2, y, settings.oscillatorColor3, StringManager.getString("_pvi", new Object[0]), dataset.pvi[this.position], new int[0]);
                }
                if (dataset.pvi_ma1 != null) {
                    y += this.drawIndex(g2, y, settings.oscillatorColor1, StringManager.getString("_ma", new Object[0]), dataset.pvi_ma1[this.position], settings.pvi_fast);
                }
                if (dataset.pvi_ma2 != null) {
                    y += this.drawIndex(g2, y, settings.oscillatorColor2, StringManager.getString("_ma", new Object[0]), dataset.pvi_ma2[this.position], settings.pvi_slow);
                }
            }
            if (settings.nvi) {
                if (dataset.nvi != null) {
                    y += this.drawIndex(g2, y, settings.oscillatorColor3, StringManager.getString("_nvi", new Object[0]), dataset.nvi[this.position], new int[0]);
                }
                if (dataset.nvi_ma1 != null) {
                    y += this.drawIndex(g2, y, settings.oscillatorColor1, StringManager.getString("_ma", new Object[0]), dataset.nvi_ma1[this.position], settings.nvi_fast);
                }
                if (dataset.nvi_ma2 != null) {
                    y += this.drawIndex(g2, y, settings.oscillatorColor2, StringManager.getString("_ma", new Object[0]), dataset.nvi_ma2[this.position], settings.nvi_slow);
                }
            }
            if (settings.obv && dataset.obv != null) {
                y += this.drawDecimal(g2, y, ChartColor.BLACK, StringManager.getString("_obv", new Object[0]), dataset.obv[this.position], settings.obvPeriod);
            }
            if (this.info instanceof VolumePriceHistogram) {
                VolumePriceHistogram vph = (VolumePriceHistogram)this.info;
                y += this.drawPrice(g2, y, StringManager.getString("_vp", new Object[0]), vph.upper);
                y += this.drawPrice(g2, y, StringManager.getString("_vp", new Object[0]), vph.lower);
                y += this.drawDecimal(g2, y, settings.volumeColor2, StringManager.getString("_volume", new Object[0]), vph.volume, new int[0]);
            }
            if (settings.ratio && dataset.ratio != null) {
                y += this.drawRatio(g2, y, StringManager.getString("_ratio", new Object[0]), dataset.ratio[this.position]);
            }
            if (settings.price_performance && dataset.price_performance != null) {
                y += this.drawPrice(g2, y, StringManager.getString("_fluctuations.price", new Object[0]), dataset.price_performance[this.position]);
            }
            if (settings.percent_performance && dataset.percent_performance != null) {
                y += this.drawIndex(g2, y, ChartColor.BLACK, StringManager.getString("_fluctuations", new Object[0]), dataset.percent_performance[this.position], new int[0]);
            }
        } else if (this.dataset instanceof StepChartDataset) {
            StepChartDataset dataset = (StepChartDataset)this.dataset;
            Date startDate = dataset.startDate[this.start];
            Date endDate = dataset.endDate[this.start + this.period - 1];
            if (startDate == null && endDate == null) {
                return;
            }
            y += this.drawDateRange(g2, y, startDate, endDate);
            y += this.drawHorizontalLine(g2, y);
            y += this.drawDate(g2, y, StringManager.getString("_high.date", new Object[0]), dataset.highDate[this.position]);
            y += this.drawPrice(g2, y, StringManager.getString("_high", new Object[0]), dataset.high[this.position]);
            y += this.drawDate(g2, y, StringManager.getString("_low.date", new Object[0]), dataset.lowDate[this.position]);
            y += this.drawPrice(g2, y, StringManager.getString("_low", new Object[0]), dataset.low[this.position]);
            if (dataset.point != 0.0) {
                y += this.drawHorizontalLine(g2, y);
                y += this.drawPrice(g2, y, StringManager.getString("_difference", new Object[0]), dataset.point);
            }
        } else if (this.dataset instanceof AntiWatchChartDataset) {
            AntiWatchChartDataset dataset = (AntiWatchChartDataset)this.dataset;
            Date startDate = dataset.date[this.start];
            Date endDate = dataset.date[this.start + this.period - 1];
            if (startDate == null && endDate == null) {
                return;
            }
            y += this.drawDateRange(g2, y, startDate, endDate);
            y += this.drawHorizontalLine(g2, y);
        } else {
            throw new RuntimeException();
        }
    }

    private int drawDateRange(Graphics2D g2, int y, Date date1, Date date2) {
        StringBuilder sb = new StringBuilder(30);
        if (date1 != null) {
            sb.append(String.format(FORMAT_DATE, date1));
        }
        sb.append(" - ");
        sb.append(String.format(FORMAT_DATE, date2));
        return this.drawValue(g2, y, Color.BLACK, sb.toString());
    }

    private int drawHorizontalLine(Graphics2D g2, float y) {
        float _y = y + 4.0f;
        g2.setColor(ChartColor.SKY_BLUE);
        g2.draw(new Line2D.Double(4.0, _y, this.getWidth() - 4, _y));
        return 5;
    }

    private int drawDate(Graphics2D g2, int y, String label, Date date) {
        int h1 = this.ascent;
        if (label != null) {
            h1 = this.drawLabel(g2, y, ChartColor.BLACK, label, new int[0]);
        }
        int h2 = this.ascent;
        if (date != null) {
            h2 = this.drawValue(g2, y, ChartColor.BLACK, String.format(FORMAT_DATE, date));
        }
        return Math.max(h1, h2);
    }

    private int drawDecimal(Graphics2D g2, int y, Color labelColor, String label, Number value, int ... period) {
        return this.drawNumber(g2, y, labelColor, label, Color.BLACK, value, FORMAT_DECIMAL, period);
    }

    private int drawPrice(Graphics2D g2, int y, String label, Number value) {
        return this.drawNumber(g2, y, Color.BLACK, label, Color.BLACK, value, this.formatPrice, new int[0]);
    }

    private int drawChange(Graphics2D g2, int y, String label, Color color, Number change, Number percentChange) {
        return Math.max(this.drawNumber(g2, y, Color.BLACK, label, color, change, this.formatChange, percentChange, this.formatPercentChange), this.ascent + g2.getFontMetrics(FontConstants.FONT_INDEX_SMALL).getAscent());
    }

    private int drawRatio(Graphics2D g2, int y, String label, Number ratio) {
        return this.drawNumber(g2, y, Color.BLACK, label, Color.BLACK, ratio, this.formatRatio, new int[0]);
    }

    private int drawIndex(Graphics2D g2, int y, Color labelColor, String label, Number value, int ... period) {
        return this.drawNumber(g2, y, labelColor, label, Color.BLACK, value, this.formatIndex, period);
    }

    private int drawRateIndex(Graphics2D g2, int y, Color labelColor, String label, Number value, int ... period) {
        return this.drawNumber(g2, y, labelColor, label, Color.BLACK, value, this.formatRateIndex, period);
    }

    private int drawNumber(Graphics2D g2, int y, Color labelColor, String label, Color valueColor, Number value, String format, int ... period) {
        int h1 = this.ascent;
        if (label != null) {
            h1 = this.drawLabel(g2, y, labelColor, label, period);
        }
        int h2 = this.ascent;
        if (value != null) {
            h2 = this.drawValue(g2, y, valueColor, String.format(format, value.doubleValue()));
        }
        return Math.max(h1, h2);
    }

    private int drawNumber(Graphics2D g2, int y, Color labelColor, String label, Color valueColor, Number value, String format1, Number value2, String format2) {
        int h1 = this.ascent;
        if (label != null) {
            h1 = this.drawLabel(g2, y, labelColor, label, new int[0]);
        }
        int h2 = this.ascent;
        if (value != null) {
            h2 = this.drawValue(g2, y, valueColor, String.format(format1, value.doubleValue()), String.format(format2, value2));
        }
        return Math.max(h1, h2);
    }

    private int drawLabel(Graphics2D g2, int y, Color color, String label, int ... period) {
        int _y = y + this.ascent;
        g2.setFont(FontConstants.FONT_MESSAGE);
        DrawUtils.drawText(g2, label, 4.0f, _y, color);
        double w = g2.getFontMetrics().stringWidth(label) + 2;
        if (period.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int p : period) {
                if (sb.length() > 0) {
                    sb.append('-');
                }
                sb.append(p);
            }
            sb.insert(0, '[');
            sb.append(']');
            g2.setFont(FontConstants.FONT_INDEX);
            DrawUtils.drawText(g2, sb.toString(), (float)(4.0 + w), _y);
        }
        return this.ascent;
    }

    private int drawValue(Graphics2D g2, int y, Color color, String ... text) {
        int _y = y + this.ascent;
        for (int i = 0; i < text.length; ++i) {
            String s = text[i];
            if (i == 0) {
                g2.setFont(FontConstants.FONT_INDEX);
            } else {
                g2.setFont(FontConstants.FONT_INDEX_SMALL);
                _y += g2.getFontMetrics().getAscent();
            }
            DrawUtils.drawText(g2, s, this.getWidth() - g2.getFontMetrics().stringWidth(s) - 4, _y, color);
        }
        return _y - y;
    }
}

