/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.event;

import java.util.Date;
import java.util.EventObject;
import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.data.ChartDataset;
import jp.sf.orangesignal.chart.data.StepChartDataset;
import jp.sf.orangesignal.chart.ui.DatasetType;
import jp.sf.orangesignal.chart.ui.PeriodType;
import jp.sf.orangesignal.ta.util.DateArrayUtils;

public class ChartEvent
extends EventObject {
    private static final long serialVersionUID = 2379530553680606953L;
    private transient ChartDataset dataset;
    private transient DatasetType datasetType;
    private transient PeriodType periodType;
    private int start;
    private boolean ignoreStart;
    private int period;
    private transient ChartSettings settings;

    public ChartEvent(Object source, ChartDataset dataset, DatasetType datasetType, PeriodType periodType, boolean ignoreStart, ChartSettings settings) {
        super(source);
        this.dataset = dataset;
        this.datasetType = datasetType;
        this.periodType = periodType;
        this.ignoreStart = ignoreStart;
        this.settings = settings;
        if (this.dataset == null || this.dataset.getCount() <= 0) {
            this.start = 0;
            this.period = 0;
        } else if (this.dataset instanceof StepChartDataset) {
            StepChartDataset stepDataset = (StepChartDataset)this.dataset;
            this.start = DateArrayUtils.lastIndexOf((Date[])stepDataset.startDate, (Date)this.periodType.getPreviousDate(stepDataset.endDate[stepDataset.endDate.length - 1]));
            if (this.start == -1) {
                this.start = 0;
            }
            int len = this.dataset.getCount();
            this.period = len - this.start;
            if (this.period <= 1) {
                this.period = Math.min(3, len);
                this.start = len - this.period;
                if (this.start < 0) {
                    this.start = 0;
                }
            }
        } else {
            this.period = this.periodType.getPeriod(this.datasetType);
            if (this.period <= 0 || this.period > this.dataset.getCount()) {
                this.period = this.dataset.getCount();
            }
            this.start = this.dataset.getCount() - this.period;
            if (this.start < 0) {
                this.start = 0;
            }
        }
    }

    public ChartDataset getDataset() {
        return this.dataset;
    }

    public DatasetType getType() {
        return this.datasetType;
    }

    public PeriodType getPeriodType() {
        return this.periodType;
    }

    public int getStart() {
        return this.start;
    }

    public boolean isIgnoreStart() {
        return this.ignoreStart;
    }

    public int getPeriod() {
        return this.period;
    }

    public ChartSettings getSettings() {
        return this.settings;
    }
}

