/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.screen;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.event.ChartListener;
import jp.sf.orangesignal.chart.event.ChartScreenListener;
import jp.sf.orangesignal.chart.event.SideScreenEvent;
import jp.sf.orangesignal.chart.event.SideScreenListener;
import jp.sf.orangesignal.chart.ui.ChartScreenType;
import jp.sf.orangesignal.chart.ui.MAType;

public abstract class SideScreen
extends JPanel
implements ChartListener,
ChartScreenListener,
ActionListener,
ItemListener,
ChangeListener {
    private static final long serialVersionUID = 2348198897483327747L;
    public static final int SIDE_SCREEN_BASE_WIDTH = 190;
    public static final int SIDE_SCREEN_WIDTH = 216;
    protected final List<SideScreenListener> listeners = new ArrayList<SideScreenListener>(1);
    protected boolean notify = false;
    private ChartScreenType screenType = null;
    private static final MAType[] ma = MAType.values();

    public void addSideScreenListener(SideScreenListener listener) {
        this.listeners.add(listener);
    }

    protected final void send() {
        if (this.notify) {
            SideScreenEvent event = new SideScreenEvent(this);
            for (SideScreenListener listener : this.listeners) {
                listener.optionChanged(event);
            }
        }
    }

    public final ChartScreenType getScreenType() {
        return this.screenType;
    }

    public final void setScreenType(ChartScreenType screenType) {
        this.screenType = screenType;
    }

    protected static final JComboBox createMovingAverageJComboBox() {
        return new JComboBox<MAType>(ma);
    }

    protected final void addCanvas(GridBagLayout layout, GridBagConstraints c, int y, Canvas canvas) {
        c.fill = 1;
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 2;
        c.weighty = 100.0;
        c.anchor = 11;
        c.insets = new Insets(0, 0, 0, 0);
        layout.setConstraints(canvas, c);
        this.add(canvas);
    }

    protected final void addLabel(GridBagLayout layout, GridBagConstraints c, int y, JLabel label) {
        c.fill = 0;
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 2;
        c.weighty = 0.0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 2, 0);
        layout.setConstraints(label, c);
        this.add(label);
    }

    protected final void addCheckBox(GridBagLayout layout, GridBagConstraints c, int y, JCheckBox check) {
        check.setOpaque(false);
        check.addItemListener(this);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 2;
        c.weighty = 0.0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        layout.setConstraints(check, c);
        this.add(check);
    }

    protected final void addComboBox(GridBagLayout layout, GridBagConstraints c, int y, JLabel label, JComboBox combo) {
        combo.setOpaque(false);
        combo.addActionListener(this);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.anchor = 13;
        c.insets = new Insets(0, 0, 0, 4);
        layout.setConstraints(label, c);
        this.add(label);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = y;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 1, 0);
        layout.setConstraints(combo, c);
        this.add(combo);
    }

    protected final void addPanel(GridBagLayout layout, GridBagConstraints c, int y, JPanel panel) {
        c.fill = 0;
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 2;
        c.weighty = 0.0;
        c.anchor = 13;
        c.insets = new Insets(0, 0, 0, 0);
        layout.setConstraints(panel, c);
        this.add(panel);
    }

    protected final void addSeparator(GridBagLayout layout, GridBagConstraints c, int y) {
        c.fill = 2;
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 2;
        c.weighty = 0.0;
        c.anchor = 10;
        c.insets = new Insets(2, 0, 2, 0);
        JSeparator separator = new JSeparator();
        separator.setPreferredSize(new Dimension(190, 1));
        layout.setConstraints(separator, c);
        this.add(separator);
    }

    protected final void addLastSpace(GridBagLayout layout, GridBagConstraints c, int y) {
        JPanel panel = new JPanel();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 2;
        c.weighty = 100.0;
        c.anchor = 15;
        c.insets = new Insets(0, 0, 0, 0);
        layout.setConstraints(panel, c);
        this.add(panel);
    }

    protected final void addSubComboBox(JPanel panel, GridBagLayout layout, GridBagConstraints c, int y, JLabel label, JComboBox combo) {
        combo.setOpaque(false);
        combo.addActionListener(this);
        JPanel _panel = new JPanel();
        GridBagLayout _layout = new GridBagLayout();
        GridBagConstraints _c = new GridBagConstraints();
        _panel.setLayout(_layout);
        _c.gridx = 0;
        _c.insets = new Insets(0, 0, 0, 4);
        _layout.setConstraints(label, _c);
        _panel.add(label);
        _c.gridx = 1;
        _layout.setConstraints(combo, _c);
        _panel.add(combo);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.anchor = 13;
        c.insets = new Insets(1, 0, 1, 0);
        layout.setConstraints(_panel, c);
        panel.add(_panel);
    }

    protected final void addSubSpinner(JPanel panel, GridBagLayout layout, GridBagConstraints c, int y, JLabel label, JSpinner spinner) {
        spinner.setOpaque(false);
        spinner.addChangeListener(this);
        JPanel _panel = new JPanel();
        GridBagLayout _layout = new GridBagLayout();
        GridBagConstraints _c = new GridBagConstraints();
        _panel.setLayout(_layout);
        _c.gridx = 0;
        _c.insets = new Insets(0, 0, 0, 4);
        _layout.setConstraints(label, _c);
        _panel.add(label);
        spinner.setPreferredSize(new Dimension(60, 20));
        spinner.setFont(new Font("Verdana", 0, 10));
        _c.gridx = 1;
        _layout.setConstraints(spinner, _c);
        _panel.add(spinner);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.anchor = 13;
        c.insets = new Insets(1, 0, 1, 0);
        layout.setConstraints(_panel, c);
        panel.add(_panel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.send();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.send();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.send();
    }

    public abstract void save(ChartSettings var1);

    public abstract void load(ChartSettings var1);

    public void setVisibleAdvancedOptions(boolean visible) {
    }
}

