/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.canvas;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import jp.sf.orangesignal.chart.ChartColor;
import jp.sf.orangesignal.chart.FontConstants;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.ui.canvas.DoubleBufferedCanvas;
import jp.sf.orangesignal.chart.util.DrawUtils;
import jp.sf.orangesignal.chart.util.StringManager;
import jp.sf.orangesignal.ta.util.StringUtils;

public abstract class AbstractChartCanvas
extends DoubleBufferedCanvas {
    private static final long serialVersionUID = -4148557430424577501L;

    public AbstractChartCanvas() {
        this.setBackground(Color.WHITE);
    }

    @Override
    public void setRenderingHints(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    public abstract void switchDataset(ChartEvent var1);

    public abstract void setStart(int var1);

    protected static final void addDescription(StringBuilder sb, String text) {
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        if (sb.length() > 0) {
            sb.append(StringManager.getString("conjunction", new Object[0]));
        }
        sb.append(text);
    }

    protected static final void drawDescription(Graphics2D g2, Rectangle2D area, String text) {
        g2.setFont(FontConstants.FONT_GUI);
        float x = (float)area.getMinX();
        float y = (float)area.getMinY() + (float)g2.getFontMetrics().getAscent();
        DrawUtils.drawText(g2, text, x, y, ChartColor.GRAY);
    }
}

