/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.axis;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.sf.orangesignal.chart.ChartColor;
import jp.sf.orangesignal.chart.axis.Axis;
import jp.sf.orangesignal.chart.axis.IntervalMarker;
import jp.sf.orangesignal.chart.axis.Marker;
import jp.sf.orangesignal.chart.axis.NumberTickUnit;
import jp.sf.orangesignal.chart.axis.NumberTickUnits;
import jp.sf.orangesignal.chart.axis.Orientation;
import jp.sf.orangesignal.chart.axis.Range;
import jp.sf.orangesignal.chart.axis.ValueMarker;
import jp.sf.orangesignal.chart.ui.PriceScaleType;
import jp.sf.orangesignal.chart.util.DrawUtils;

public class NumberAxis
extends Axis {
    private RangeType rangeType = RangeType.FULL;
    private Double fixedLower = null;
    private Double fixedUpper = null;
    private double lowerPadding = 0.0;
    private double upperPadding = 0.0;
    private double lowerMargin = 0.0;
    private double upperMargin = 0.0;
    private static final double DEFAULT_MIN_RANGE = 0.0;
    private static final double DEFAULT_MAX_RANGE = 1.0;
    private Range range = new Range(0.0, 1.0);
    private Double[] uppers = null;
    private Double[] lowers = null;
    protected boolean visibleTickmark = true;
    private PriceScaleType scale = PriceScaleType.NORMAL;
    private final NumberTickUnits units = new NumberTickUnits();
    private List<Double> ticks;
    private static final int MAX_TICK_COUNT = 500;
    private static int MINIMUM_DRAW_WIDTH = 100;
    private static int MINIMUM_DRAW_HEIGHT = 100;
    private boolean visibleMarker = true;
    private final List<Marker> markers = new ArrayList<Marker>(0);
    private Stroke lineMarkerStroke = new BasicStroke(1.0f, 0, 0);
    private Composite markerComposite = AlphaComposite.getInstance(3, 0.5f);

    public void setRangeType(RangeType rangeType) {
        this.rangeType = rangeType;
    }

    public void setFixedLower(Double fixedLower) {
        this.fixedLower = fixedLower;
        if (this.fixedLower != null && this.fixedUpper != null) {
            this.setRange(fixedLower, this.fixedUpper);
        }
    }

    public void setFixedUpper(Double fixedUpper) {
        this.fixedUpper = fixedUpper;
        if (this.fixedLower != null && this.fixedUpper != null) {
            this.setRange(this.fixedLower, fixedUpper);
        }
    }

    public void setLowerPadding(double lowerPadding) {
        this.lowerPadding = lowerPadding;
    }

    public void setUpperPadding(double upperPadding) {
        this.upperPadding = upperPadding;
    }

    public void setLowerMargin(double lowerMargin) {
        this.lowerMargin = lowerMargin;
    }

    public void setUpperMargin(double upperMargin) {
        this.upperMargin = upperMargin;
    }

    public Range getRange() {
        return this.range;
    }

    private void setRange(double lower, double upper) {
        double range = upper - lower;
        double l = this.fixedLower != null ? this.fixedLower : lower - range * this.lowerPadding;
        double u = this.fixedUpper != null ? this.fixedUpper : upper + range * this.upperPadding;
        switch (this.rangeType) {
            case POSITIVE: {
                u = Math.max(u, 0.0);
                l = Math.max(l, 0.0);
                break;
            }
            case NEGATIVE: {
                u = Math.min(u, 0.0);
                l = Math.min(l, 0.0);
                break;
            }
        }
        this.range = new Range(l, u);
    }

    public void prepare(Number[][] dataset) {
        this.prepare(dataset, 0.0);
    }

    public void prepare(Number[][] dataset, double margin) {
        int i;
        if (dataset == null || dataset.length <= 0) {
            this.uppers = null;
            this.lowers = null;
            return;
        }
        int length = 0;
        for (i = 0; i < dataset.length; ++i) {
            if (dataset[i] == null) continue;
            length = dataset[i].length;
            break;
        }
        this.uppers = new Double[length];
        this.lowers = new Double[length];
        for (i = 0; i < dataset.length; ++i) {
            Number[] data = dataset[i];
            if (data == null) continue;
            for (int j = 0; j < Math.min(data.length, length); ++j) {
                if (data[j] == null) continue;
                double value = data[j].doubleValue();
                if (this.uppers[j] == null || this.uppers[j] < value + margin) {
                    this.uppers[j] = value + margin;
                }
                if (this.lowers[j] != null && !(this.lowers[j] > value - margin)) continue;
                this.lowers[j] = value - margin;
            }
        }
    }

    public void autoAdjustRange(int start, int period) {
        Double upper = null;
        Double lower = null;
        if (this.uppers != null && this.lowers != null) {
            for (int i = start; i < start + period; ++i) {
                double value;
                if (i < 0 || i >= this.uppers.length) continue;
                if (this.uppers[i] != null) {
                    value = this.uppers[i];
                    if (upper == null || upper < value) {
                        upper = value;
                    }
                }
                if (this.lowers[i] == null) continue;
                value = this.lowers[i];
                if (lower != null && !(lower > value)) continue;
                lower = value;
            }
        }
        if (lower == null) {
            lower = 0.0;
        }
        if (upper == null) {
            upper = 1.0;
        }
        if (lower.compareTo(upper) == 0) {
            upper = upper + 0.1;
            lower = lower - 0.1;
        }
        this.setRange(lower, upper);
    }

    public void setScale(PriceScaleType scale) {
        this.scale = scale;
    }

    @Override
    public void refreshTicks() {
        double currentTickValue;
        double size = this.range.getLength() / (double)this.getTickCount();
        NumberTickUnit unit = this.units.getCeilingTickUnit(size);
        double lowestTickValue = Math.ceil(this.range.getLower() / unit.getSize()) * unit.getSize();
        int max = Math.min(this.getTickCount(), 500);
        this.ticks = new ArrayList<Double>(max);
        for (int i = 0; i < max && !((currentTickValue = lowestTickValue + (double)i * unit.getSize()) > this.range.getUpper()); ++i) {
            this.ticks.add(currentTickValue);
        }
    }

    @Override
    public void refreshTicks(Graphics2D g2, Rectangle2D area) {
        int tickCount;
        FontMetrics fm = g2.getFontMetrics(FONT);
        if (this.getOrientation() == Orientation.VERTICAL) {
            tickCount = (int)Math.ceil(Math.max(area.getHeight(), (double)MINIMUM_DRAW_HEIGHT) / ((double)fm.getAscent() * this.getGap()));
        } else if (this.getOrientation() == Orientation.HORIZONTAL) {
            tickCount = (int)Math.ceil(Math.max(area.getWidth(), (double)MINIMUM_DRAW_WIDTH) / ((double)fm.stringWidth(this.getSampleText()) * this.getGap()));
        } else {
            throw new RuntimeException();
        }
        this.setTickCount(tickCount);
        this.refreshTicks();
    }

    private String getSampleText() {
        switch (this.rangeType) {
            case POSITIVE: {
                return this.valueToString(this.range.getUpper());
            }
            case NEGATIVE: {
                return this.valueToString(this.range.getLower());
            }
        }
        if (this.range.getUpper() > Math.abs(this.range.getLower())) {
            return this.valueToString(this.range.getUpper());
        }
        return this.valueToString(this.range.getUpper());
    }

    public void addMarker(Marker marker) {
        this.markers.add(marker);
    }

    public void removeIntervalMarkers() {
        for (int i = this.markers.size() - 1; i >= 0; --i) {
            if (!(this.markers.get(i) instanceof IntervalMarker)) continue;
            this.markers.remove(i);
        }
    }

    public Stroke getLineMarkerStroke() {
        return this.lineMarkerStroke;
    }

    public void setLineMarkerStroke(Stroke stroke) {
        this.lineMarkerStroke = stroke;
    }

    public Composite getMarkerComposite() {
        return this.markerComposite;
    }

    public void setMarkerComposite(Composite composite) {
        this.markerComposite = composite;
    }

    private void drawMarkers(Graphics2D g2, Rectangle2D area) {
        Shape saved = g2.getClip();
        g2.setClip(area);
        for (Marker marker : this.markers) {
            Serializable m;
            if (marker instanceof ValueMarker) {
                m = (ValueMarker)marker;
                double y = this.valueToJava2D(((ValueMarker)m).getValue(), area);
                g2.setColor(((ValueMarker)m).getColor());
                g2.setStroke(this.lineMarkerStroke);
                g2.draw(new Line2D.Double(area.getMinX(), y, area.getMaxX(), y));
                continue;
            }
            if (marker instanceof IntervalMarker) {
                m = (IntervalMarker)marker;
                double y1 = this.valueToJava2D(((IntervalMarker)m).getUpper() == null ? this.range.getUpper() : ((IntervalMarker)m).getUpper().doubleValue(), area);
                double y2 = this.valueToJava2D(((IntervalMarker)m).getLower() == null ? this.range.getLower() : ((IntervalMarker)m).getLower().doubleValue(), area);
                Composite originalComposite = g2.getComposite();
                g2.setComposite(this.markerComposite);
                g2.setColor(((IntervalMarker)m).getColor());
                g2.fill(new Rectangle2D.Double(area.getMinX(), y1, area.getWidth(), y2 - y1));
                g2.setComposite(originalComposite);
                continue;
            }
            throw new RuntimeException();
        }
        g2.setClip(saved);
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        if (this.getOrientation() == Orientation.VERTICAL) {
            this.drawVertical(g2, area);
        } else if (this.getOrientation() == Orientation.HORIZONTAL) {
            this.drawHorizontal(g2, area);
        } else {
            throw new RuntimeException();
        }
    }

    public void drawGlidline(Graphics2D g2, Rectangle2D area) {
        for (double tick : this.ticks) {
            double y = this.valueToJava2D(tick, area);
            this.drawGlidline(g2, area.getMinX(), y, area.getMaxX(), y);
        }
    }

    private void drawVertical(Graphics2D g2, Rectangle2D area) {
        g2.setFont(FONT);
        double right = area.getMinX() - (double)this.getTickMarkOutsideLength();
        if (this.visibleTickmark) {
            FontMetrics fm = g2.getFontMetrics();
            int descent = fm.getDescent();
            for (double tick : this.ticks) {
                double y = this.valueToJava2D(tick, area);
                this.drawGlidline(g2, area.getMinX(), y, area.getMaxX(), y);
                this.drawTickMark(g2, right - (double)this.getTickMarkInsideLength(), y, right, y);
                String label = this.valueToString(tick);
                double x = right - (double)this.getTickMarkInsideLength() - (double)this.getTickWidthMargin() - (double)fm.stringWidth(label);
                DrawUtils.drawText(g2, label, (float)x, (float)(y + (double)descent));
            }
        }
        if (this.visibleMarker) {
            this.drawMarkers(g2, area);
        }
        this.drawAxisLine(g2, right, area.getMinY(), right, area.getMaxY());
    }

    private void drawHorizontal(Graphics2D g2, Rectangle2D area) {
        g2.setFont(FONT);
        double top = area.getMaxY() + (double)this.getTickMarkOutsideLength();
        if (this.visibleTickmark) {
            FontMetrics fm = g2.getFontMetrics();
            int ascent = fm.getAscent();
            for (double tick : this.ticks) {
                double x = this.valueToJava2D(tick, area);
                this.drawGlidline(g2, x, area.getMinY(), x, area.getMaxY());
                this.drawTickMark(g2, x, top, x, top + (double)this.getTickMarkInsideLength());
                String label = this.valueToString(tick);
                DrawUtils.drawText(g2, label, (float)(x - (double)(fm.stringWidth(label) / 2)), (float)top + (float)this.getTickMarkInsideLength() + (float)ascent + 1.0f);
            }
        }
        this.drawAxisLine(g2, area.getMinX(), top, area.getMaxX(), top);
    }

    public void drawAxisTrace(Graphics2D g2, Rectangle2D area, double xy, int margin) {
        if (this.getOrientation() == Orientation.VERTICAL) {
            this.drawVerticalAxisTrace(g2, area, xy, margin);
        } else if (this.getOrientation() == Orientation.HORIZONTAL) {
            this.drawHorizontalAxisTrace(g2, area, xy, margin);
        } else {
            throw new RuntimeException();
        }
    }

    private void drawVerticalAxisTrace(Graphics2D g2, Rectangle2D area, double y, int margin) {
        this.drawTraceLine(g2, area.getMinX(), y, area.getMaxX(), y);
        g2.setFont(FONT);
        FontMetrics fm = g2.getFontMetrics();
        String text = this.valueToString(this.java2DToValue(y, area));
        double right = area.getMinX() - (double)this.getTickMarkOutsideLength();
        double textWidth = fm.stringWidth(text);
        double x1 = right - (double)this.getTickMarkInsideLength() - (double)this.getTickWidthMargin() - textWidth;
        double x2 = x1 - (double)margin + textWidth + (double)margin;
        double y1 = y + (double)fm.getDescent() - (double)fm.getAscent();
        double y2 = y1 + (double)fm.getHeight();
        GeneralPath path = new GeneralPath();
        path.moveTo((float)(x1 - (double)margin), (float)y1);
        path.lineTo((float)x2, (float)y1);
        path.lineTo((float)(right + (double)margin), (float)(y1 + (y2 - y1) * 0.5));
        path.lineTo((float)x2, (float)y2);
        path.lineTo((float)(x1 - (double)margin), (float)y2);
        path.closePath();
        g2.setPaint(new GradientPaint((float)x1, (float)y1, Color.WHITE, (float)x1, (float)y2, ChartColor.VERY_LIGHT_GRAY));
        g2.fill(path);
        g2.setColor(Color.BLUE);
        g2.draw(path);
        DrawUtils.drawText(g2, text, (float)x1, (float)y + (float)fm.getDescent());
    }

    private void drawHorizontalAxisTrace(Graphics2D g2, Rectangle2D area, double x, int margin) {
        this.drawTraceLine(g2, x, area.getMinY(), x, area.getMaxY());
        g2.setFont(FONT);
        FontMetrics fm = g2.getFontMetrics();
        String text = this.valueToString(this.java2DToValue(x, area));
        double top = area.getMaxY() + (double)this.getTickMarkOutsideLength();
        int width = fm.stringWidth(text);
        int height = fm.getHeight();
        double x1 = x - (double)width * 0.5;
        double x2 = x + (double)width * 0.5;
        double y1 = top + (double)this.getTickMarkInsideLength() + 1.0;
        double y2 = top + (double)this.getTickMarkInsideLength() + (double)height + 1.0;
        GeneralPath path = new GeneralPath();
        path.moveTo((float)(x1 - (double)margin), (float)y2);
        path.lineTo((float)(x1 - (double)margin), (float)y1);
        path.lineTo((float)(x1 + (x2 - x1) * 0.5 - (double)height * 0.5), (float)y1);
        path.lineTo((float)(x1 + (x2 - x1) * 0.5), (float)(top - (double)margin));
        path.lineTo((float)(x1 + (x2 - x1) * 0.5 + (double)height * 0.5), (float)y1);
        path.lineTo((float)(x2 + (double)margin), (float)y1);
        path.lineTo((float)(x2 + (double)margin), (float)y2);
        path.closePath();
        g2.setPaint(new GradientPaint((float)x1, (float)top, Color.WHITE, (float)x1, (float)y2, ChartColor.VERY_LIGHT_GRAY));
        g2.fill(path);
        g2.setColor(Color.BLUE);
        g2.draw(path);
        double y = top + (double)this.getTickMarkInsideLength() + (double)fm.getAscent() + 1.0;
        DrawUtils.drawText(g2, text, (float)x1, (float)y);
    }

    private String valueToString(double value) {
        return this.units.getCeilingTickUnit(value).valueToString(value);
    }

    public double valueToJava2D(double value, Rectangle2D area) {
        if (this.getOrientation() == Orientation.VERTICAL) {
            if (this.scale == PriceScaleType.NORMAL) {
                return area.getMaxY() - (value - this.range.getLower()) / this.range.getLength() * (area.getMaxY() - area.getMinY() - this.lowerMargin - this.upperMargin) - this.lowerMargin;
            }
            if (this.scale == PriceScaleType.REVERSE) {
                return area.getMaxY() - (this.range.getUpper() - value) / this.range.getLength() * (area.getMaxY() - area.getMinY());
            }
            if (this.scale == PriceScaleType.LOG) {
                return area.getMaxY() - (Math.log(value) - Math.log(this.range.getLower())) * (area.getMaxY() - area.getMinY()) / (Math.log(this.range.getUpper()) - Math.log(this.range.getLower()));
            }
        } else if (this.getOrientation() == Orientation.HORIZONTAL) {
            if (this.scale == PriceScaleType.NORMAL) {
                return area.getMaxX() - (this.range.getUpper() - value) / this.range.getLength() * (area.getMaxX() - area.getMinX());
            }
            if (this.scale == PriceScaleType.REVERSE) {
                return area.getMaxX() - (value - this.range.getLower()) / this.range.getLength() * (area.getMaxX() - area.getMinX());
            }
            if (this.scale == PriceScaleType.LOG) {
                return area.getMaxX() - Math.log(this.range.getUpper() - Math.log(value)) * (area.getMaxX() - area.getMinX()) / (Math.log(this.range.getUpper()) - Math.log(this.range.getLower()));
            }
        }
        throw new RuntimeException();
    }

    public double java2DToValue(double java2DValue, Rectangle2D area) {
        if (this.getOrientation() == Orientation.VERTICAL) {
            if (this.scale == PriceScaleType.NORMAL) {
                return this.range.getUpper() - (java2DValue - area.getMinY() + this.upperMargin) / (area.getMaxY() - area.getMinY() - this.lowerMargin - this.upperMargin) * this.range.getLength();
            }
            if (this.scale == PriceScaleType.REVERSE) {
                return this.range.getUpper() - (area.getMaxY() - java2DValue + this.upperMargin) / (area.getMaxY() - area.getMinY() - this.lowerMargin - this.upperMargin) * this.range.getLength();
            }
            if (this.scale == PriceScaleType.LOG) {
                return Math.exp(Math.log(this.range.getUpper()) - (java2DValue - area.getMinY() + this.upperMargin) / (area.getMaxY() - area.getMinY() - this.lowerMargin - this.upperMargin) * (Math.log(this.range.getUpper()) - Math.log(this.range.getLower())));
            }
        } else if (this.getOrientation() == Orientation.HORIZONTAL) {
            if (this.scale == PriceScaleType.NORMAL) {
                return this.range.getUpper() - (area.getMaxX() - java2DValue) / (area.getMaxX() - area.getMinX()) * this.range.getLength();
            }
            if (this.scale == PriceScaleType.REVERSE) {
                return this.range.getUpper() - (java2DValue - area.getMinX()) / (area.getMaxX() - area.getMinX()) * this.range.getLength();
            }
            if (this.scale == PriceScaleType.LOG) {
                return Math.exp(Math.log(this.range.getUpper()) - (area.getMaxX() - java2DValue) / (area.getMaxX() - area.getMinX()) * (Math.log(this.range.getUpper()) - Math.log(this.range.getLower())));
            }
        }
        throw new RuntimeException();
    }

    public static enum RangeType {
        FULL,
        NEGATIVE,
        POSITIVE;

    }
}

