﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace OPMLEditor.Forms
{
    public partial class FrmSearch : Form
    {
        public FrmSearch()
        {
            InitializeComponent();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            ((FrmBase)Owner).TmpSearchTarget = txtSearch.Text;
            this.Close();
        }

        private void txtSearch_KeyPress(object sender, KeyPressEventArgs e)
        {
            //EnterやEscapeキーでビープ音が鳴らないようにする
            if (e.KeyChar == (char)Keys.Enter || e.KeyChar == (char)Keys.Escape)
            {
                e.Handled = true;
            }
            else if (e.KeyChar == '\n')
            {
                e.Handled = true;
            }

        }
        //PreviewKeyDownイベントハンドラ
        private void txtSearch_Keydown(object sender,
            PreviewKeyDownEventArgs e)
        {

            switch (e.KeyCode)
            {
                case Keys.Enter:
                    ((FrmBase)Owner).TmpSearchTarget = txtSearch.Text;
                    this.Close();
                    break;

            }
        }
    }
}
