﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using OPMLEditor.Structure;
using OPMLEditor.Controller;
using OPMLEditor.opml;
using OPMLEditor.forms;
using OPMLEditor.export;

namespace OPMLEditor.Forms
{
    public partial class FrmBase : Form
    {
        private NodeController nodeCtrl;
        private int totalIndex;
        private ExportController expCtrl;
        private string openFileName;
        private string tmpNote;

        private string tmpSearchTarget;

        public string TmpSearchTarget
        {
            get { return tmpSearchTarget; }
            set 
            {
                this.tmpSearchTarget = value;
                nodeCtrl.search(this.tmpSearchTarget);
            }
        }
        public string TmpNote
        {
            get { return tmpNote; }
            set { tmpNote = value; }
        }

        #region Constructor
        public FrmBase()
        {
            InitializeComponent();
            nodeCtrl = NodeController.getNodeController();
            nodeCtrl.FrontWindow = this;
            refleshNode();

            expCtrl = new ExportController();
            
        }

        public FrmBase(string filePath)
            : this()
        {
            OpmlParser.Parser.LoadFile(filePath, nodeCtrl);
            refleshNode();

            openFileName = filePath;
            this.Text = "Opml Editor" + " : " + filePath; 
        }
        #endregion

        #region Form Reflesh Method
        public void refleshNode()
        {
            flowLayoutPanel1.Controls.Clear();
            totalIndex = 1;

            StructureNode focusData = nodeCtrl.FocusData;
            foreach (StructureNode data in nodeCtrl.ParentList)
            {
                this.flowLayoutPanel1.Controls.Add(data.Panel.PnlNode);

                if (data == focusData)
                {
                    data.Panel.NodeTitle.Focus();
                }
                
                data.Panel.PnlNode.TabIndex = totalIndex;
            
                totalIndex++;


                recursiveAddPanel(data, 1,focusData);
            }

            this.statusIndicator.Text = "";

        }

        private void recursiveAddPanel(StructureNode data, int indent,StructureNode focusData)
        {
            if (data.getAllChildlen().Count == 0) { return; }
            foreach (StructureNode childData in data.getAllChildlen())
            {
                
                this.flowLayoutPanel1.Controls.Add(childData.Panel.PnlNode);
                
                if (childData == focusData)
                {
                    childData.Panel.NodeTitle.Focus();
                }
                childData.Panel.PnlNode.TabIndex = totalIndex;
                totalIndex++;

                if (childData.getAllChildlen().Count > 0)
                {
                    recursiveAddPanel(childData, indent + 1,focusData);
                }
            }
        }
        #endregion


        #region EventHandler
        private void NewNodeMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl.addNodes();
        }

        private void InsertNodeMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl.addChild();
        }

        private void RightMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl.becomeChild();
        }

        private void LeftMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl.becomeParent();
        }

        private void DownMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl.turnDown();
        }

        private void UpMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl.turnUp();
        }

        private void DeleteMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl.deleteNode();
        }

        private void QuitMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void noteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl.addNote();
        }

        private void OpenMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult res = openDialog.ShowDialog();
            string filePath = openDialog.FileName;
            if (filePath == null || filePath == string.Empty)
            {
                return;
            }
            OpmlParser.Parser.LoadFile(filePath, nodeCtrl);
            
            refleshNode();

            openFileName = filePath;
            this.Text = "Opml Editor" + " : " + filePath;
            this.statusIndicator.Text = "";
        }

        private void SaveAsMenuItem_Click(object sender, EventArgs e)
        {
            this.statusIndicator.Text = "saving..";
            saveDialog.ShowDialog();
            string filePath = saveDialog.FileName;
            if (filePath == null || filePath == string.Empty) { return; }
            
            OpmlParser.Parser.SaveFile(filePath, nodeCtrl);

            openFileName = filePath;
            this.Text = "Opml Editor" + " : " + filePath;

            this.statusIndicator.Text = "saved " + filePath;
        }

        private void SaveMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileName == null || openFileName == string.Empty) 
            {
                SaveAsMenuItem_Click(sender, e);
                return; 
            }

            this.statusIndicator.Text = "saving..";
            OpmlParser.Parser.SaveFile(openFileName, nodeCtrl);
            this.statusIndicator.Text = "saved " + openFileName;
        }

        private void NewMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl = nodeCtrl.resetNodeController();
            nodeCtrl.FrontWindow = this;
            refleshNode();

            openFileName = string.Empty;
            this.Text = "Opml Editor";
            this.statusIndicator.Text = "";
        }
        
        private void chngStatusToolStripMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl.changeNodeStatus();
        }
        #endregion

        private void UndoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl.undo();
        }

        public void undoToolControl(bool isEnabled)
        {
            this.UndoToolStripMenuItem.Enabled = isEnabled;
        }

        private void SearchToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FrmSearch searchWindow = new FrmSearch();
            searchWindow.Owner = this;
            searchWindow.ShowDialog();

            nodeCtrl.search(tmpSearchTarget);

        }

        private void searchPrevToolStripMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl.searchPrev();
        }

        private void searchNextToolStripMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl.searchNext();
        }

        private void ClearSearchToolStripMenuItem_Click(object sender, EventArgs e)
        {
            nodeCtrl.resetSearch();
        }

        private void manualToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string manualFile = ".\\manual.opml";

            DialogResult res =System.Windows.Forms.MessageBox.Show(
                "現在の内容は失われます。内容を保存してください。\n続行しますか？",
                "確認",
                MessageBoxButtons.YesNo,
                MessageBoxIcon.Question,
                MessageBoxDefaultButton.Button2);
            if (res == DialogResult.Yes)
            {
                //マニュアルファイルがなければ
                if (System.IO.File.Exists(manualFile))
                {
                    OpmlParser.Parser.LoadFile(manualFile, nodeCtrl);
                    refleshNode();

                    openFileName = manualFile;
                    this.Text = "Opml Editor" + " : " + manualFile;
                    this.statusIndicator.Text = "";
                }
                else
                {
                    System.Windows.Forms.MessageBox.Show(
                        "マニュアルファイルを読み込めませんでした",
                        "エラー",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error,
                        MessageBoxDefaultButton.Button1);
                }
            }
        }

        private void creditToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FrmCredit credit = new FrmCredit();
            credit.ShowDialog();
        }

        private void exportTabTextToolStripMenuItem_Click(object sender, EventArgs e)
        {
            TabTextExporter exporter = new TabTextExporter();
            expCtrl.export(exporter);
        }

        private void NumericTextExportToolStripMenuItem_Click(object sender, EventArgs e)
        {
            NumericTextExporter exporter = new NumericTextExporter();
            expCtrl.export(exporter);
        }





    }
}
