﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using OPMLEditor.opml;
using System.Windows.Forms;

namespace OPMLEditor.export
{
    class NumericTextExporter : abTextExporter,ExportIF
    {
        private Opml dataSource;
        public override Opml DataSource
        {
            set { this.dataSource = value; }
        }

        public override List<string> arrangeData()
        {
            List<string> retData = new List<string>();
            int numerics = 1;
            foreach(Outline node in dataSource.body.outline)
            {
                string numericString = numerics.ToString() + " : ";
                retData.Add(numericString + node.text);
                if (node.note != null && node.note != string.Empty)
                {
                    string noteText = node.note;

                    retData.Add("\t" + noteText.Replace("\n", "\n\t"));
                }
                recursiveArrangeData(node.outline,retData, numerics.ToString());

                numerics++;
            }
            return retData;
        }

        private void recursiveArrangeData(List<Outline> list,List<string> retData, string numerics)
        {
            int numericsInner = 1;
            foreach (Outline childNode in list)
            {
                retData.Add(numerics + "." + numericsInner.ToString() + " : " + childNode.text);
                if (childNode.note != null && childNode.note != string.Empty)
                {
                    string noteText = childNode.note;

                    retData.Add("\t" + noteText.Replace("\n", "\n\t"));
                }
                recursiveArrangeData(childNode.outline, retData, numerics + "." + numericsInner.ToString());

                numericsInner++;
            }
        }


    }
}
