/********************************************************************
 * monit.c
 ********************************************************************
 */
#include <string.h>
#include "typedefs.h"
#include "usb.h"
#include "io_cfg.h"
#include "monit.h"
#include "hidcmd.h"
#include "timer2.h"
#include "config.h"

#define	DEVID	DEV_ID_PIC			//0x25
#define	VER_H	1
#define	VER_L	1
#define	REPLY_REPORT	0xaa

#define	AI_CHMAX		32				// Install Ai Channel max (Max:32ch)
#define	AO_CHMAX		AI_CHMAX / 2	// Install Ao Channel max (Max:16ch)
#define	DIO_CHMAX		128				// Install Di/Do Channel max (Max:32ch)

#define	MODE_NONE		0		// None mode
#define	MODE_DIOC		1		// Dioc mode
#define	MODE_AIOC		2		// Aioc mode
#define	MODE_ECHODIO	3		// Echo_Dioc mode for test
#define	MODE_ECHOAIO	4		// Echo_Aioc mode for test


#pragma udata access accessram

//#define	PUTBUF_SIZE	16
//uchar puts_buf[PUTBUF_SIZE];
//uchar puts_ptr;
//uchar puts_mode;

uchar near ToPcRdy;				//	R}h̕ԐMKvȂ1Zbg.
uchar near DaqMode;				// 0:NONE, 1:DIO, 2:AIO, 3:echoDIO, 4:echoAIO
uchar near DaqNum;				// DAQ Device Number 00,01,...

#pragma udata gpr1

uchar	DioDI[16];				// for DIn buffer
uchar	DioDO[16];				// for DOut buffer
ushort	AioAI[32];				// for AIn buffer
ushort	AioAO[16];				// for AOut buffer
ushort	CtrCT[2];				// for Counter buffer
ushort	TmrCT[2];				// for Timer buffer
ushort	DumCT[2];				// for Dummy Counter
ushort	PreCT[2];				// for Preset Dummy

#pragma udata SomeSectionName1
Packet PacketFromPC;			//̓pPbg 64byte

#pragma udata SomeSectionName2
Packet PacketToPC;				//o̓pPbg 64byte

#define	Cmd0	PacketFromPC.cmd
#define	Data0	PacketFromPC.data[0]
#define	Mask1	PacketFromPC.data[1]

#pragma code

//------------------------------------------------------------------------
//uchar SPI_MasterTransmit(char cData)
//	SPI]PoCgs.
uchar usi_trans(uchar data)
{
	SSPBUF = data;
	while(!SSPSTATbits.BF) {};  // BF = SSP Buffer Full . 1=Full 0=Empty 
	return SSPBUF;
}

#if 1	/* Add by senshu */
unsigned char ReadEE(unsigned char Address)
{
	EECON1 = 0x00;
	EEADR = Address;
	EECON1bits.RD = 1;
	return (EEDATA);
}

void WriteEE(unsigned char Address, unsigned char Data)
{
	EEADR = Address;
	EEDATA = Data;
	EECON1 = 0b00000100;	// Setup writes: EEPGD=0,WREN=1
	/* Start Write */
	EECON2 = 0x55;
	EECON2 = 0xAA;
	EECON1bits.WR = 1;
	while( EECON1bits.WR);	// Wait till WR bit is clear, hopefully not long enough to kill USB
}
#endif

#if RAM_SERIAL	/* Add by senshu */
/*
  EEPROM MAP

	0x00i[Üj
	@:
	0xefi[Üj

	0xf0 VAԍ̑iiKł́A4Ɍj
	0xf1 VAԍi1ځj
	0xf2 VAԍi2ځj
	0xf3 VAԍi3ځj
	0xf4 VAԍi4ځj
	0xf5 VAԍi5ځj
	0xf6 VAԍi6ځj
	0xf7 \
	 :
	0xfc \
	0xfd USBVȀ{[[g
	0xfe DTR/RTSȂǂ̗LE̎wȂ
	0xff JUMPAhX(H) .... Av̏8rbgw
	ʂ 0x00z
 */
#define EE_SERIAL_LEN 0xf0
#define EE_SERIAL_TOP 0xf1

#define EE_DAQMODE		0x00	// DaqMode save
#define	EE_DAQNUM	0x01	// DaqDevNumber save

void set_serial_number()
{
	unsigned char ch;
	int i, j;
	if (ReadEE(EE_SERIAL_LEN) == 4) {
		/* f[^̑Ó */
		j = 0;
		for (i = EE_SERIAL_TOP; i < EE_SERIAL_TOP + 4; i++) {
			ch = ReadEE(i);
			if (' ' <= ch && ch <= 'z') {
				j++;
			}
		}
		/* f[^Ół΁AlZbg */
		if (j == 4) {
			for (i = 0; i < 4; i++) {
				sd003.string[i] = ReadEE (EE_SERIAL_TOP + i);
			}
		}
	}
}

#endif

void setDioMode(void);
void setAioMode(void);
/********************************************************************
 *	.
 ********************************************************************
 */
void UserInit(void)
{
	uchar mode, num;
    mInitAllLEDs();
	timer2_interval(7);	// '-d7' ... 47KHz ?
	//puts_ptr = 0;
	ToPcRdy = 0;

	// DAQ MODE & Number Check
	mode = ReadEE(0x00);
	num = ReadEE(0x01);
	if (mode >= 0x00 && mode < 5 && num >= 0x00 && num < 0x20) {
		DaqMode = mode;
		DaqNum = num;
		if (mode == 1)
			setDioMode();
		else if (mode == 2)
			setAioMode();
	} else {
		DaqMode = MODE_NONE;
		DaqNum = 0;
	}
	CtrCT[0] = 0;
	CtrCT[1] = 0;
	TmrCT[0] = 0;
	TmrCT[1] = 0;
	DumCT[0] = 200;
	DumCT[1] = 200;
	PreCT[0] = 200;
	PreCT[1] = 200;
}

void	get_di_port(uchar);
void	put_do_port(uchar);
/*********************************************************************
 *	Timer2 	Interrupr procedure
 *********************************************************************
 */
void tmr2monit(void)
{
	// inc dummy counter, and dummy timer.
	uchar	cnt; 

	TmrCT[0]++;
	TmrCT[1]++;
	DumCT[0]--;
	DumCT[1]--;

//	for (cnt=0; cnt<16; cnt++) {
//		if (!mHIDRxIsBusy()) {
//			get_di_port(cnt);			// Input  Di (8ch=1byte)
//		}
//		if (!mHIDRxIsBusy()) {
//			put_do_port(cnt);			// Output Do (8ch:1byte)
//		}
//	}
	
	if (DumCT[0] == 0) {
		if (DaqMode == MODE_DIOC || DaqMode == MODE_AIOC)
			DioDO[4] = DioDO[4] ^ 1;	// for debug
		else
			CtrCT[0]++;
		DumCT[0] = PreCT[0];
	}
	if (DumCT[1] == 0) {
		if (DaqMode == MODE_DIOC || DaqMode == MODE_AIOC)
			DioDO[4] = DioDO[4] ^ 2;	// for debug
		else
			CtrCT[1]++;
		DumCT[1] = PreCT[1];
	}
}

/********************************************************************
 *	ڑeXg̕ԓ
 ********************************************************************
 */
void cmd_echo(void)
{
	PacketToPC.raw[1]=DEVID;				// PIC25/14K
	PacketToPC.raw[2]=VER_L;				// version.L
	PacketToPC.raw[3]=VER_H;				// version.H
	PacketToPC.raw[4]=0;					// bootloader
	PacketToPC.raw[5]=PacketFromPC.raw[1];	// ECHOBACK
	ToPcRdy = 1;
}

void cmd_stat(void)
{
	PacketToPC.raw[1] = DaqMode;
	PacketToPC.raw[2] = DaqNum;
	ToPcRdy = 1;
}

void cmd_mode(void)
{
	uchar mode = PacketFromPC.size;
	uchar num = PacketFromPC.raw[2];
	DaqMode = mode;
	WriteEE(EE_DAQMODE, mode);
	DaqNum = num;
	WriteEE(EE_DAQNUM, num);
	if (mode == 1)
		setDioMode();
	else if (mode == 2)
		setAioMode();
}

/********************************************************************
 *	[ǂݏo
 ********************************************************************
 */
void cmd_peek(void)
{
	uchar i,size,area;
	uchar *p;

 	size = PacketFromPC.size;
	area = size & AREA_MASK;
	size = size & SIZE_MASK;
 	p = (uchar*)PacketFromPC.adrs;

	if(area & AREA_PGMEM) {
//		PacketFromPC.data[0]=0;	// TBLPTRU[NA.
		TBLPTR = (unsigned short long)PacketFromPC.adrs;

		for(i=0;i<size;i++) {
				_asm
				tblrdpostinc
				_endasm
			PacketToPC.raw[i]=TABLAT;
		}
	}else if(area & AREA_EEPROM) {
		unsigned char ee_adr = (unsigned char)(PacketFromPC.adrs & 0xff);

		for(i=0;i<size;i++) {
			PacketToPC.raw[i] = ReadEE(ee_adr++);
		}
	}else{
		for(i=0;i<size;i++) {
			PacketToPC.raw[i]=*p++;
		}
	}
	ToPcRdy = 1;
}
/********************************************************************
 *	[
 ********************************************************************
 */
void cmd_poke(void)
{
	uchar size,area;
	uchar *p;
 	area = PacketFromPC.size;
 	p = (uchar*)PacketFromPC.adrs;

#if 1	/* Add by senshu */
	if(area & AREA_EEPROM) {
		unsigned char ee_adr = (unsigned char)(PacketFromPC.adrs & 0xff);
		WriteEE(ee_adr, Data0);
	} else {
		if( Mask1 ) {	//}XN.
			*p = (*p & Mask1) | Data0;
		}else{			//ʏ폑.
			*p = Data0;
		}
	}
#else
	if( Mask1 ) {	//}XN.
		*p = (*p & Mask1) | Data0;
	}else{			//ʏ폑.
		*p = Data0;
	}
#endif
}

// DIOC port define
#define CH_SEL	(PORTA & 0x0f)	// Channel select 0 ~ 15
#define DIO_DAT	PORTB			// DIO B0 ~ B7
#define DIO_RW	PORTCbits.RC1	// 0:Write(DO), 1:Read(DI)
#define DIO_EN	PORTCbits.RC2	// 0:active for DIO_DAT

// Counter Input (DIOC/AIOC) define
#define CT0_IN	PORTAbits.T0CKI		// Counter 0
#define CT1_IN	PORTCbits.T13CKI	// Counter 1

// AIOC port define
#define ADCEN0	PORTAbits.RA0	// Ei0 for MCP3208 (0:active)
#define ADCEN1	PORTAbits.RA1	// Ei1 for MCP3208 (0:active)
#define ADCEN2	PORTAbits.RA2	// Ei2 for MCP3208 (0:active)
#define ADCEN3	PORTAbits.RA3	// Ei3 for MCP3208 (0:active)

#define DACEN0	PORTCbits.RC1	// Eo0 for MCP4822 (0:active)
#define DACEN1	PORTCbits.RC2	// Eo1 for MCP4822 (0:active)
#define DACEN2	PORTBbits.RB2	// Eo2 for MCP4822 (0:active)
#define DACEN3	PORTBbits.RB3	// Eo3 for MCP4822 (0:active)
#define DACEN4	PORTBbits.RB4	// Eo4 for MCP4822 (0:active)
#define DACEN5	PORTBbits.RB5	// Eo5 for MCP4822 (0:active)
#define DACEN6	PORTBbits.RB6	// Eo6 for MCP4822 (0:active)
#define DACEN7	PORTBbits.RB7	// Eo7 for MCP4822 (0:active)

#define AIO_CLK	PORTBbits.RB1	// SCK for MCP3208, MCP4822
#define AIO_DAT	PORTCbits.RC7	// SDO for MCP3208, MCP4822
#define ADC_DAT	PORTBbits.RB0	// SDI from MCP3208
#define DAC_LD	PORTCbits.RC6	// LD for MCP4822

void setDioMode(void)
{
	uchar	cnt;

	TRISA = 0xF0;
	TRISB = 0xFF;
	DIO_RW = 1;				// set Read
	DIO_EN = 1;				// set Disable
	TRISC = 0xC1;
	// Do port Initialize (output: all off)
	for (cnt = 0; cnt < 16; cnt++) {
		DioDO[cnt] = 0x00;
		put_do_port(cnt);
	}

}

void setAioMode(void)
{
	ADCEN0 = 1;
	ADCEN1 = 1;
	ADCEN2 = 1;
	ADCEN3 = 1;
	TRISA = 0xF0;
	AIO_CLK = 1;
	DACEN2 = 1;
	DACEN3 = 1;
	DACEN4 = 1;
	DACEN5 = 1;
	DACEN6 = 1;
	DACEN7 = 1;
	TRISB = 0x01;
	DACEN0 = 1;
	DACEN1 = 1;
	AIO_DAT = 1;
	DAC_LD = 1;
	TRISC = 0x01;
}

/*********************************************************************
 *	Get Di port(1-byte), and bufferd it.
 *********************************************************************
 */
void get_di_port(uchar pno){
	TRISB = 0xff;			//Data Bus: Input
	PORTA = pno & 0x0f;		//Chip select 
	DIO_RW = 1;				//Read
	DIO_EN = 0; 
	_asm	nop		_endasm
	DioDI[pno] = PORTB;
	_asm	nop		_endasm
	DIO_EN = 1; 
}

/*********************************************************************
 *	Put do_Buffer to port(1-byte).
 *********************************************************************
 */
void put_do_port(uchar pno){
	TRISB = 0x00;			//Data Bus: Output
	PORTA = pno & 0x0f;		//Chip select 
	DIO_RW = 0;				//Write
	PORTB = ~DioDO[pno];	//Invert Logic
	_asm	nop		_endasm
	DIO_EN = 0; 
	_asm	nop		_endasm
	DIO_EN = 1; 
	TRISB = 0xff;			//Data Bus: Input
	// test SA-SC clear
	PORTA = 0x00;
}

/*********************************************************************
 *	Ao control
 *********************************************************************
 */

/*********************************************************************
 * Function:	YDA Chip(Mcp4822)@Enable/Disableɂ
 * (in)	dn: 	Device# ... 0-7 
 *      en: 	Action (0=enable, 1=disable)
 *********************************************************************
 */
void	selectMcp4822(uchar dn, uchar en)
{
	if (dn == 0)
		DACEN0 = en;
	else if (dn == 1)
		DACEN1 = en;
	else if (dn == 2)
		DACEN2 = en;
	else if (dn == 3)
		DACEN3 = en;
	else if (dn == 4)
		DACEN4 = en;
	else if (dn == 5)
		DACEN5 = en;
	else if (dn == 6)
		DACEN6 = en;
	else if (dn == 7)
		DACEN7 = en;
}

/*********************************************************************
 * Function:	YDA chip(Mcp4822)D/Aϊo
 * (in)	dn: 	Device# ......... 0-7 
 *      ch: 	ch# in device ... 0:chA, 1: chB
 *    data:		D/A ϊf[^
 *********************************************************************
 */
void	DacWriteMcp4822(uchar dn, uchar ch, ushort dt)
{
	uchar	cnt;
	ushort	data;

	AIO_CLK = 1;
	// enable MCP4822 Chip select
	selectMcp4822(dn, 0);
	// set MCP4822 channel
	AIO_DAT = ch;	// chA = 0, chB = 1
	AIO_CLK = 0;
	_asm	nop		_endasm
	AIO_CLK = 1;
	AIO_DAT = 0;	// none
	AIO_CLK = 0;
	_asm	nop		_endasm
	AIO_CLK = 1;
	AIO_DAT = 0;	// GA = 0
	AIO_CLK = 0;
	_asm	nop		_endasm
	AIO_CLK = 1;
	AIO_DAT = 1;	// Out = On
	AIO_CLK = 0;
	_asm	nop		_endasm
	AIO_CLK = 1;
	data = dt;		// clear data
	for (cnt = 11; cnt > 0; cnt--) {
		AIO_DAT = (data >> cnt) & 0x01;
		AIO_CLK = 0;
		_asm	nop		_endasm
		AIO_CLK = 1;
	}
	AIO_DAT = (data & 0x01);	// last bit
	AIO_CLK = 0;
	_asm	nop		_endasm
	AIO_CLK = 1;

	// disable MCP4822 Chip select
	selectMcp4822(dn, 1);

	DAC_LD = 0;
	_asm	nop		_endasm
	DAC_LD = 1;
}

/*********************************************************************
 * Function:	YAD Chip(Mcp3208)@Enable/Disableɂ
 * (in)	dn: 	Device# ... 0-3 
 *      en: 	Action (0=enable, 1=disable)
 *********************************************************************
 */
void	selectMcp3208(uchar dn, uchar en)
{
	if (dn == 0)
		ADCEN0 = en;
	else if (dn == 1)
		ADCEN1 = en;
	else if (dn == 2)
		ADCEN2 = en;
	else if (dn == 3)
		ADCEN3 = en;
}

/*********************************************************************
 * Function:	YAD@chip(Mcp3208)A/Dϊf[^擾
 * (in)	dn: 	Device# ......... 0-3 
 *      ch: 	ch# in device ... 0-7
 *********************************************************************
 */
ushort	AdcReadMcp3208(uchar dn, uchar ch)
{
	uchar	cnt;
	ushort	data;
	AIO_CLK = 1;
	// enable MCP3208 Chip select
	selectMcp3208(dn, 0);
	// start MCP3208 control
	AIO_DAT = 1;	// start bit
	AIO_CLK = 0;
	_asm	nop		_endasm
	AIO_CLK = 1;
	//
	AIO_DAT = 1;	// single ended mode
	AIO_CLK = 0;
	_asm	nop		_endasm
	AIO_CLK = 1;
	//
	AIO_DAT = (ch >> 2) & 0x01;	// D2 for MCP3208 Channel
	AIO_CLK = 0;
	_asm	nop		_endasm
	AIO_CLK = 1;
	//
	AIO_DAT = (ch >> 1) & 0x01;	// D1
	AIO_CLK = 0;
	_asm	nop		_endasm
	AIO_CLK = 1;
	//
	AIO_DAT = ch & 0x01;		// D0
	AIO_CLK = 0;
	_asm	nop		_endasm
	AIO_CLK = 1;
	//
	AIO_DAT = 0;	// sample
	AIO_CLK = 0;
	_asm	nop		_endasm
	AIO_CLK = 1;
	//
	AIO_DAT = 0;	// null
	AIO_CLK = 0;
	_asm	nop		_endasm
	AIO_CLK = 1;
	//
	data = 0;		// clear data
	for (cnt = 0; cnt < 12; cnt++) {
		AIO_DAT = 0;
		AIO_CLK = 0;
		if (ADC_DAT == 1) {
			data |= 0x01;
		} else {
			data |= 0x00;
		}
		data = data << 1;
		AIO_CLK = 1;
	}
	// disable MCP3208 Chip select
	selectMcp3208(dn, 1);

	AIO_CLK = 0;
	_asm	nop		_endasm
	AIO_CLK = 1;
	//
	data = data >> 1;
	//
	return(data);
}

void cmd_chpoke(void)
{
	uchar	dn;
	uchar	ch = PacketFromPC.size;
	ushort	dt = PacketFromPC.adrs;

	if (DaqMode == MODE_DIOC) {
		if (ch < 0x10) {
			DioDO[ch] = dt & 0xff;
			put_do_port(ch);
		} else if (ch >= 0x20 && ch < 0x22)
			PreCT[ch - 0x20] = dt;
	} else if (DaqMode == MODE_AIOC) {
		if (ch < 0x10) {
			dn = (ch >> 1) & 0x07;
			DacWriteMcp4822(dn, ch & 0x01, dt);
		} else if (ch >= 0x20 && ch < 0x22)
			PreCT[ch - 0x20] = dt;
	} else if (DaqMode == MODE_ECHODIO) {
		if (ch < 0x10)
			DioDI[ch] = dt & 0xff;
		else if (ch >= 0x20 && ch < 0x22)
			PreCT[ch - 0x20] = dt;
	} else if (DaqMode == MODE_ECHOAIO) {
		if (ch < 0x20)
			AioAI[ch] = dt;
		else if (ch < 0x22)
			PreCT[ch - 0x20] = dt;
	} else {	// DaqMode == 0, and others(not 1,2,3,4)
		if (ch < 0x10)
			DioDO[ch] = dt & 0xff;
		else if (ch < 0x20)
			AioAO[ch - 0x10] = dt;
		else if (ch < 0x22)
			PreCT[ch - 0x20] = dt;
	}
}

void cmd_chpeek(void)
{
	uchar	dn;
	uchar	ch = PacketFromPC.size;
	ushort	dt;

	if (DaqMode == MODE_DIOC) {
		if (ch < 0x10) {
			get_di_port(ch);
			PacketToPC.raw[0] = DioDI[ch];
		} else if (ch >= 0x20 && ch < 0x22) {
			PreCT[ch - 0x20] = dt;
		}
	} else if (DaqMode == MODE_AIOC) {
		if (ch < 0x20) {
			dn = (ch >> 3) & 0x03;
			dt = AdcReadMcp3208(dn, ch & 0x07);
			PacketToPC.raw[0] = dt & 0xff;
			PacketToPC.raw[1] = (dt >> 8) & 0x0f;
		}
	} else if (DaqMode == MODE_ECHODIO) {
		if (ch < 0x10) {
			PacketToPC.raw[0] = DioDI[ch];
		}
	} else if (DaqMode == MODE_ECHOAIO) {
		if (ch < 0x20) {
			PacketToPC.raw[0] = AioAI[ch] & 0xff;
			PacketToPC.raw[1] = (AioAI[ch] >> 8) & 0xff;
		}
	} else {	// DaqMode == 0, and others(not 1,2,3,4)
		if (ch < 0x10) {
			PacketToPC.raw[0] = DioDI[ch];
		} else if (ch < 0x20) {
			PacketToPC.raw[0] = AioAI[ch] & 0xff;
			PacketToPC.raw[1] = (AioAI[ch] >> 8) & 0xff;
		}
	}

	if (ch >= 0x20 && ch < 0x22) {
		PacketToPC.raw[0] = CtrCT[ch - 0x20] & 0xff;
		PacketToPC.raw[1] = (CtrCT[ch - 0x20] >> 8) & 0xff;
		PacketToPC.raw[2] = TmrCT[ch - 0x20] & 0xff;
		PacketToPC.raw[3] = (TmrCT[ch - 0x20] >> 8) & 0xff;
	}

	ToPcRdy = 1;
}

void cmd_pokeall(void)
{
	uchar	cnt, dn;
	ushort	dat;

	if (DaqMode == MODE_DIOC) {
		for (cnt = 0; cnt < 16; cnt++) {
			DioDO[cnt] = PacketFromPC.raw[cnt + 1];
			put_do_port(cnt);
		}
	} else if (DaqMode == MODE_AIOC) {
		for (cnt = 0; cnt < 8; cnt++) {
			dat = PacketFromPC.raw[cnt * 2 + 18];
			dat = (dat << 8) + PacketFromPC.raw[cnt * 2 + 17];
			AioAO[cnt] = dat;
			dn = (cnt >> 1) & 0x07;
			DacWriteMcp4822(dn, cnt & 0x01, dat);
		}
		for (cnt = 8; cnt < 16; cnt++) {
			dat = PacketFromPC.raw[cnt * 2 + 18];
			dat = (dat << 8) + PacketFromPC.raw[cnt * 2 + 17];
			AioAO[cnt] = dat;
//			AioAI[cnt] = dat;
			dn = (cnt >> 1) & 0x07;
			DacWriteMcp4822(dn, cnt & 0x01, dat);
		}
//		for (cnt = 16; cnt < 32; cnt++) {
//			AioAI[cnt] = 0;
//		}
	} else if (DaqMode == MODE_ECHODIO) {
		for (cnt = 0; cnt < 16; cnt++)
			DioDI[cnt] = PacketFromPC.raw[cnt + 1];
	} else if (DaqMode == MODE_ECHOAIO) {
		for (cnt = 0; cnt < 16; cnt++) {
			dat = PacketFromPC.raw[cnt * 2 + 18];
			dat = (dat << 8) + PacketFromPC.raw[cnt * 2 + 17];
			AioAI[cnt] = dat;
		}
//		for (cnt = 16; cnt < 32; cnt++) {
//			AioAI[cnt] = 0;
//		}
	} else {	// DaqMode == 0, and others(not 1,2,3,4)
		for (cnt = 0; cnt < 16; cnt++)
			DioDI[cnt] = PacketFromPC.raw[cnt + 1];
	}
}

void cmd_peekall(void)
{
	uchar	cnt, dn;
	ushort	dat;

	PacketToPC.raw[0] = CtrCT[0] & 0xff;
	PacketToPC.raw[1] = (CtrCT[0] >> 8) & 0xff;
	PacketToPC.raw[2] = TmrCT[0] & 0xff;
	PacketToPC.raw[3] = (TmrCT[0] >> 8) & 0xff;
	PacketToPC.raw[4] = CtrCT[1] & 0xff;
	PacketToPC.raw[5] = (CtrCT[1] >> 8) & 0xff;
	PacketToPC.raw[6] = TmrCT[1] & 0xff;
	PacketToPC.raw[7] = (TmrCT[1] >> 8) & 0xff;
	if (DaqMode == MODE_DIOC) {
		for (cnt = 0; cnt < DIO_CHMAX/8; cnt++) {
			get_di_port(cnt);
			PacketToPC.raw[cnt + 8] = DioDI[cnt];
		}
	} else if (DaqMode == MODE_AIOC) {
		for (cnt = 0; cnt < 16; cnt++) {
			dn = (cnt >> 3) & 0x03;
			if (PacketFromPC.raw[1] == 1)
				dn += 2;
			dat = AdcReadMcp3208(dn, cnt & 0x07);
			if (PacketFromPC.raw[1] == 0)
				AioAI[cnt] = dat;
			else
				AioAI[cnt + 16] = dat;

			PacketToPC.raw[cnt * 2 + 8] = dat & 0xff;
			PacketToPC.raw[cnt * 2 + 9] = (dat >> 8) & 0xff;
		}
	} else if (DaqMode == MODE_ECHODIO) {
		for (cnt = 0; cnt < 16; cnt++)
			PacketToPC.raw[cnt + 8] = DioDI[cnt];
	} else if (DaqMode == MODE_ECHOAIO) {
		for (cnt = 0; cnt < 16; cnt++) {
			if (PacketFromPC.raw[1] == 1)
				dat = AioAI[cnt + 16];
			else
				dat = AioAI[cnt];

			PacketToPC.raw[cnt * 2 + 8] = dat & 0xff;
			PacketToPC.raw[cnt * 2 + 9] = (dat >> 8) & 0xff;
		}
	} else {	// DaqMode == 0, and others(not 1,2,3,4)
		for (cnt = 0; cnt < 16; cnt++)
			PacketToPC.raw[cnt + 8] = DioDI[cnt];
	}
	ToPcRdy = 1;
}

void initCounter(void)
{
	T3CON = 0xfd;	// RD16(16bitmode),1/8prescale,internal,EnTMR3
					// 48MHz 1/4: 12MHz 1/8: 1.5MHz
	if (DaqMode == MODE_DIOC || DaqMode == MODE_AIOC) {
		T0CON = 0xA8;	// EnTMR0, 16bitmode, T0CKI, none-prescale
		T1CON = 0x83;	// 16bitmode, T13CKI, 1/1 prescale, EnTMR1
	} else if (DaqMode == MODE_ECHODIO || DaqMode == MODE_ECHOAIO) {
		T0CON = 0x87;	// EnTMR0, 16bitmode, internal, 1/256 prescale
						// 48MHz 1/4: 12MHz 1/256: 46.875KHz
		T1CON = 0xB1;	// 16bitmode, internal, 1/8 prescale, EnTMR1
						// 48MHz 1/4: 12MHz 1/8: 1.5MHz
	}
}

/********************************************************************
 *	j^R}hMƎs.
 ********************************************************************
 */
extern byte HIDRxReport64(char *buffer);
extern void HIDTxReport64(char *buffer);
void ProcessIO(void)
{
	// ԓpPbgł邱ƁAA
	// Ώۂ̎Mf[^.
	if((ToPcRdy == 0) && (!mHIDRxIsBusy())) {

		//Mf[^΁AMf[^󂯎.
		HIDRxReport64((char *)&PacketFromPC);
		PacketToPC.raw[0]=Cmd0;		// CMD ECHOBACK

		//R}hɑΉ鏈Ăяo.
		if(Cmd0==HIDASP_PEEK) 	{cmd_peek();}	// [ǂݏo.
		else if(Cmd0==HIDASP_POKE) 	{cmd_poke();}	// [.
		else if(Cmd0==HIDASP_TEST) 	{cmd_echo();}	// ڑeXg.
		else if (Cmd0 == HID_POKEALL)	{cmd_pokeall();}// Poke All.
		else if (Cmd0 == HID_PEEKALL)	{cmd_peekall();}// Peek All.
		else if (Cmd0 == HID_CHPOKE)	{cmd_chpoke();}	// Channel Poke.
		else if (Cmd0 == HID_CHPEEK)	{cmd_chpeek();}	// Channel Peek.
		else if (Cmd0 == HID_MODE)	{cmd_mode();}	// DaqMode set.
		else if (Cmd0 == HID_STAT)	{cmd_stat();}	// Report Status.
	}

	// KvȂAԓpPbgC^vg](EP1)ŃzXgPCɕԋp.
	if( ToPcRdy ) {
		if(!mHIDTxIsBusy()) {
			HIDTxReport64((char *)&PacketToPC);
			ToPcRdy = 0;
		}
	}
}
