Imports System.Net
Imports System.IO
Imports System.Collections.Generic
Imports System.Collections.Specialized
Imports System.Text

'''<summary>
'''HttpWebRequest,HttpWebResponsegp{IȒʐM@\񋟂
'''</summary>
'''<remarks>
'''vLVȂǂݒ肷邽߁AgpOɐÓI\bhInitializeConnectionĂяoƁB
'''ʐMɂĕKvɂȂHTTPwb_̕tȂǂ́AhNXGetContent\bhI[o[ChčsB
'''</remarks>
Public Class HttpConnection
    '''<summary>
    '''vLV
    '''</summary>
    Private Shared proxy As WebProxy = Nothing

    '''<summary>
    '''[U[IvLV̕
    '''</summary>
    Private Shared proxyType As ProxyType = ProxyType.IE

    '''<summary>
    '''NbL[ۑpRei
    '''</summary>
    Private Shared cookieContainer As New CookieContainer

    '''<summary>
    '''ς݃tO
    '''</summary>
    Private Shared isInitialize As Boolean = False

    '''<summary>
    '''HTTPʐM̃\bh
    '''</summary>
    '''<remarks>
    '''̃\bhiHEAD,PUT,CONNECTȂǁjKvȏꍇ͒ǉ邱
    '''</remarks>
    Protected Enum RequestMethod
        ReqGet
        ReqPost
    End Enum

    '''<summary>
    '''HttpWebRequestIuWFNg擾
    '''</summary>
    '''<remarks>
    '''Kvȃwb_ނ͌Ăяoŕt邱
    '''iTimeout,AutomaticDecompression,AllowAutoRedirect,UserAgent,ContentType,Accept,HttpRequestHeader.Authorization,JX^wb_j
    '''<param name="method">HTTPʐM\bhiGET/POSTȂǁj</param>
    '''<param name="requestUri">ʐMURI</param>
    '''<param name="param">GET̃NGA܂POST̃{fBf[^</param>
    '''<param name="withCookie">ʐMcookiegp邩</param>
    '''<returns>Ŏw肳ꂽe𔽉fHttpWebRequestIuWFNg</returns>
    Protected Shared Function CreateRequest(ByVal method As RequestMethod, _
                                            ByVal requestUri As Uri, _
                                            ByVal param As SortedList(Of String, String), _
                                            ByVal withCookie As Boolean _
                                        ) As HttpWebRequest
        If Not isInitialize Then Throw New Exception("Sequence error.(not initialized)")

        'GET\bh̏ꍇ̓NGurl
        Dim ub As New UriBuilder(requestUri.AbsoluteUri)
        If method = RequestMethod.ReqGet Then
            ub.Query = CreateQueryString(param)
        End If

        Dim webReq As HttpWebRequest = DirectCast(WebRequest.Create(ub.Uri), HttpWebRequest)

        'vLVݒ
        If proxyType <> proxyType.IE Then webReq.Proxy = proxy

        If method = RequestMethod.ReqGet Then
            webReq.Method = "GET"
        Else
            webReq.Method = "POST"
            webReq.ContentType = "application/x-www-form-urlencoded"
            'POST\bh̏ꍇ́A{fBf[^ƂăNG\ď
            Using writer As New StreamWriter(webReq.GetRequestStream)
                writer.Write(CreateQueryString(param))
            End Using
        End If
        'cookieݒ
        If withCookie Then webReq.CookieContainer = cookieContainer
        '^CAEgݒ
        webReq.Timeout = DefaultTimeout

        Return webReq
    End Function

    '''<summary>
    '''HTTP̉AXg[̃Rs[ԋp
    '''</summary>
    '''<remarks>
    '''_CNg̏ꍇiAllowAutoRedirect=Falsȅꍇ̂݁j́AheaderInfoCX^XLocationǉă_CNgԋpB{fBf[^͏ȂB
    '''WebException̓nhĂȂ̂ŁAĂяoŃLb`邱
    '''</remarks>
    '''<param name="webRequest">HTTPʐMNGXgIuWFNg</param>
    '''<param name="contentStream">[OUT]HTTP̃{fBXg[̃Rs[ݗp</param>
    '''<param name="headerInfo">[IN/OUT]HTTP̃wb_Bwb_L[ɂċf[^̃RNVnƂŁAỸwb_f[^ɐݒ肵Ė߂</param>
    '''<param name="withCookie">ʐMcookiegp</param>
    '''<returns>HTTP̃Xe[^XR[h</returns>
    Protected Shared Function GetResponse(ByVal webRequest As HttpWebRequest, _
                                        ByVal contentStream As Stream, _
                                        ByVal headerInfo As Dictionary(Of String, String), _
                                        ByVal withCookie As Boolean _
                                    ) As HttpStatusCode
        Using webRes As HttpWebResponse = CType(webRequest.GetResponse(), HttpWebResponse)
            Dim statusCode As HttpStatusCode = webRes.StatusCode
            'cookieێ
            If withCookie Then SaveCookie(webRes.Cookies)
            '_CNg̏ꍇ́A_CNgݒ肵ďI
            GetHeaderInfo(webRes, headerInfo)
            '̃Xg[Rs[Ė߂
            If webRes.ContentLength > 0 Then
                Using stream As Stream = webRes.GetResponseStream()
                    If stream IsNot Nothing Then CopyStream(stream, contentStream)
                End Using
            End If
            Return statusCode
        End Using
    End Function

    Protected Shared Function GetResponse(ByVal webRequest As HttpWebRequest, _
                                        ByRef contentText As String, _
                                        ByVal headerInfo As Dictionary(Of String, String), _
                                        ByVal withCookie As Boolean _
                                    ) As HttpStatusCode
        Using webRes As HttpWebResponse = CType(webRequest.GetResponse(), HttpWebResponse)
            Dim statusCode As HttpStatusCode = webRes.StatusCode
            'cookieێ
            If withCookie Then SaveCookie(webRes.Cookies)
            '_CNg̏ꍇ́A_CNgݒ肵ďI
            GetHeaderInfo(webRes, headerInfo)
            '̃Xg[eLXgɏoĖ߂
            If contentText Is Nothing Then Throw New ArgumentNullException("contentText")
            If webRes.ContentLength > 0 Then
                Using sr As StreamReader = New StreamReader(webRes.GetResponseStream)
                    contentText = sr.ReadToEnd()
                End Using
            End If
            Return statusCode
        End Using
    End Function

    Protected Shared Function GetResponse(ByVal webRequest As HttpWebRequest, _
                                        ByVal contentBitmap As Bitmap, _
                                        ByVal headerInfo As Dictionary(Of String, String), _
                                        ByVal withCookie As Boolean _
                                    ) As HttpStatusCode
        Using webRes As HttpWebResponse = CType(webRequest.GetResponse(), HttpWebResponse)
            Dim statusCode As HttpStatusCode = webRes.StatusCode
            'cookieێ
            If withCookie Then SaveCookie(webRes.Cookies)
            '_CNg̏ꍇ́A_CNgݒ肵ďI
            GetHeaderInfo(webRes, headerInfo)
            '̃Xg[BitmapɂĖ߂
            If webRes.ContentLength > 0 Then contentBitmap = New Bitmap(webRes.GetResponseStream)
            Return statusCode
        End Using
    End Function

    Private Shared Sub SaveCookie(ByVal cookieCollection As CookieCollection)
        For Each ck As Cookie In cookieCollection
            If ck.Domain.StartsWith(".") Then
                ck.Domain = ck.Domain.Substring(1, ck.Domain.Length - 1)
                cookieContainer.Add(ck)
            End If
        Next
    End Sub

    '''<summary>
    '''in/out̃Xg[CX^X󂯎ARs[ĕԋp
    '''</summary>
    '''<param name="inStream">Rs[Xg[CX^XBǂݎł邱</param>
    '''<param name="outStream">Rs[Xg[CX^XB݉ł邱</param>
    Private Shared Sub CopyStream(ByVal inStream As Stream, ByVal outStream As Stream)
        If inStream Is Nothing Then Throw New ArgumentNullException("inStream")
        If outStream Is Nothing Then Throw New ArgumentNullException("outStream")
        If Not inStream.CanRead Then Throw New ArgumentException("Input stream can not read.")
        If Not outStream.CanWrite Then Throw New ArgumentException("Output stream can not write.")
        If inStream.CanSeek AndAlso inStream.Length = 0 Then Throw New ArgumentException("Input stream do not have data.")

        Do
            Dim buffer(1024) As Byte
            Dim i As Integer = buffer.Length
            i = inStream.Read(buffer, 0, i)
            If i = 0 Then Exit Do
            outStream.Write(buffer, 0, i)
        Loop
    End Sub

    '''<summary>
    '''headerInfõL[Ŏw肳ꂽHTTPwb_擾Ei[BredirectLocationwb_̓eǋL
    '''</summary>
    '''<param name="webResponse">HTTP</param>
    '''<param name="headerInfo">[IN/OUT]L[Ƀwb_w肵f[^̃RNVB擾lf[^ɃZbgĖ߂</param>
    Private Shared Sub GetHeaderInfo(ByVal webResponse As HttpWebResponse, _
                                    ByVal headerInfo As Dictionary(Of String, String))

        If headerInfo Is Nothing Then Exit Sub

        If headerInfo.Count > 0 Then
            Dim keys(headerInfo.Count - 1) As String
            headerInfo.Keys.CopyTo(keys, 0)
            For Each key As String In keys
                If Array.IndexOf(webResponse.Headers.AllKeys, key) > -1 Then
                    headerInfo.Item(key) = webResponse.Headers.Item(key)
                Else
                    headerInfo.Item(key) = ""
                End If
            Next
        End If

        Dim statusCode As HttpStatusCode = webResponse.StatusCode
        If statusCode = HttpStatusCode.MovedPermanently OrElse _
           statusCode = HttpStatusCode.Found OrElse _
           statusCode = HttpStatusCode.SeeOther OrElse _
           statusCode = HttpStatusCode.TemporaryRedirect Then
            If headerInfo.ContainsKey("Location") Then
                headerInfo.Item("Location") = webResponse.Headers.Item("Location")
            Else
                headerInfo.Add("Location", webResponse.Headers.Item("Location"))
            End If
        End If
    End Sub

    '''<summary>
    '''NGRNVkey=value`̕ɍ\Ė߂
    '''</summary>
    '''<param name="param">NGA܂̓|Xgf[^ƂȂkey-valueRNV</param>
    Protected Shared Function CreateQueryString(ByVal param As SortedList(Of String, String)) As String
        If param Is Nothing OrElse param.Count = 0 Then Return String.Empty

        Dim query As New StringBuilder
        For Each key As String In param.Keys
            query.AppendFormat("{0}={1}&", UrlEncode(key), UrlEncode(param(key)))
        Next
        Return query.ToString(0, query.Length - 1)
    End Function

    '''<summary>
    '''NG`ikey1=value1&key2=value2&...j̕key-valueRNVɋlߒ
    '''</summary>
    '''<param name="queryString">NG</param>
    '''<returns>key-valuẽRNV</returns>
    Protected Shared Function ParseQueryString(ByVal queryString As String) As NameValueCollection
        Dim query As New NameValueCollection
        Dim parts() As String = queryString.Split("&"c)
        For Each part As String In parts
            Dim index As Integer = part.IndexOf("="c)
            If index = -1 Then
                query.Add(Uri.UnescapeDataString(part), "")
            Else
                query.Add(Uri.UnescapeDataString(part.Substring(0, index)), Uri.UnescapeDataString(part.Substring(index + 1)))
            End If
        Next
        Return query
    End Function

    '''<summary>
    '''2oCglUrlGR[h
    '''</summary>
    '''<param name="str">GR[h镶</param>
    '''<returns>GR[hʕ</returns>
    Protected Shared Function UrlEncode(ByVal stringToEncode As String) As String
        Const UnreservedChars As String = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.~"
        Dim sb As New StringBuilder
        Dim bytes As Byte() = Encoding.UTF8.GetBytes(stringToEncode)

        For Each b As Byte In bytes
            If UnreservedChars.IndexOf(Chr(b)) <> -1 Then
                sb.Append(Chr(b))
            Else
                sb.AppendFormat("%{0:X2}", b)
            End If
        Next
        Return sb.ToString()
    End Function

#Region "DefaultTimeout"
    '''<summary>
    '''ʐM^CAEgԁimsj
    '''</summary>
    Private Shared timeout As Integer = 20000

    '''<summary>
    '''ʐM^CAEgԁimsjB10`120b͈̔͂ŎwB͈͊O20bƂ
    '''</summary>
    Protected Shared Property DefaultTimeout() As Integer
        Get
            Return timeout
        End Get
        Set(ByVal value As Integer)
            Const TimeoutMinValue As Integer = 10000
            Const TimeoutMaxValue As Integer = 120000
            Const TimeoutDefaultValue As Integer = 20000
            If value < TimeoutMinValue OrElse value > TimeoutMaxValue Then
                ' ͈͊OȂftHglݒ
                timeout = TimeoutDefaultValue
            Else
                timeout = value
            End If
        End Set
    End Property
#End Region

    '''<summary>
    '''ʐMNX̏B^CAEglƃvLVݒ肷
    '''</summary>
    '''<remarks>
    '''ʐMJnOɍŒxĂяo
    '''</remarks>
    '''<param name="timeout">^CAEglibj</param>
    '''<param name="proxyType">ȂEwEIEftHg</param>
    '''<param name="proxyAddress">vLṼzXgorIPAhX</param>
    '''<param name="proxyPort">vLṼ|[gԍ</param>
    '''<param name="proxyUser">vLVF؂Kvȏꍇ̃[UBsvȂ󕶎</param>
    '''<param name="proxyPassword">vLVF؂Kvȏꍇ̃pX[hBsvȂ󕶎</param>
    Public Shared Sub InitializeConnection( _
            ByVal timeout As Integer, _
            ByVal proxyType As ProxyType, _
            ByVal proxyAddress As String, _
            ByVal proxyPort As Integer, _
            ByVal proxyUser As String, _
            ByVal proxyPassword As String)
        isInitialize = True
        ServicePointManager.Expect100Continue = False
        DefaultTimeout = timeout * 1000     's -> ms
        Select Case proxyType
            Case proxyType.None
                proxy = Nothing
            Case proxyType.Specified
                proxy = New WebProxy("http://" + proxyAddress + ":" + proxyPort.ToString)
                If Not String.IsNullOrEmpty(proxyUser) OrElse Not String.IsNullOrEmpty(proxyPassword) Then
                    proxy.Credentials = New NetworkCredential(proxyUser, proxyPassword)
                End If
            Case proxyType.IE
                'IEݒiVXeݒj̓ftHglȂ̂ŏȂ
        End Select
        proxyType = proxyType
    End Sub
End Class
