<?xml version="1.0" encoding="Windows-31J"?>
<!--
//
// CopyRight (C) 2003, NTT All rights reserved.
//
//	DefaultButton.xsl
//
//			ύX
//				2003.02.01	VK쐬
//
//	@\
//  ftHg{^쐬xsl
//
-->
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:java="http://xml.apache.org/xslt/java"
	version="1.0">

	<xsl:include href="Common.xsl"/>

	<xsl:output
		method="html"
		doctype-public="-//W3C//DTD HTML 4.0//EN"
		doctype-system="http://www.w3.org/TR/REC-html40/strict.dtd"
		encoding="Windows-31J"
		indent="yes"
		media-type="text/html"
		version="4.0"/>

	<xsl:variable name="BaseURL" select="Button/ContentsInformation/BaseURL/text()"/>
	<xsl:variable name="ScriptURL" select="Button/ContentsInformation/ScriptURL/text()"/>
	<xsl:template match="/">
		<!-- html^Ȍo -->
		<html>
			<!-- head^Ȍo -->
			<head>
				<title><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;Titles/Title[@id='Button']&quot;)"/></title>
				<script language="JavaScript" src="{$ScriptURL}"/>
				<xsl:call-template name="createLMSScript">
					<xsl:with-param name="mode" select="'Button'"/>
				</xsl:call-template>
			</head>

			<!-- body^Ȍo -->
			<body _lmsname="Button" onload="javascript:LMSUI_NavInitialize();" onunload="javascript:LMSUI_NavTerminate();" >
				<xsl:call-template name="createLMSTags">
					<xsl:with-param name="mode" select="'Button'"/>
				</xsl:call-template>

				<!-- css̒` -->
				<style>
					body {
						background-color: white;
						margin-left: 0;
						margin-top: 0;
						margin-bottom: 0;
						margin-right: 0;
					}

					.over {
						border-width: thin;
						border-style: solid;
						border-color: gray;
						background-color: darkgray;
						color: white;
						font-size: 120%;
						cursor: hand;
					}

					.out {
						border-width: thin;
						border-style: solid;
						border-color: gray;
						background-color: whitesmoke;
						color: black;
						font-size: 120%;
						cursor: auto;
					}
				</style>

				<!-- {^̏o -->
				<xsl:apply-templates select="Button/ActivityInformation"/>
			</body>
		</html>

	</xsl:template>

	<!-- Button/ActivityInformationɑΉev[g -->
	<xsl:template match="ActivityInformation">
		<xsl:variable name="onmouseover">javascript:this.className='over';</xsl:variable>
		<xsl:variable name="onmouseout">javascript:this.className='out';</xsl:variable>

<div id="hanger-popup-study">

<div id="controlBtn">

		<table align="left" width="50%">
			<tr>
				<td nowrap="1">
<!-- _~[{^FIẼ^[L[΍ -->
<input type="image" src="contents/_default/image/clear.gif" style="margin:0;border:0;padding:0;width:0;height:0;"/>
					<!-- V[PVO{^̐ -->
					<xsl:apply-templates select="SequencingInformation">
						<xsl:with-param name="onmouseover" select="$onmouseover"/>
						<xsl:with-param name="onmouseout" select="$onmouseout"/>
					</xsl:apply-templates>

					<!-- ڎ{^̐ -->
					<!-- R}h{^ɑΉ摜t@Cw肷B-->
					<input type="image" src="contents/_default/image/button/Mokuji.gif">
						<xsl:attribute name="onfocus">javascript:this.blur();</xsl:attribute>
						<xsl:attribute name="onclick">javascript:LMSUI_NavOpenContentsMenuWindow();</xsl:attribute>
						<xsl:attribute name="alt"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;Buttons/Button[@id='ContentsMenu']&quot;)"/></xsl:attribute>
					</input>
				</td>
			</tr>
		</table>

		<!-- ⏕\[X{^̐ -->
		<xsl:if test="AuxiliaryResources/AuxiliaryResource">
			<table align="right" width="49%">
				<tr>
					<td><xsl:call-template name="nbsp"/></td>
				</tr>
				<tr>
					<td nowrap="1" style="text-align: right;">
						<xsl:apply-templates select="AuxiliaryResources/AuxiliaryResource">
							<xsl:with-param name="onmouseover" select="$onmouseover"/>
							<xsl:with-param name="onmouseout" select="$onmouseout"/>
							<xsl:with-param name="activityID" select="ActivityID/text()"/>
						</xsl:apply-templates>
					</td>
				</tr>
			</table>
		</xsl:if>
</div>

</div>

	</xsl:template>

	<!-- V[PVO{^̐ɑΉev[g -->
	<xsl:template match="SequencingInformation">
		<xsl:param name="onmouseover"/>
		<xsl:param name="onmouseout"/>

		<!-- PreviousɑΉ{^ -->
		<xsl:if test="CanPrevious/text()!='false'">
			<!-- R}h{^ɑΉ摜t@Cw肷B-->
			<input type="image" src="contents/_default/image/button/prev.gif">
				<xsl:attribute name="onfocus">javascript:this.blur();</xsl:attribute>
				<xsl:attribute name="onclick">javascript:LMSUI_NavPrevious(this);</xsl:attribute>
				<xsl:attribute name="alt"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;Buttons/Button[@id='Previous']&quot;)"/></xsl:attribute>
			</input>
			<xsl:call-template name="nbsp"/>
		</xsl:if>

		<!-- ContinueɑΉ{^ -->
		<xsl:if test="CanContinue/text()!='false'">
			<!-- R}h{^ɑΉ摜t@Cw肷B-->
			<input type="image" src="contents/_default/image/button/next.gif">
				<xsl:attribute name="onfocus">javascript:this.blur();</xsl:attribute>
				<xsl:attribute name="onclick">javascript:LMSUI_NavContinue(this);</xsl:attribute>
				<xsl:attribute name="alt"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;Buttons/Button[@id='Continue']&quot;)"/></xsl:attribute>
			</input>
			<xsl:call-template name="nbsp"/>
		</xsl:if>

		<!-- ExitAllɑΉ{^ -->
		<xsl:if test="CanExitAll/text()!='false'">
			<!-- R}h{^ɑΉ摜t@Cw肷B-->
			<input type="image" src="contents/_default/image/button/exitall.gif">
				<xsl:attribute name="onfocus">javascript:this.blur();</xsl:attribute>
				<xsl:attribute name="onclick">javascript:LMSUI_NavExitAll(this);</xsl:attribute>
				<xsl:attribute name="alt"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;Buttons/Button[@id='ExitAll']&quot;)"/></xsl:attribute>
			</input>
			<xsl:call-template name="nbsp"/>
		</xsl:if>

		<!-- SuspendAllɑΉ{^ -->
		<xsl:if test="CanSuspendAll/text()!='false'">
			<!-- R}h{^ɑΉ摜t@Cw肷B-->
			<input type="image" src="contents/_default/image/button/suspendall.gif">
				<xsl:attribute name="onfocus">javascript:this.blur();</xsl:attribute>
				<xsl:attribute name="onclick">javascript:LMSUI_NavSuspendAll(this);</xsl:attribute>
				<xsl:attribute name="alt"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;Buttons/Button[@id='SuspendAll']&quot;)"/></xsl:attribute>
			</input>
			<xsl:call-template name="nbsp"/>
		</xsl:if>

		<!-- 1ȏ{^łꍇ&nbsp;5o͂  ڎ{^Ƃ̋ -->
		<xsl:if test="*[starts-with(name(), 'Can')]/text()!='false'">
			<xsl:call-template name="nbsp">
				<xsl:with-param name="count" select="5"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<!-- ⏕\[X̐ɑΉev[g -->
	<xsl:template match="AuxiliaryResource">
		<xsl:param name="onmouseover"/>
		<xsl:param name="onmouseout"/>
		<xsl:param name="activityID"/>

		<!-- ⏕\[X̃|bvAbvEBhẼEBhẾu%ANeBreBID%_AuxiliaryResource_nv -->
		<xsl:variable name="windowName"><xsl:value-of select="$activityID"/>_AuxiliaryResource_<xsl:value-of select="position()"/></xsl:variable>
		<xsl:variable name="features">LMSUI_NavGetMainFrame().g_auxiliaryResourceWindowFeatures</xsl:variable>

		<!-- R}h{^ɑΉ摜t@Cw肷B-->
		<input type="image" src="contents/_default/image/button/word.gif">
			<xsl:attribute name="onfocus">javascript:this.blur();</xsl:attribute>
			<xsl:attribute name="onclick">javascript:LMSUI_NavOpenWindow("<xsl:value-of select="ResourceID/text()"/>", "<xsl:value-of select="$windowName"/>", <xsl:value-of select="$features"/>);</xsl:attribute>
			<xsl:attribute name="alt"><xsl:value-of select="Purpose/text()"/></xsl:attribute>
		</input>
		<xsl:call-template name="nbsp"/>
	</xsl:template>

</xsl:stylesheet>
