/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.lms;

import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerCheckUtil;
import jp.co.ntt.lms.installer.core.util.InstallerPropertiesUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;
import jp.co.ntt.lms.installer.util.StringUtil;

/**
 * XCalatݒt@C̏ڂɂē͂߂ANVNXB
 * @author T.Nishiki
 */
public class XcalatInputAction implements InstallerAction {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB
	 */
	static {
		_logger = LoggerUtil.getLogger(XcalatInputAction.class);
	}

	/**
	 * ANVXLbv邩肵܂B<br>
	 * SelectLoActionł̓͂ɊÂ肵܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return LOIPerceptionIĂȂtrue߂܂B
	 * @throws InstallerException ̌ƂȂ擾ɎsꍇB
	 * @see SelectLoAction
	 */
	public boolean isSkipped(InstallerValues values)
			throws InstallerException {
		LoggerUtil.methodHead(_logger, "isSkipped(InstallerValues)");

		boolean skipped = false;
		try {
			// LOIXcalat𖢑IɂĂꂢtrueB
			skipped = (values.getOptionLOSelected(
					XcalatInputValue.KEY_LO) == false);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		LoggerUtil.methodTail(_logger, "isSkipped(InstallerValues)", skipped);
		return skipped;
	}

	/**
	 * XCalatT[oݒt@C̏ڂɂḗEmF߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return XcalatInputValue߂܂B
	 * @throws InstallerException sɗOꍇB
	 * @see XcalatInputValue
	 */
	public InstallerActionValue action(InstallerValues values)
		throws InstallerException {

		LoggerUtil.methodHead(_logger, "action(InstallerValues)");

		// ̓f[^
		XcalatInputValue inputValue = null;
		try {
			// ̓f[^iftHgf[^ƂĎgpj
			XcalatInputValue defaultValue = getDefaultValue(values);
			// ^Cg\
			InstallerUiUtil.outputMessageAsTitle(
				values, "XcalatInputAction.welcome");

			while (true) {
				// ͎s
				inputValue = readInputValue(values, defaultValue);
				// ͊mF
				if (confirmInputValue(values, inputValue) == true) {
					// ͊mFς񂾏ꍇAw肳ꂽfBNg
					// 쐬ΏۂƂēo^B
					File dir = new File(inputValue.getMaterialInstallPath());
					values.addMadeDirectory(dir);
					break;
				}
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger, "action(InstallerValues)", inputValue);
		return inputValue;
	}


	/**
	 * Xcalatݒt@C̏ڂɂē͂߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param defaultValue ftHglB
	 * @return ͂ꂽeXcalatInputValueƂĖ߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private XcalatInputValue readInputValue(
			InstallerValues values, XcalatInputValue defaultValue)
			throws InstallerException {
		LoggerUtil.methodHead(_logger,
			"readInputValue(InstallerValues)");

		XcalatInputValue inputValue = null;
		try {
			inputValue = new XcalatInputValue();
			////////////////////////////////////////////////////////////////////
			// T[oݒ
			// =================================================================
			// ftHg̃T[o擾
			String[] defaultServerNames = defaultValue.getServerNames();
			// =================================================================
			// T[o
			int serverNumber = 0;
			do {
				serverNumber = InstallerUiUtil.askUserInputInteger(
						values,	"XcalatInputAction.prompt.serverNumber");
			} while (serverNumber <= 0);
			// =================================================================
			// T[o̐
			for (int i = 0; i < serverNumber ; i++) {
				// =============================================================
				// zXg
				String defaultServerName = null;
				if (i < defaultServerNames.length) {
					defaultServerName = defaultServerNames[i];
				}
				String serverName = null;
				while (true) {
					serverName = InstallerUiUtil.askUserInput(values,
							"XcalatInputAction.prompt.serverName",
							defaultServerName);
					// 
					if (InstallerCheckUtil.isEmptyViolation(serverName, values,
							"XcalatInputAction.error.serverName.empty")) {
						continue;
					}
					break;
				}
				inputValue.addServerName(serverName);
			}
			////////////////////////////////////////////////////////////////////
			// ފi[fBNg
			String materialInstallPath = null;
			while (true) {
				materialInstallPath = InstallerUiUtil.askUserInput(
						values,
						"XcalatInputAction.prompt.materialInstallPath",
						defaultValue.getMaterialInstallPath());
				// 
				if (InstallerCheckUtil.isEmptyViolation(
						materialInstallPath, values,
						"XcalatInputAction.error.materialInstallPath.empty")) {
					continue;
				}
				// fBNg`FbN
				if (InstallerCheckUtil.isFilePath(
						materialInstallPath, values,
						"XcalatInputAction.error.materialInstallPath.file")) {
					continue;
				}
				break;
			}
			inputValue.setMaterialInstallPath(materialInstallPath);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"readInputValue(InstallerValues)", inputValue);
		return inputValue;
	}

	/**
	 * ͂e\A[UɊmF߂܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param inputValue ͂ꂽe
	 * @return ͂ꂽeɃ[UmFƂꂽꍇtrueA
	 *          ƂȂꍇfalse߂܂B
	 * @throws InstallerException ɃG[ꍇB
	 */
	private boolean confirmInputValue(
			InstallerValues values, XcalatInputValue inputValue)
			throws InstallerException {

		LoggerUtil.methodHead(_logger,
			"confirmInputValue(InstallerValues, XcalatInputValue)");
		boolean confirm = false;
		try {
			InstallerUiUtil.outputConfirmTitle(values,
				"XcalatInputAction.confirm.title");
			// =================================================================
			// ͓e̕\
			// =================================================================
			// XcalatzXg
			String[] serverNames = inputValue.getServerNames();
			for ( int i = 0; i < serverNames.length; i++ ) {
				Object[] messageParams = new Object[] {
					new Integer(i + 1)
				};
				InstallerUiUtil.outputConfirm(values,
					"XcalatInputAction.confirm.serverName",
					messageParams,
					serverNames[i]);
			}
			// =================================================================
			// ފi[fBNg
			InstallerUiUtil.outputConfirm(values,
				"XcalatInputAction.confirm.materialInstallPath",
				inputValue.getMaterialInstallPath());
			// =================================================================
			// [UmF
			confirm = InstallerUiUtil.askUserConfirm(
				values, "XcalatInputAction.confirm" );
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"confirmInputValue(InstallerValues, XcalatInputValue)", confirm);
		return confirm;
	}

	/**
	 * ̃f[^A͍ڂ̃ftHgl擾܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return ftHglXcalatInputValuě`Ŗ߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private XcalatInputValue getDefaultValue(InstallerValues values)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"getDefaultValue(InstallerValues)");

		XcalatInputValue defaultValue = null;
		try {
			defaultValue = new XcalatInputValue();
			////////////////////////////////////////////////////////////////////
			// vpeB̎擾
			// =================================================================
			// ̓e
			File existFile = values.getFileOnSystem(
					defaultValue.getTargetFileKey());
			Properties existProperties
				= FileUtil.loadAsProperties(existFile);
			// =================================================================
			// \[Xi{j̓e
			Properties resourceProperties
				= InstallerPropertiesUtil.load(
					values, defaultValue.getTargetFileKey());
			////////////////////////////////////////////////////////////////////
			// ftHgl̐ݒ
			// =================================================================
			// zXg
			for (int i = 0; true; i++) {
				// ̏擾Aݒ肳ĂȂΏIB
				String existServerName = existProperties.getProperty(
					XcalatInputValue.KEY_PREFIX_SERVER_NAME + (i + 1));
				if (StringUtil.isEmpty(existServerName)) {
					break;
				}
				String serverName
					= InstallerPropertiesUtil.determineInitialValue(
						existProperties, resourceProperties,
						XcalatInputValue.KEY_PREFIX_SERVER_NAME + (i + 1));
				defaultValue.addServerName(serverName);
			}
			// =================================================================
			// ފi[fBNg
			String materialInstallPath
				= InstallerPropertiesUtil.determineInitialValue(
					existProperties, resourceProperties,
					XcalatInputValue.KEY_MATERIAL_INSTALL_PATH);
			defaultValue.setMaterialInstallPath(materialInstallPath);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getDefaultValue(InstallerValues)", defaultValue);
		return defaultValue;
	}
}
