/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
// wK([[Uꗗ/LOꗗ])O擾ʃNX
// 
//
//	ύX
//	2004.01.08 VK쐬		ishizaki 
//

package jp.co.ntt.lms.xms.logsumup;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleClient;
import jp.co.ntt.lms.xms.framework.XmsException;
import jp.co.ntt.lms.xms.framework.XmsSystemException;
import jp.co.ntt.lms.xms.framework.XmsWarningException;
import jp.co.ntt.lms.xms.framework.base.Logic;
import jp.co.ntt.lms.xms.framework.base.LogicResult;

/**
 * wK([[Uꗗ/LOꗗ])O擾ʃNX
 * 
 * <pre>
 * [Uꗗ/LOꗗʂ̃C^[tF[X񋟂
 * 
 *  
 * 
 * </pre>
 * 
 * @author ishizaki
 * 
 */
public abstract class LoLogLearnStatusLogic implements Logic {
	/**  */
	private LoLogLearnStatusParam reference;
	/** ANV[O[v/Rei.O[v/.[U/Rei.[U/ */
	private int action;
	/** LoId */
	private String loId;
	/** LOIDXg*/
	private List loIdList;
	/** O[vXg */
	private List groupIdList;
	/** [UID */
	private String userId;
	/** [UĂO[v*/
	private String belonggroupid;

	/** [Ul */
	protected int userCount;
	/** LO */
	protected int loCount;
	/**j[ʂ̉ʕ\ł邩 */
	protected boolean isFirst;

	/**
	 * RXgN^
	 * @param action 		I̎d(O[v/Rei,O[v/,[U/Rei,[U/)
	 * @param loId 			LOID	
	 * @param loIdList 		LOID̃Xg(Reiw̏ꍇLOID̃Xg
	 * @param userId 		[Uhc
	 * @param geroupIdList	O[vID̃Xg(O[vI΂ꂽꍇO[v̉̃Xg)
	 * @param userCount 	O[v̉ɂ郆[U̐l
	 * @param loCount  	 	ReỉɂLO̐
	 *
	 * @exception XmsException
	 */
	public LoLogLearnStatusLogic(
		LoLogLearnStatusParam param,
		int action,
		String realLoId,
		List loIdList,
		String userId,
		List groupIdList,
		int userCount,
		int loCount)
		throws XmsException {
		try {
			this.reference = param; 			//
			this.userId = userId;				//[UID
			this.groupIdList = groupIdList; 	//O[vhcXg
			this.action = action; 				//action
			this.loId = realLoId; 				//realLoId
			this.loIdList = loIdList;			//LOID
			this.userCount = userCount;		//[Ul
			this.loCount = loCount;			//lo̐
			this.belonggroupid = reference.getBelonggroupid();	//[Ȕꍇ[UĂO[v

			//j[炫ǂ
			if(param.getMenu()== null){
				//j[ʂ炫
				this.isFirst= true;
			}else{
				//j[ʂ炫ĂȂ
				this.isFirst= false;
			}
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	//---- Oo͋ʃC^[tF[X-------------------------------------------
	/**
	 * OWvi[IuWFNgԋp.
	 *
	 * @param dataAccess f[^ANZX
	 * @return OWvNX
	 * @exception XmsException
	 * @see jp.co.ntt.lms.xms.framework.base.Logic#doLogic(DataAccess)
	 */
	public LogicResult doLogic(DataAccess dataAccess) throws XmsException {
		try{
			LoLogLearnStatusResult result = new LoLogLearnStatusResult();

			String sql = null;
			
			/////////////////////////////////////////////////////////////////////
			//SQL̎擾 eI̎dɂSQL߁ALoLogResult擾
			/////////////////////////////////////////////////////////////////////
			//[UIꂽꍇ
			if (groupIdList.size() == 0) {
				if (belonggroupid.length() == 0) {
					GroupAndPeopleClient objGandP = new GroupAndPeopleClient();
					// qIDɐeID擾
					objGandP.setWhereChildID(userId);
					// 
					if( !objGandP.select() ) {
						throw new XmsSystemException(objGandP.getMessage());
					}

					// ܂猟ʂeID擾
					// O[v͐eЂƂȂ߁A[v͈
					if( objGandP.next() ) {
						this.belonggroupid = objGandP.getParentID();
					}					
				}

				switch (action) {
					//[U/Rei
					case LoLogConstant.LOG_SELECT_U_C :
						//ReỉLOȂɂȂ
						if (this.loIdList == null || this.loIdList.size() == 0) {
							//ʂ͂܂
							throw new XmsWarningException("logsumup.w.search.notfound");
						}
						sql = getUserContainerSql(userId, loId, belonggroupid);
						break;

					//[U/
					case LoLogConstant.LOG_SELECT_U_M :
						sql = getUserMateriallSql(userId, loId, belonggroupid);
						break;

					default :
						break;
				}
				//LoLogResutl̎擾
				result = getLog(result, dataAccess, sql, 0);

			//O[vIꂽꍇ
			} else {
				//O[v̉ɐlȂ
				if (this.userCount == 0) {
					//ʂ͂܂
					throw new XmsWarningException("logsumup.w.search.notfound");
				}

				// O[v̐SQLINƂȂ镶񂪊i[ꂽXg擾
				// Xg̃TCYSQLs
				//IN1000܂łȂ̂1000Ή
				LoLogCommon_inc common = new LoLogCommon_inc();
				List inGroupList = common.getGroupInSql(groupIdList);

				for (int i = 0; i < inGroupList.size(); i++) {
					//SQL̎擾
					switch (action) {
						//O[v/Rei
						case LoLogConstant.LOG_SELECT_G_C :
							//ReỉLOȂɂȂ
							if (this.loIdList == null
								|| this.loIdList.size() == 0) {
								//ʂ͂܂
								throw new XmsWarningException("logsumup.w.search.notfound");
							}
							sql = getGroupContainerSql((String) inGroupList.get(i),loId);
							break;
							//O[v/
						case LoLogConstant.LOG_SELECT_G_M :
							sql = getGroupMateriallSql((String) inGroupList.get(i),loId);
							break;

						default :
							break;
					}
					//LoLogResutl̎擾
					result = getLog(result, dataAccess, sql, i);
				}
			}
			// ʂȂꍇʂ͂܂
			if ( result.size() == 0 ) {
				throw new XmsWarningException("logsumup.w.search.notfound");	
			}
			//ATC𔽉fLoLogResultԋp
			return doAssain(result,reference.getSubordinateFlg());

		} catch (XmsException e) {
			throw e;
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	
	}

	//---------------- ȉhNXŎ start--------------------------------------------------------//
	/**
	 * ATC擾LoLogResultɔf.
	 * 
	 * @param result wKLogResultIuWFNg
	 * @param subordinateFlg ztO
	 * @return ATC񔽉fLoLogLearnStatusResult
	 */
	public abstract LoLogLearnStatusResult doAssain(LoLogLearnStatusResult result,String subordinateFlg)throws XmsException;


	/****
	 * Of[^̎擾s
	 * 
	 * @param log Oʊi[NX
	 * @param dataAccess f[^ANZXNX
	 * @param sql sSQL
	 * @param SQLIN傪1000zꍇgetLogsڂł邩
	 */
	public abstract LoLogLearnStatusResult getLog(
		LoLogLearnStatusResult result,
		DataAccess dataAccess,
		String sql,
		int sqlCount)
		throws XmsException;

	/***
	 * O[v/ReiIꍇSQLԋp.
	 * 
	 * @param inGroup O[vIDIN IN(O[vID,O[vID,O[vID,......)
	 * @param loId    ReiloId
	 * @return O[v/ReiIꍇSQL
	 * @exception XmsException
	 */
	public abstract String getGroupContainerSql(String inGroupId, String loId)
		throws XmsException;

	/**
	 * O[v/ނIꍇSQL擾.
	 * 
	 * @param inGroup O[vIDIN IN(O[vID,O[vID,O[vID,......)
	 * @param loId    ނloId
	 * @return O[v/ReiIꍇSQL
	 * @exception XmsException
	 * @see jp.co.ntt.lms.xms.logsumup.LoLogLearnStatusLogic#getGroupMateriallSql()
	 */
	public abstract String getGroupMateriallSql(String inGroupId, String loId)
		throws XmsException;

	/**
	 * 
	 * [U/ReiIꍇSQL擾.
	 * 
	 * @param userId [UID
	 * @param loId   ReiloId
	 * @param belonggroupid [UĂO[vID
	 * @return [U/ReiIꍇSQL
	 * @exception XmsException
	 */
	public abstract String getUserContainerSql(String userId, String loId,String belonggroupid)
		throws XmsException;

	/**
	 * [U/ނIꍇSQLԋp
	 * 
	 * 
	 * @param userId [UID
	 * @param loId   ނloId
	 * @param belonggroupid [UĂO[vID
	 * @return /ReiIꍇSQL
	 * @exception XmsException
	 */
	public abstract String getUserMateriallSql(String userId, String loId,String belonggroupid)
		throws XmsException;
	//---------------- ȉhNXŎ end--------------------------------------------------------//

	/**
	 * O[sOwiɐݒ肳ꂽSQL擾).
	 * 
	 * <pre>
	 * wKJn ȍ~ȑO
	 * ŏIANZX ȍ~ȑO
	 * ANZX ȏȉ
	 * ݐϑ؍ݎԁijȏȉ
	 * LO(%) ȏȉ
	 * iLO(%) ȏȉ
	 * ŐV_(%) ȏȉ
	 * ō_(%) ȏȉ
	 * Ґ(%) ȏȉ
	 * iҐ(%) ȏȉ
	 * 
	 * i
	 * </pre>
	 * 
	 * @return O[sOwiɐݒ肳ꂽSQL擾)
	 * @exception XmsException
	 */
	public String getGroupingSql() throws XmsException {
		StringBuffer sql = new StringBuffer();
		ArrayList list = new ArrayList();


		try {
			//XMS.init@C[hNX̃CX^X
			Environment objEnv = new Environment();

			//wKJn(date_start)
			{
				String condition = reference.getDateStartCondition();
				String value = reference.getDateStart();
				//ݒ肳Ă
				if (value != null && !value.equals("")) {
					StringBuffer buffer = new StringBuffer();

					//Oraclȅꍇ OR PostgreSQL̏ꍇ
					if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
						buffer.append(" MIN(lg.study_start_date) between ");
						buffer.append(getDateMinForOracle(value, condition));
						buffer.append(" AND ");
						buffer.append(getDateMaxForOracle(value, condition));
					//SQLServeȑꍇ
					} else if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )) {
						buffer.append(" MIN(lg.study_start_date) between '");
						buffer.append(getDateMin(value, condition));
						buffer.append("' AND '");
						buffer.append(getDateMax(value, condition));
						buffer.append("'");
					}
					list.add(buffer.toString());

				}
			}
			//ŏIANZX(date_last)
			{
				String condition = reference.getDateLastCondition();
				//selectȏ/ȉ
				String value = reference.getDateLast(); 
				//ݒ肳Ă
				if (value != null && !value.equals("")) {
					StringBuffer buffer = new StringBuffer();
					//Oraclȅꍇ OR PostgreSQL̏ꍇ
					if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
						buffer.append(" MAX(lg.last_access) between ");
						buffer.append(getDateMinForOracle(value, condition));
						buffer.append(" AND ");
						buffer.append(getDateMaxForOracle(value, condition));
					//SQLSERVER
					} else if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )) {
						buffer.append(" MAX(lg.last_access) between '");
						buffer.append(getDateMin(value, condition));
						buffer.append("' AND '");
						buffer.append(getDateMax(value, condition));
						//ŏIANZX ȍ~ ` ȑO
						buffer.append("'");
					}
					list.add(buffer.toString());

				}
			}

			//ANZX(total_access)
			{
				String condition = reference.getTotalAccessCondition();
				//selectȏ/ȉ
				String value = reference.getTotalAccess(); //
				//ݒ肳Ă
				if (value != null && !value.equals("")) {
					StringBuffer buffer = new StringBuffer();
					buffer.append(" SUM(lg.Access_cnt) >= ");
					buffer.append(getCountMin(value, condition));
					buffer.append(" AND SUM(lg.Access_cnt) <= ");
					buffer.append(getCountMax(value, condition));
					list.add(buffer.toString());

				}
			}

			//ݐϑ؍ݎ(total_learn_time)					
			{
				String condition = reference.getTotalLearnTimeCondition();
				//selectȏ/ȉ
				String value = reference.getTotalLearnTime(); //
				//ݒ肳Ă
				if (value != null && !value.equals("")) {
					StringBuffer buffer = new StringBuffer();
					buffer.append(" SUM(lg.residanceTime) >= ");
					buffer.append(getMSMin(value, condition));
					buffer.append("  AND SUM(lg.residanceTime) <= ");
					buffer.append(getMSMax(value, condition));
					//ݐϑ؍ݎ ȏ ` ȉ
					list.add(buffer.toString());
				}
			}
			
			//LO(mat_complete)
			{
				String condition = reference.getMatCompleteCondition();
				//selectȏ/ȉ
				String value = reference.getMatComplete(); //
				//ݒ肳Ă
				if (value != null && !value.equals("")) {
					StringBuffer buffer = new StringBuffer();

					//Oraclȅꍇ OR PostgreSQL̏ꍇ
					if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
						buffer.append(" ROUND((COUNT(DISTINCT(CASE WHEN lg.study_end_date IS NOT NULL THEN '1' || l.ChildID END)) * 100 / ");				
					//SQLServeȑꍇ
					} else if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )) {
						buffer.append(" ROUND((COUNT(DISTINCT(CASE WHEN lg.study_end_date IS NOT NULL THEN '1' + l.ChildID END)) * 100 / ");
					}
					buffer.append(loCount);
					buffer.append(" ),0) >= ");
					buffer.append(getPercentMin(value, condition));
					buffer.append(" AND ");

					//Oraclȅꍇ OR PostgreSQL̏ꍇ
					if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
						buffer.append(" ROUND((COUNT(DISTINCT(CASE WHEN lg.study_end_date IS NOT NULL THEN '1' || l.ChildID END)) * 100 / ");
					//SQLServeȑꍇ
					} else if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )) {
						buffer.append(" ROUND((COUNT(DISTINCT(CASE WHEN lg.study_end_date IS NOT NULL THEN '1' + l.ChildID END)) * 100 / ");
					}				
					buffer.append(loCount);
					buffer.append(" ),0) <= ");
					buffer.append(getPercentMax(value, condition));
					list.add(buffer.toString());
				}
			}

			//ikn(mat_pass)					
			{
				String condition = reference.getMatPassCondition();
				//selectȏ/ȉ
				String value = reference.getMatPass(); //
				//ݒ肳Ă
				if (value != null && !value.equals("")) {
					StringBuffer buffer = new StringBuffer();

					//Oraclȅꍇ OR PostgreSQL̏ꍇ
					if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
						buffer.append(" ROUND((COUNT(DISTINCT(CASE WHEN lg.passday IS NOT NULL THEN '1' || l.ChildID END)) * 100 / ");
					//SQLServeȑꍇ
					} else if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )) {
						buffer.append(" ROUND((COUNT(DISTINCT(CASE WHEN lg.passday IS NOT NULL THEN '1' + l.ChildID END)) * 100 / ");	
					}			
					buffer.append(loCount);
					buffer.append(" ),0) >= ");
					buffer.append(getPercentMin(value, condition));
					buffer.append(" AND ");

					//Oraclȅꍇ OR PostgreSQL̏ꍇ
					if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
						buffer.append(" ROUND((COUNT(DISTINCT(CASE WHEN lg.passday IS NOT NULL THEN '1' || l.ChildID END)) * 100 / ");				
					//SQLServeȑꍇ
					} else if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )) {
						buffer.append(" ROUND((COUNT(DISTINCT(CASE WHEN lg.passday IS NOT NULL THEN '1' + l.ChildID END)) * 100 / ");
					}
					buffer.append(loCount);
					buffer.append("),0) <= ");
					buffer.append(getPercentMax(value, condition));
					list.add(buffer.toString());
				}
			}

			//ŐV_(mat_newest_score)					
			{
				String condition = reference.getMatNewestScoreCondition();
				//selectȏ/ȉ
				String value = reference.getMatNewestScore(); //
				//ݒ肳Ă
				if (value != null && !value.equals("")) {
					StringBuffer buffer = new StringBuffer();
					//buffer.append(
					//	" ROUND(MAX(lg.execise_point) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),0)  >= ");

					//PostgreSQL̏ꍇ
					if(objEnv.getDBType().equals( objEnv.DB_POSTGRE )) {
						buffer.append(" CASE WHEN ROUND(TO_NUMBER(MAX(lg.execise_point) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),'99999999D9'),0) IS NULL ");
						buffer.append(" THEN 0 ELSE ROUND(TO_NUMBER(MAX(lg.execise_point) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),'99999999D9'),0) END >= ");
						buffer.append(getPercentMin(value, condition));
						buffer.append(" AND ");
						//buffer.append(
						//	"ROUND(MAX(lg.execise_point) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),0)  <= ");
						buffer.append(" CASE WHEN ROUND(TO_NUMBER(MAX(lg.execise_point) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),'99999999D9'),0) IS NULL ");
						buffer.append(" THEN 0 ELSE ROUND(TO_NUMBER(MAX(lg.execise_point) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),'9999999D9'),0) END <= ");
						buffer.append(getPercentMax(value, condition));
					//Oraclȅꍇ OR SQLServeȑꍇ
					} else if (objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_SQLSERVER )) {
						buffer.append(" CASE WHEN ROUND(MAX(lg.execise_point) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),0) IS NULL ");
						buffer.append(" THEN 0 ELSE ROUND(MAX(lg.execise_point) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),0) END >= ");
						buffer.append(getPercentMin(value, condition));
						buffer.append(" AND ");
						//buffer.append(
						//	"ROUND(MAX(lg.execise_point) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),0)  <= ");
						buffer.append(" CASE WHEN ROUND(MAX(lg.execise_point) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),0) IS NULL ");
						buffer.append(" THEN 0 ELSE ROUND(MAX(lg.execise_point) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),0) END <= ");
						buffer.append(getPercentMax(value, condition));						
					}
					list.add(buffer.toString());
				}
			}
			//ō_(mat_high_score)					
			{
				String condition = reference.getMatHighScoreCondition();
				//selectȏ/ȉ
				String value = reference.getMatHighScore(); //
				//ݒ肳Ă
				if (value != null && !value.equals("")) {
					StringBuffer buffer = new StringBuffer();

					//PostgreSQL̏ꍇ
					if(objEnv.getDBType().equals( objEnv.DB_POSTGRE )) {					
						buffer.append(" CASE WHEN ROUND(TO_NUMBER(MAX(lg.highScore) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),'99999999D9'),0) IS NULL ");
						buffer.append(" THEN 0 ELSE ROUND(TO_NUMBER(MAX(lg.highScore) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),'99999999D9'),0) END >= ");
						buffer.append(getPercentMin(value, condition));
						buffer.append(" AND ");
						buffer.append(" CASE WHEN ROUND(TO_NUMBER(MAX(lg.highScore) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),'99999999D9'),0) IS NULL ");
						buffer.append(" THEN 0 ELSE ROUND(TO_NUMBER(MAX(lg.highScore) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),'99999999D9'),0) END <= ");
						buffer.append(getPercentMax(value, condition));
					//Oraclȅꍇ OR SQLServeȑꍇ
					} else if (objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_SQLSERVER )) {
						buffer.append(" CASE WHEN ROUND(MAX(lg.highScore) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),0) IS NULL ");
						buffer.append(" THEN 0 ELSE ROUND(MAX(lg.highScore) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),0) END >= ");
						buffer.append(getPercentMin(value, condition));
						buffer.append(" AND ");
						buffer.append(" CASE WHEN ROUND(MAX(lg.highScore) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),0) IS NULL ");
						buffer.append(" THEN 0 ELSE ROUND(MAX(lg.highScore) * 100/(CASE WHEN MAX(lg.fullScore) = 0 THEN NULL ELSE MAX(lg.fullScore) END),0) END <= ");
						buffer.append(getPercentMax(value, condition));						
					}
					list.add(buffer.toString());
				}
			}

			//Ґ(user_complete_condition)							
			{
				String condition = reference.getUserCompleteCondition();
				//selectȏ/ȉ
				String value = reference.getUserComplete(); 
				//ݒ肳Ă
				if (value != null && !value.equals("")) {
					StringBuffer buffer = new StringBuffer();
					buffer.append(
					" ROUND((COUNT(lg.study_end_date) * 100 / ");
					buffer.append(userCount);
					buffer.append(" ),0) >= ");
					buffer.append(getPercentMin(value, condition));
					buffer.append(" AND ");
					buffer.append(
					" ROUND((COUNT(lg.study_end_date) * 100 / ");
					buffer.append(userCount);
					buffer.append(" ),0) <= ");
					buffer.append(getPercentMax(value, condition));
					list.add(buffer.toString());
				}

			}

			//iҐ(user_pass)							
			{
				String condition = reference.getUserPassCondition();
				//selectȏ/ȉ
				String value = reference.getUserPass(); //
				//ݒ肳Ă
				if (value != null && !value.equals("")) {
					StringBuffer buffer = new StringBuffer();
					buffer.append(
					" ROUND((COUNT(lg.passday) * 100 / ");
					buffer.append(userCount);
					buffer.append(" ),0) >= ");
					buffer.append(getPercentMin(value, condition));
					buffer.append(" AND ");
					buffer.append(
					" ROUND((COUNT(lg.passday) * 100 / ");
					buffer.append(userCount);
					buffer.append(" ),0) <= ");
					buffer.append(getPercentMax(value, condition));
					list.add(buffer.toString());
				}
			}

			//(complete_condition)
			String completeCondition = reference.getCompleteCondition();
			//i(pass_condition)					
			String passCondition = reference.getPassCondition();

			if (completeCondition == null || completeCondition.equals("")) {
				//wȂȂ̂łȂɂȂ
			} else if (
				completeCondition.equals(
					LoLogConstant.DEF_COMPLETE_PASS_RES_o)) {
				//Xe[^X uv
				StringBuffer buffer = new StringBuffer();
				//Oraclȅꍇ OR PostgreSQL̏ꍇ
				if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
					buffer.append(" MAX(CASE WHEN lg.study_end_date IS NOT NULL THEN '1' || l.ChildID END) IS NOT NULL  ");
				//SQLServeȑꍇ
				} else if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )) {
					buffer.append(" MAX(CASE WHEN lg.study_end_date IS NOT NULL THEN '1' + l.ChildID END) IS NOT NULL  ");
				}				
				list.add(buffer.toString());

			} else {
				//Xe[^X uv	
				StringBuffer buffer = new StringBuffer();

				//Oraclȅꍇ OR PostgreSQL̏ꍇ
				if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
					buffer.append(" MAX(CASE WHEN lg.study_end_date IS NOT NULL THEN '1' || l.ChildID END) IS NULL  ");
				//SQLServeȑꍇ
				} else if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )) {
					buffer.append(" MAX(CASE WHEN lg.study_end_date IS NOT NULL THEN '1' + l.ChildID END) IS NULL  ");
				}					
				list.add(buffer.toString());
			}
			if (passCondition == null || passCondition.equals("")) {
				//wȂȂ̂łȂɂȂ
			} else if (
				passCondition.equals(LoLogConstant.DEF_PASS_PASS_RES_o)) {
				//iXe[^X uiv
				StringBuffer buffer = new StringBuffer();

				//Oraclȅꍇ OR PostgreSQL̏ꍇ
				if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
					buffer.append(" MAX(CASE WHEN lg.passday IS NOT NULL THEN '1' || l.ChildID END) IS NOT NULL  ");
				//SQLServeȑꍇ
				} else if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )) {
					buffer.append(" MAX(CASE WHEN lg.passday IS NOT NULL THEN '1' + l.ChildID END) IS NOT NULL  ");
				}
				list.add(buffer.toString());

			} else {
				//iXe[^X uiv
				StringBuffer buffer = new StringBuffer();

				//Oraclȅꍇ OR PostgreSQL̏ꍇ
				if(objEnv.getDBType().equals( objEnv.DB_ORACLE ) || objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
					buffer.append(" MAX(CASE WHEN lg.passday IS NOT NULL THEN '1' || l.ChildID END) IS NULL  ");
				//SQLServeȑꍇ
				} else if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER )) {
					buffer.append(" MAX(CASE WHEN lg.passday IS NOT NULL THEN '1' + l.ChildID END) IS NULL  ");
				}
				list.add(buffer.toString());
			}

			//O[sOSQL̍쐬
			for(int i=0;i<list.size();i++){
				sql.append(" AND ");						
				sql.append(list.get(i));
			}

		} catch (XmsException e) {
			throw e;
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
		return sql.toString();

	}

	/**
	 * LoLogȂR[hƌɂĂ͂܂R[h\邵Ȃ̔s.
	 * 
	 * @return falsȅꍇ ɂĂ͂܂R[ĥݕ\,true ɂĂ͂܂R[h+LoLogR[hȂR[h\
	 * @exception XmsException
	 * 
	 *
	 */
	public boolean isAllDisp() throws XmsException {
		try {
			//wKJn(date_start)
			{
				//ȑOȍ~ɂ炸ݒ肳ĂΕ\Ȃ
				String value = reference.getDateStart();
				if (value != null && !value.equals("")) {
					return false;
				}
			}
			//ŏIANZX(date_last)
			{
				//ȑOȍ~ɂ炸ݒ肳ĂΕ\Ȃ
				String value = reference.getDateLast(); //
				if (value != null && !value.equals("")) {
					return false;
				}

			}

			//ANZX(total_access)
			{
				//wȂ͕\
				//1ȏ\Ȃ
				//0ȏ\
				//nȉ\
				//0܂܂ȉȉ͂肦Ȃ)			
				String condition = reference.getTotalAccessCondition();
				//selectȏ/ȉ
				String value = reference.getTotalAccess(); //
				if (value != null && !value.equals("")) {
					int intval = Integer.parseInt(value);
					if (intval >= 1 && condition.equals("0")) {
						return false;
					}

				}
			}

			//ݐϑ؍ݎ(total_learn_time)					
			{
				//wȂ͕\
				//1ȏ\Ȃ
				//0ȏ\
				//nȉ\
				//0܂܂ȉȉ͂肦Ȃ)			
				String condition = reference.getTotalLearnTimeCondition();
				//selectȏ/ȉ
				String value = reference.getTotalLearnTime(); //
				if (value != null && !value.equals("")) {
					int intval = Integer.parseInt(value);
					if (intval >= 1 && condition.equals("0")) {
						return false;
					}

				}
			}
			//LO(mat_complete)
			{
				//wȂ͕\
				//1ȏ\Ȃ
				//0ȏ\
				//nȉ\
				//0܂܂ȉȉ͂肦Ȃ)			

				String condition = reference.getMatCompleteCondition();
				//selectȏ/ȉ
				String value = reference.getMatComplete(); //
				if (value != null && !value.equals("")) {
					int intval = Integer.parseInt(value);
					if (intval >= 1 && condition.equals("0")) {
						return false;
					}

				}
			}
			//ikn(mat_pass)					
			{
				//wȂ͕\
				//1ȏ\Ȃ
				//0ȏ\
				//nȉ\
				//0܂܂ȉȉ͂肦Ȃ)			

				String condition = reference.getMatPassCondition();
				//selectȏ/ȉ
				String value = reference.getMatPass(); //
				if (value != null && !value.equals("")) {
					int intval = Integer.parseInt(value);
					if (intval >= 1 && condition.equals("0")) {
						return false;
					}

				}
			}
			//ŐV_(mat_newest_score)					
			{
				//wȂ͕\
				//1ȏ\Ȃ
				//0ȏ\
				//nȉ\
				//0܂܂ȉȉ͂肦Ȃ)			

				String condition = reference.getMatNewestScoreCondition();
				//selectȏ/ȉ
				String value = reference.getMatNewestScore(); //
				if (value != null && !value.equals("")) {
					int intval = Integer.parseInt(value);
					if (intval >= 1 && condition.equals("0")) {
						return false;
					}

				}
			}
			//ō_(mat_high_score)					
			{
				//wȂ͕\
				//1ȏ\Ȃ
				//0ȏ\
				//nȉ\
				//0܂܂ȉȉ͂肦Ȃ)			

				String condition = reference.getMatHighScoreCondition();
				//selectȏ/ȉ
				String value = reference.getMatHighScore(); //
				if (value != null && !value.equals("")) {
					int intval = Integer.parseInt(value);
					if (intval >= 1 && condition.equals("0")) {
						return false;
					}

				}
			}

			//Ґ(user_complete_condition)							
			{
				//wȂ͕\
				//1ȏ\Ȃ
				//0ȏ\
				//nȉ\
				//0܂܂ȉȉ͂肦Ȃ)			

				String condition = reference.getUserCompleteCondition();
				//selectȏ/ȉ
				String value = reference.getUserComplete(); //
				if (value != null && !value.equals("")) {
					int intval = Integer.parseInt(value);
					if (intval >= 1 && condition.equals("0")) {
						return false;
					}

				}
			}

			//iҐ(user_pass)							
			{
				//wȂ͕\
				//1ȏ\Ȃ
				//0ȏ\
				//nȉ\
				//0܂܂ȉȉ͂肦Ȃ)			

				String condition = reference.getUserPassCondition();
				//selectȏ/ȉ
				String value = reference.getUserPass(); //
				if (value != null && !value.equals("")) {
					int intval = Integer.parseInt(value);
					if (intval >= 1 && condition.equals("0")) {
						return false;
					}

				}
			}

			{
				//(complete_condition)
				String value = reference.getCompleteCondition();
				//w
				if (value != null && value.equals(LoLogConstant.DEF_COMPLETE_PASS_RES_o)) {
					return false;
				}
			} 

			{
				//i
				//i(pass_condition)					
				String value = reference.getPassCondition();
				//w
				if (value != null && value.equals(LoLogConstant.DEF_PASS_PASS_RES_o)) {
					return false;
				}
			} 

			return true;
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	/**
	 * tŏt̎擾.
	 * 
	 * @param value `FbN镶
	 * @param condition ȑOȍ~[0ȍ~,1ȑO]
	 * @return valueݒ肳ĂȂꍇA߂ꂽŏtԋp
	 * @exception XmsException
	 * 
	 */
	private String getDateMin(String value, String condition)
		throws XmsException {
		try {
			if (value != null
				&& !value.equals("")
				&& condition != null
				&& condition.equals("0")) {
				return value;
			} else {
				return LoLogConstant.DEF_DATE_MIN_o;
			}
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	/**
	 * tőt̎擾.
	 *
	 * @param value `FbN镶
	 * @param condition ȑOȍ~[0ȍ~,1ȑO]
	 * @return valueݒ肳ĂȂꍇA߂ꂽőtԋp
	 * @exception XmsException
	 * 
	 */
	private String getDateMax(String value, String condition)
		throws XmsException {
		try {
			if (value != null
				&& !value.equals("")
				&& condition != null
				&& condition.equals("1")) {
				return value + LoLogConstant.MAX_TIME;
			} else {
				return LoLogConstant.DEF_DATE_MAX_o;
			}
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	/**
	 * tŏt̎擾(INDBp).
	 * 
	 * @param value `FbN镶
	 * @param condition ȑOȍ~[0ȍ~,1ȑO]
	 * @return valueݒ肳ĂȂꍇA߂ꂽŏtԋp
	 * @exception XmsException
	 * 
	 */
	private String getDateMinForOracle(String value, String condition)
		throws XmsException {
		try {
			if ((value != null
				&& !value.equals("")
				&& condition != null
				&& condition.equals("0")) == false) {

				value = LoLogConstant.DEF_DATE_MIN_o;
			}								

			return changeToDate(value + LoLogConstant.MIN_TIME);			

		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	/**
	 * tőt̎擾(INDBp).
	 *
	 * @param value `FbN镶
	 * @param condition ȑOȍ~[0ȍ~,1ȑO]
	 * @return valueݒ肳ĂȂꍇA߂ꂽőtԋp
	 * @exception XmsException
	 * 
	 */
	private String getDateMaxForOracle(String value, String condition)
		throws XmsException {
		try {
			if ((value != null
				&& !value.equals("")
				&& condition != null
				&& condition.equals("1")) == false) {
				
				value = LoLogConstant.DEF_DATE_MAX_o;
			}

			return changeToDate(value + LoLogConstant.MAX_TIME);	

		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	/**
	 * ttH[}bgϊ\bh(INDBp).
	 *
	 * @param value `FbN镶
	 * @return to_dategpwYYYY/MM/DD HH24:MI:SSx̌`ŕԋp
	 * @exception XmsException
	 * 
	 */
	private String changeToDate(String value)
		throws XmsException,Exception {

		StringBuffer sbufResult = new StringBuffer(); 
		
		Environment objEnv = new Environment();
		//PostgreSQL̏ꍇ
		if(objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
			sbufResult.append(LoLogConstant.TO_TIMESTAMP + "('" + StringEscapeUtils.escapeSql(value) + "',");
		} else {
			sbufResult.append(LoLogConstant.TO_DATE + "('" + StringEscapeUtils.escapeSql(value) + "',");
		}
		sbufResult.append("'" + LoLogConstant.DEF_DAY_TIME + "')");
	
		return sbufResult.toString();

	}
	/**
	 * 񐔍ŏl̎擾.
	 * 
	 * @param value `FbN镶
	 * @param condition ȉȏォ[0ȏ,1ȉ]
	 * @return valueݒ肳ĂȂꍇA߂ꂽŏlԋp
	 * @exception XmsException
	 */
	private String getCountMin(String value, String condition)
		throws XmsException {
		try {
			if (value != null
				&& !value.equals("")
				&& condition != null
				&& condition.equals("0")) {
				NumberFormat.getInstance().parse(value);
				return value;
			} else {
				return LoLogConstant.DEF_COUNT_MIN_o;
			}
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	/**
	 * 񐔍ől̎擾.
	 * @param value `FbN镶
	 * @param condition ȉȏォ[0ȏ,1ȉ]
	 * @return valueݒ肳ĂȂꍇA߂ꂽőlԋp
	 * @exception XmsException
	 */
	private String getCountMax(String value, String condition)
		throws XmsException {
		try {
			if (value != null
				&& !value.equals("")
				&& condition != null
				&& condition.equals("1")) {
				NumberFormat.getInstance().parse(value);
				return value;
			} else {
				return LoLogConstant.DEF_COUNT_MAX_o;
			}
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	/**
	 * ~ŏl̎擾.
	 * @param value `FbN镶
	 * @param condition ȉȏォ[0ȏ,1ȉ]
	 * @return valueݒ肳ĂȂꍇA߂ꂽŏlԋp
	 * @exception XmsException
	 */
	private String getMSMin(String value, String condition)
		throws XmsException {
		try {
			if (value != null
				&& !value.equals("")
				&& condition != null
				&& condition.equals("0")) {
				long min = Long.parseLong(value);
				min = min * 60000;
				return String.valueOf(min);
			} else {
				return LoLogConstant.DEF_MS_MIN_o;
			}
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	/**
	 * ~ől̎擾.
	 * @param value `FbN镶
	 * @param condition ȉȏォ[0ȏ,1ȉ]
	 * @return valueݒ肳ĂȂꍇA߂ꂽőlԋp
	 * @exception XmsException
	 */
	private String getMSMax(String value, String condition)
		throws XmsException {
		try {
			if (value != null
				&& !value.equals("")
				&& condition != null
				&& condition.equals("1")) {
				long min = Long.parseLong(value);
				min = min * 60000;
				return String.valueOf(min);
			} else {
				return LoLogConstant.DEF_MS_MAX_o;
			}
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	/**
	 * ŏl̎擾.
	 * @param value `FbN镶
	 * @param condition ȉȏォ[0ȏ,1ȉ]
	 * @return valueݒ肳ĂȂꍇA߂ꂽŏlԋp
	 * @exception XmsException
	 */
	private String getPercentMin(String value, String condition)
		throws XmsException {
		try {
			if (value != null
				&& !value.equals("")
				&& condition != null
				&& condition.equals("0")) {
				NumberFormat.getInstance().parse(value);
				return value;
			} else {
				return LoLogConstant.DEF_PERCENT_MIN_o;
			}
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}

	/**
	 * ől̎擾.
	 * @param value `FbN镶
	 * @param condition ȉȏォ[0ȏ,1ȉ]
	 * @return valueݒ肳ĂȂꍇA߂ꂽőlԋp
	 * @exception XmsException
	 */
	private String getPercentMax(String value, String condition)
		throws XmsException {
		try {
			if (value != null
				&& !value.equals("")
				&& condition != null
				&& condition.equals("1")) {
				NumberFormat.getInstance().parse(value);
				return value;
			} else {
				return LoLogConstant.DEF_PERCENT_MAX_o;
			}
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}
	}


	/**
	 * Returns the action.
	 * @return int
	 */
	public int getAction() {
		return action;
	}

	/**
	 * Returns the groupIdList.
	 * @return List
	 */
	public List getGroupIdList() {
		return groupIdList;
	}

	/**
	 * Returns the isFirst.
	 * @return boolean
	 */
	public boolean isFirst() {
		return isFirst;
	}

	/**
	 * Returns the loCount.
	 * @return int
	 */
	public int getLoCount() {
		return loCount;
	}

	/**
	 * Returns the loId.
	 * @return String
	 */
	public String getLoId() {
		return loId;
	}

	/**
	 * Returns the loIdList.
	 * @return List
	 */
	public List getLoIdList() {
		return loIdList;
	}

	/**
	 * Returns the reference.
	 * @return LoLogLearnStatusParam
	 */
	public LoLogLearnStatusParam getReference() {
		return reference;
	}

	/**
	 * Returns the userCount.
	 * @return int
	 */
	public int getUserCount() {
		return userCount;
	}

	/**
	 * Returns the userId.
	 * @return String
	 */
	public String getUserId() {
		return userId;
	}

	/**
	 * Sets the action.
	 * @param action The action to set
	 */
	public void setAction(int action) {
		this.action = action;
	}

	/**
	 * Sets the groupIdList.
	 * @param groupIdList The groupIdList to set
	 */
	public void setGroupIdList(List groupIdList) {
		this.groupIdList = groupIdList;
	}

	/**
	 * Sets the isFirst.
	 * @param isFirst The isFirst to set
	 */
	public void setIsFirst(boolean isFirst) {
		this.isFirst = isFirst;
	}

	/**
	 * Sets the loCount.
	 * @param loCount The loCount to set
	 */
	public void setLoCount(int loCount) {
		this.loCount = loCount;
	}

	/**
	 * Sets the loId.
	 * @param loId The loId to set
	 */
	public void setLoId(String loId) {
		this.loId = loId;
	}

	/**
	 * Sets the loIdList.
	 * @param loIdList The loIdList to set
	 */
	public void setLoIdList(List loIdList) {
		this.loIdList = loIdList;
	}

	/**
	 * Sets the reference.
	 * @param reference The reference to set
	 */
	public void setReference(LoLogLearnStatusParam reference) {
		this.reference = reference;
	}

	/**
	 * Sets the userCount.
	 * @param userCount The userCount to set
	 */
	public void setUserCount(int userCount) {
		this.userCount = userCount;
	}

	/**
	 * Sets the userId.
	 * @param userId The userId to set
	 */
	public void setUserId(String userId) {
		this.userId = userId;
	}

	/**
	 * Returns the belonggroupid.
	 * @return String
	 */
	public String getBelonggroupid() {
		return belonggroupid;
	}

	/**
	 * Sets the belonggroupid.
	 * @param belonggroupid The belonggroupid to set
	 */
	public void setBelonggroupid(String belonggroupid) {
		this.belonggroupid = belonggroupid;
	}

}
