/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	ʃCAEgǗNX
//
//		ύX
//			2005.02.19  VK쐬   
//
//	@\
//
//	̃NX͉ʃCAEgǗNXłB
//
////////////////////////////////////////////////////////////////

package jp.co.ntt.lms.xmf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;


/**
 *  ʃCAEgǗNX
 * 
 *  ̃NX͉ʃCAEgǗNXłB
 * 
 *  @author  
 *  @version 1.0
 */
public class CustomLayoutManager
{
	/**
	 * [U[`̐ݒ
	 */
	public static final int RESULT_USERDEF = 0;

	/**
	 * O[v`̐ݒ
	 */
	public static final int RESULT_GROUPDEF = 1;

	/**
	 * ftHg`̐ݒ
	 */
	public static final int RESULT_DEFAULTDEF = 2;

	/**
	 * G[
	 */
	public static final int RESULT_ERROR = 3;

	private FrameLayout topFrame;

	private FrameLayout leftFrame;

	private FrameLayout contentFrame;

	/**
	 * 
	 * ftHg̐ݒǂݍށB
	 * 
	 * @param servletContext T[ubgReLXg
	 * @return ǂݍ݌ʂ\l
	 * 			2 - I
	 *          3 - ُI
	 */
	public int loadDefaultDef(ServletContext servletContext)
	{
		return loadDef(servletContext, "", "");
	}

	/**
	 * 
	 * w肵[U[IDƃO[vID Ɋ֘AtꂽݒǂݍށB
	 * ȉ̏ɐݒ肪݂΁A㏑Ď擾B
	 * ftHg`̃CAEgݒ
	 * O[v`̃CAEgݒ
	 * [U[`̃CAEgݒ
	 * 
	 * @param servletContext T[ubgReLXg
	 * @param userId [U[ID
	 * @param groupId O[vID
	 * @return ǂݍ݌ʂl
	 * 			0 - [U[`̃CAEgݒǂݍݐI
	 * 			1 - O[v`̃CAEgݒǂݍݐI
	 * 			2 - ftHg`̃CAEgݒǂݍݐI
	 * 			3 - ُI
	 */
	public int loadDef(ServletContext servletContext, String userId,
			String groupId)
	{
		return loadDef(servletContext,
				getBaseDirKey(), userId, groupId);
	}

	private String getBaseDirKey()
	{
		return "jp.co.ntt.lms.xmf.customizeview.basedir";
	}
	
	/**
	 * 
	 * t[\邩ǂ̃tO擾B
	 * 
	 * @return t[\邩ǂ̃tO
	 */
	public boolean isTopFrameVisible()
	{
		return (topFrame != null);
	}
	
	/**
	 * 
	 * t[\邩ǂ̃tO擾B
	 * 
	 * @return t[\邩ǂ̃tO
	 */
	public boolean isLeftFrameVisible()
	{
		return (leftFrame != null);
	}
	
	/**
	 * t[̃CAEg擾B
	 * 
	 * @return t[̃CAEg
	 */
	public FrameLayout getTopFrame()
	{
		return topFrame;
	}

	/**
	 * t[̃CAEg擾B
	 * 
	 * @return t[̃CAEg
	 */
	public FrameLayout getLeftFrame()
	{
		return leftFrame;
	}

	/**
	 * Rect[̃CAEg擾B
	 * 
	 * @return Rect[̃CAEg
	 */
	public FrameLayout getContentFrame()
	{
		return contentFrame;
	}

	protected int loadDef(ServletContext servletContext, String baseDirKey,
			String userId, String groupId)
	{
		int result = RESULT_ERROR;
		DocumentBuilder parser = null;
		String baseDir = null;
		try
		{
			parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			baseDir = servletContext.getInitParameter(baseDirKey);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return result;
		}
		if (baseDir == null)
		{
			return result;
		}
		else
		{
			if (!baseDir.endsWith("/"))
			{
				baseDir = baseDir.concat("/");
			}
		}
		try
		{
			//ftHg`̓ǂݍ
			loadDefaultDef(parser, servletContext, baseDir, userId, groupId);
			result = RESULT_DEFAULTDEF;
			if (userId == null) userId = "";
			if (groupId == null) groupId = "";
			if (userId.length() == 0 && groupId.length() == 0) { return result; }
			//O[v`̓ǂݍ
			loadGroupDef(parser, servletContext, baseDir, userId, groupId);
			result = RESULT_GROUPDEF;
			//[U[`̓ǂݍ
			loadUserDef(parser, servletContext, baseDir, userId, groupId);
			result = RESULT_USERDEF;
		}
		catch (IOException ex1)
		{
			switch (result)
			{
			case 3:
				//ftHg`ǂݍݎɃG[
				//ُIƂ
				break;
			case 2:
				//O[v`ǂݍݎɃG[
				try
				{
					//[U[`̓ǂݍ
					loadUserDef(parser, servletContext, baseDir, userId,
							groupId);
					result = RESULT_USERDEF;
				}
				catch (SAXException ex)
				{
					ex.printStackTrace();
					result = RESULT_ERROR;
				}
				catch (IOException ex)
				{
					//O[v`[U[`ȂB
				}
				break;
			case 1:
				break;
			}
		}
		catch (SAXException e)
		{
			e.printStackTrace();
			result = 3;
		}
		return result;
	}

	protected void loadDefaultDef(DocumentBuilder parser,
			ServletContext servletContext, String baseDir, String userId,
			String groupId) throws SAXException, IOException
	{
		//ftHg`̓ǂݍ
		loadFrames(parser, servletContext
				.getResourceAsStream(makeDefaultCLDPath(baseDir)));
	}

	protected void loadGroupDef(DocumentBuilder parser,
			ServletContext servletContext, String baseDir, String userId,
			String groupId) throws SAXException, IOException
	{
		loadFrames(parser, servletContext
				.getResourceAsStream(makeGroupCLDPath(baseDir, groupId)));
	}

	protected void loadUserDef(DocumentBuilder parser,
			ServletContext servletContext, String baseDir, String userId,
			String groupId) throws SAXException, IOException
	{
		loadFrames(parser, servletContext
				.getResourceAsStream(makeUserCLDPath(baseDir, userId)));
	}

	private String makeUserCLDPath(String baseDir, String userId)
	{
		if (userId.length() > 0)
		{
			return baseDir + "/users/" + userId + "/user.cld";
		}
		else
		{
			return baseDir + "/users/default.cld";
		}
	}

	private String makeGroupCLDPath(String baseDir, String groupId)
	{
		if (groupId.length() > 0)
		{
			return baseDir + "/groups/" + groupId + "/group.cld";
		}
		else
		{
			return baseDir + "/groups/default.cld";
		}
	}

	private String makeDefaultCLDPath(String baseDir)
	{
		return baseDir + "default.cld";
	}

	private void loadFrames(DocumentBuilder parser, InputStream is)
			throws SAXException, IOException
	{
		Node document = parser.parse(new InputSource(is));
		Node root = document.getFirstChild();
		List list = NodeUtil.getNamedChildElementList(root, "frame");
		for (int i = 0; i < list.size(); i++)
		{
			Node node = (Node) list.get(i);
			if ("top".equals(NodeUtil.getAttribute(node, "name")))
			{
				topFrame = new FrameLayout();
				topFrame.loadLayout(node);
			}
			if ("left".equals(NodeUtil.getAttribute(node, "name")))
			{
				leftFrame = new FrameLayout();
				leftFrame.loadLayout(node);
			}
			if ("content".equals(NodeUtil.getAttribute(node, "name")))
			{
				contentFrame = new FrameLayout();
				contentFrame.loadLayout(node);
			}
		}

	}

	/**
	 * w肳ꂽ Document IuWFNgftHg`ƂĕۑB
	 * 
	 * @param servletContext T[ubgReLXg
	 * @param document XML hLg
	 * @throws Exception
	 */
	public void saveDefaultDef(ServletContext servletContext, Document document) throws Exception
	{
		String baseDir = servletContext.getInitParameter(getBaseDirKey());
		if (!baseDir.endsWith("/"))
		{
			baseDir += "/";
		}
		String path = servletContext.getRealPath(makeDefaultCLDPath(baseDir));
		
		File target = new File(path);
		FileOutputStream file = new FileOutputStream(target);
		
		TransformerFactory tff = TransformerFactory.newInstance();
		Transformer tf = tff.newTransformer();
		tf.setOutputProperty(OutputKeys.INDENT, "yes");
		DOMSource source = new DOMSource();
		source.setNode(document.getDocumentElement());
		StreamResult result = new StreamResult();
		result.setOutputStream(file);
		tf.transform(source, result);
		file.flush();
		file.close();
	}
}