<?xml version="1.0" encoding="Windows-31J"?>
<!--
//
// CopyRight (C) 2003, NTT All rights reserved.
//
//	DefaultContentsMenu.xsl
//
//			ύX
//				2003.02.01	VK쐬
//
//	@\
//  ftHgڎ쐬xsl
//
-->
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:java="http://xml.apache.org/xslt/java"
	version="1.0">

	<xsl:include href="Common.xsl"/>

	<xsl:output
		method="html"
		doctype-public="-//W3C//DTD HTML 4.0//EN"
		doctype-system="http://www.w3.org/TR/REC-html40/strict.dtd"
		encoding="Windows-31J"
		indent="yes"
		media-type="text/html"
		version="4.0"/>

	<xsl:variable name="BaseURL" select="ContentsMenu/ContentsInformation/BaseURL/text()"/>
	<xsl:variable name="ScriptURL" select="ContentsMenu/ContentsInformation/ScriptURL/text()"/>

	<xsl:template match="/">
		<!-- html^Ȍo -->
		<html>
			<!-- head^Ȍo -->
			<head>
				<title><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;Titles/Title[@id='ContentsMenu']&quot;)"/></title>
				<script language="JavaScript" src="{$ScriptURL}"/>
				<xsl:call-template name="createLMSScript">
					<xsl:with-param name="mode" select="'ContentsMenu'"/>
				</xsl:call-template>
				<script>
				<![CDATA[
				function expandInternal(name, method, allTr, allInput)
				{
					if (method) {
						var i;

						for (i = 0; i < allTr.length; i++) {
							if (allTr[i].getAttribute("_parent") == name) {
								allTr[i].style.display = "none";
								expandInternal(allTr[i].getAttribute("_self"), true, allTr, allInput);
							}
						}
					}
					else {
						var i, j;

						for (i = 0; i < allTr.length; i++) {
							if (allTr[i].getAttribute("_parent") == name) {
								for (j = 0; j < allInput.length; j++) {
									if (allInput[j].getAttribute("_self") == name) {
										if (allInput[j].value == "-") {
											if (allTr[i].getAttribute("_visible") == "true") {
												allTr[i].style.display = "block";
											}
											expandInternal(allTr[i].getAttribute("_self"), false, allTr, allInput);
											break;
										}
									}
								}
							}
						}
					}
				}

				function expand(object, name)
				{
					var allTr = document.getElementsByTagName("tr");
					var allInput = document.getElementsByTagName("input");

					if (object.value == "-") {
						object.value = "+";
						expandInternal(name, true, allTr, allInput);
					}
					else {
						object.value = "-";
						expandInternal(name, false, allTr, allInput);
					}
				}
				]]>
				</script>
			</head>

			<!-- body^Ȍo -->
			<body _lmsname="ContentsMenu" onload="javascript:LMSUI_NavInitialize();" onunload="javascript:LMSUI_NavTerminate();">
				<xsl:call-template name="createLMSTags">
					<xsl:with-param name="mode" select="'ContentsMenu'"/>
				</xsl:call-template>

				<!-- css̒` -->
				<style>
					body {
						background-color: white;
						margin-left: 0;
						margin-top: 0;
						margin-bottom: 0;
						margin-right: 0;
					}

					th {
						border-width: 5px;
						border-style: solid;
						border-color: white;
						background-color: transparent;
						color: black;
						font-size: 110%;
					}

					.over {
						border-width: none;
						border-style: none;
						background-color: lightgrey;
						color: black;
					}

					.out {
						border-width: none;
						border-style: none;
						background-color: transparent;
						color: black;
					}

					.expand_button {
						border-width: 1px;
						border-style: solid;
						border-color: gray;
						background-color: whitesmoke;
						color: black;
						cursor: auto;
						font-size: 75%;
					}
				</style>

				<!-- ڎ̏o -->
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
					<!-- wb_s̏o -->
					<tr>
						<th nowrap="1"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;ContentsMenu/Header[@id='Title']&quot;)"/></th> <!-- ^Cg(N) -->
						<th nowrap="1"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;ContentsMenu/Header[@id='ActivityIsActive']&quot;)"/></th> <!-- Activity is Active (wK)-->
						<th nowrap="1"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;ContentsMenu/Header[@id='ActivityIsSuspended']&quot;)"/></th> <!-- Activity is Suspended (f) -->
						<th nowrap="1"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;ContentsMenu/Header[@id='ObjectiveSatisfiedStatus']&quot;)"/></th> <!-- ObjectiveSatisfiedStatus (i) -->
						<th nowrap="1" colspan="3"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;ContentsMenu/Header[@id='ObjectiveNormalizedMeasure']&quot;)"/></th> <!-- ObjectiveNormalizedMeasure (i) -->
						<th nowrap="1" colspan="6"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;ContentsMenu/Header[@id='ActivityAbsoluteDuration']&quot;)"/></th> <!-- ActivityAbsoluteDuration (oߎ) -->
						<th nowrap="1" colspan="6"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;ContentsMenu/Header[@id='ActivityExperiencedDuration']&quot;)"/></th> <!-- ActivityExperiencedDuration (wK) -->
						<th nowrap="1" colspan="3"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;ContentsMenu/Header[@id='ActivityAttemptCount']&quot;)"/></th> <!-- ActivityAttemptCount (wK) -->
						<th nowrap="1" colspan="3"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;ContentsMenu/Header[@id='AttemptCompletionAmount']&quot;)"/></th> <!-- AttemptCompletionAmount () -->
						<th nowrap="1"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;ContentsMenu/Header[@id='AttemptCompletionStatus']&quot;)"/></th> <!-- AttemptCompletionStatus () -->
						<th nowrap="1" colspan="6"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;ContentsMenu/Header[@id='AttemptAbsoluteDuration']&quot;)"/></th> <!-- AttemptAbsoluteDuration (oߎ) -->
						<th nowrap="1" colspan="6"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(&quot;ContentsMenu/Header[@id='AttemptExperiencedDuration']&quot;)"/></th> <!-- AttemptExperiencedDuration (wK) -->
					</tr>
					<!-- ȅo -->
					<xsl:apply-templates select="ContentsMenu/Contents/Content"/>
				</table>
			</body>
		</html>

	</xsl:template>

	<!-- ڎ̓eo͂ev[g -->
	<xsl:template match="Content">
		<xsl:variable name="onmouseover">javascript:this.className='over';</xsl:variable>
		<xsl:variable name="onmouseout">javascript:this.className='out';</xsl:variable>
		<xsl:variable name="position"><xsl:value-of select="position()"/></xsl:variable>
		<xsl:variable name="indent"><xsl:value-of select="Indent/text()"/></xsl:variable>
		<xsl:variable name="visible"><xsl:value-of select="@Visible"/></xsl:variable>
		<xsl:variable name="identifier"><xsl:value-of select="@Identifier"/></xsl:variable>
		<xsl:variable name="parentIdentifier"><xsl:value-of select="../@Identifier"/></xsl:variable>

		<tr _parent="{$parentIdentifier}" _self="{$identifier}" _visible="{$visible}">
			<xsl:attribute name="style"><xsl:choose><xsl:when test="$visible!='false'">display: block;</xsl:when><xsl:otherwise>display: none;</xsl:otherwise></xsl:choose></xsl:attribute>
			<xsl:attribute name="onmouseover"><xsl:value-of select="$onmouseover"/></xsl:attribute>
			<xsl:attribute name="onmouseout"><xsl:value-of select="$onmouseout"/></xsl:attribute>

			<!-- ^Cg(N̏o) -->
			<td nowrap="1">
				<xsl:call-template name="nbsp">
					<xsl:with-param name="count" select="$indent*3"/>
				</xsl:call-template>
				<xsl:choose>
					<xsl:when test="not(Content[@Visible!='false'])"><xsl:call-template name="nbsp"><xsl:with-param name="count" select="4"/></xsl:call-template></xsl:when>
					<xsl:otherwise><xsl:call-template name="nbsp"/><input type="button" class="expand_button" _parent="{$parentIdentifier}" _self="{$identifier}" onfocus="javascript:this.blur();" value="-" onclick="javascript:expand(this, '{$identifier}');"/><xsl:call-template name="nbsp"/></xsl:otherwise>
				</xsl:choose>

				<xsl:choose>
					<xsl:when test="Choicable/text()!='false'">
						<span style="text-decoration: underline; cursor: hand;">
							<xsl:attribute name="onclick">javascript:LMSUI_NavChoice("<xsl:value-of select="$identifier"/>");</xsl:attribute>
							<font size="+1"><xsl:if test="@Current!='false'"><font size="+1"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get('ContentsMenu/CurrentActivityMark')"/></font></xsl:if><xsl:value-of select="Title/text()"/></font>
						</span>
					</xsl:when>
					<xsl:otherwise>
						<span style="text-decoration: none; cursor: auto;">
							<font size="+1"><xsl:if test="@Current!='false'"><font size="+1"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get('ContentsMenu/CurrentActivityMark')"/></font></xsl:if><xsl:value-of select="Title/text()"/></font>
						</span>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:call-template name="nbsp"/>
			</td>
			<!-- ActivityStatus̏o -->
			<xsl:apply-templates select="ActivityStatus"/>
			<!-- TrackingInfomation̏o -->
			<xsl:apply-templates select="TrackingInformation"/>
		</tr>
		<!-- qActivity̓eo -->
		<xsl:apply-templates select="Content"/>
	</xsl:template>

	<!-- ActivityStatus̓eo͂ev[g -->
	<xsl:template match="ActivityStatus">
		<!-- ActiveIsActivȅo -->
		<xsl:call-template name="outputBoolean">
			<xsl:with-param name="value" select="Active/text()"/>
			<xsl:with-param name="baseXPath" select="'ContentsMenu/ActivityStatus/Active'"/>
		</xsl:call-template>
		<!-- ActiveIsSuspended̏o -->
		<xsl:call-template name="outputBoolean">
			<xsl:with-param name="value" select="Suspended/text()"/>
			<xsl:with-param name="baseXPath" select="'ContentsMenu/ActivityStatus/Suspended'"/>
		</xsl:call-template>
	</xsl:template>

	<!-- TrackingInfomation̓eo͂ev[g -->
	<xsl:template match="TrackingInformation">
		<!-- ObjectiveSatisfiedStatus̏o -->
		<xsl:call-template name="outputBoolean">
			<xsl:with-param name="value" select="ObjectiveSatisfiedStatus/text()"/>
			<xsl:with-param name="baseXPath" select="'ContentsMenu/TrackingInformation/ObjectiveSatisfiedStatus'"/>
		</xsl:call-template>
		<!-- ObjectiveNormalizedMeasurȅo -->
		<xsl:call-template name="outputNumber">
			<xsl:with-param name="value" select="ObjectiveNormalizedMeasure/text()"/>
			<xsl:with-param name="baseXPath" select="'ContentsMenu/TrackingInformation/ObjectiveNormalizedMeasure'"/>
			<xsl:with-param name="multiple" select="100"/>
		</xsl:call-template>
		<!-- ActivityAbsoluteDuration̏o -->
		<xsl:call-template name="outputDuration">
			<xsl:with-param name="value" select="ActivityAbsoluteDuration/text()"/>
			<xsl:with-param name="baseXPath" select="'ContentsMenu/TrackingInformation/ActivityAbsoluteDuration'"/>
		</xsl:call-template>
		<!-- ActivityExperiencedDuration̏o -->
		<xsl:call-template name="outputDuration">
			<xsl:with-param name="value" select="ActivityExperiencedDuration/text()"/>
			<xsl:with-param name="baseXPath" select="'ContentsMenu/TrackingInformation/ActivityExperiencedDuration'"/>
		</xsl:call-template>
		<!-- ActivityAttemptCount̏o -->
		<xsl:call-template name="outputNumber">
			<xsl:with-param name="value" select="ActivityAttemptCount/text()"/>
			<xsl:with-param name="baseXPath" select="'ContentsMenu/TrackingInformation/ActivityAttemptCount'"/>
			<xsl:with-param name="multiple" select="1"/>
		</xsl:call-template>
		<!-- AttemptCompletionAmount̏o -->
		<xsl:call-template name="outputNumber">
			<xsl:with-param name="value" select="AttemptCompletionAmount/text()"/>
			<xsl:with-param name="baseXPath" select="'ContentsMenu/TrackingInformation/AttemptCompletionAmount'"/>
			<xsl:with-param name="multiple" select="100"/>
		</xsl:call-template>
		<!-- AttemptCompletionStatus̏o -->
		<xsl:call-template name="outputBoolean">
			<xsl:with-param name="value" select="AttemptCompletionStatus/text()"/>
			<xsl:with-param name="baseXPath" select="'ContentsMenu/TrackingInformation/AttemptCompletionStatus'"/>
		</xsl:call-template>
		<!-- AttemptAbsoluteDuration̏o -->
		<xsl:call-template name="outputDuration">
			<xsl:with-param name="value" select="AttemptAbsoluteDuration/text()"/>
			<xsl:with-param name="baseXPath" select="'ContentsMenu/TrackingInformation/AttemptAbsoluteDuration'"/>
		</xsl:call-template>
		<!-- AttemptExperiencedDuration̏o -->
		<xsl:call-template name="outputDuration">
			<xsl:with-param name="value" select="AttemptExperiencedDuration/text()"/>
			<xsl:with-param name="baseXPath" select="'ContentsMenu/TrackingInformation/AttemptExperiencedDuration'"/>
		</xsl:call-template>
	</xsl:template>

	<!-- Booleanl ActivityStatus / TrackingInfomation ̏o -->
	<xsl:template name="outputBoolean">
		<xsl:param name="value"/>
		<xsl:param name="baseXPath"/>

		<td nowrap="1" style="text-align: center;">
			<xsl:choose>
				<xsl:when test="$value='true'"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '[@id=&quot;true&quot;]'))"/></xsl:when>
				<xsl:when test="$value='false'"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '[@id=&quot;false&quot;]'))"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '[@id=&quot;else&quot;]'))"/></xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>

	<!-- Durationl ActivityStatus / TrackingInfomation ̏o -->
	<xsl:template name="outputDuration">
		<xsl:param name="value"/>
		<xsl:param name="baseXPath"/>

		<xsl:choose>
			<xsl:when test="$value!=''">
				<td nowrap="1"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '/PreDecoration'))"/></td><td nowrap="1" style="text-align: right;"><xsl:value-of select="format-number(floor($value div 3600000), '#')"/><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '/HourDecoration'))"/></td><td nowrap="1" style="text-align: right;"><xsl:value-of select="format-number(floor(($value mod 3600000) div 60000), '00')"/><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '/MinutesDecoration'))"/></td><td nowrap="1" style="text-align: right;"><xsl:value-of select="format-number(floor(($value mod 60000) div 1000), '00')"/><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '/SecondsDecoration'))"/></td><td nowrap="1" style="text-align: right;"><xsl:value-of select="format-number($value mod 1000, '000')"/><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '/MillSecondsDecoration'))"/></td><td nowrap="1"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '/PostDecoration'))"/></td>
			</xsl:when>
			<xsl:otherwise><td colspan="6" nowrap="1" style="text-align: center;"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '/None'))"/></td></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- l ActivityStatus / TrackingInfomation ̏o -->
	<xsl:template name="outputNumber">
		<xsl:param name="value"/>
		<xsl:param name="baseXPath"/>
		<xsl:param name="multiple"/>

		<xsl:choose>
			<xsl:when test="$value!=''">
				<td nowrap="1"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '/PreDecoration'))"/></td><td nowrap="1" style="text-align: right;"><xsl:value-of select="format-number($value * $multiple, java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '/Format')))"/></td><td nowrap="1" style="text-align: left;"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '/PostDecoration'))"/></td>
			</xsl:when>
			<xsl:otherwise><td nowrap="1" colspan="3" style="text-align: center;"><xsl:value-of select="java:jp.co.ntt.lms.lo.scorm.util.Message.get(concat($baseXPath, '/None'))"/></td></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
