/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	LOiۃNX
//
//		ύX
//			2005.01.31  VK쐬  Katsuhiko.Sakurai(UNITEC)
//
//	@\
//
//	̃NXLO̐i\钊ۃNXłB
//
////////////////////////////////////////////////////////////////

package jp.co.ntt.lms.lo.progress;

import jp.co.ntt.lms.lo.progress.util.LearningProgressConfigurationManager;
import jp.co.ntt.lms.lo.progress.util.XMOInformationGetter;
import jp.co.ntt.lms.xmo.Lo.LoClient;


/**
 * LOiۃNXłB
 * 
 * LOKw\R|Wbgp^[Ŏ܂B
 * 
 * @author Katsuhiko Sakurai (UNITEC)
 * @version 1.0
 */
public abstract class AbstractLOProgress implements XMOProgress {

	protected LoClient loClient = null;
	protected LearningProgress progress = null;
	protected int level = 0;

	/**
	 * RXgN^łB
	 * 
	 * @param loID ΏۂƂȂLoID 
	 * @param targetUserID ΏۂƂȂ郆[UEO[vID 
	 * @param level Kw̃x 
	 * @throws Exception
	 */
	public AbstractLOProgress(String loID, String targetUserID, int level) throws Exception {
		this(loID, targetUserID, level, new LearningProgressConfigurationManager());
	}
	
	/**
	 * RXgN^łB
	 * 
	 * @param loID ΏۂƂȂLoID 
	 * @param targetUserID ΏۂƂȂ郆[UEO[vID 
	 * @param level Kw̃x 
	 * @param config Oݒt@C 
	 * @throws Exception
	 */
	public AbstractLOProgress(String loID, String targetUserID, int level, 
			LearningProgressConfigurationManager config) throws Exception {
		
		//loIDLONCAg擾
		this.loClient = XMOInformationGetter.getLO(loID);
		
		// iݒ
		this.progress = this.getProgress(loID, targetUserID, config);
		
		// xݒ
		this.level = level;
	}
	
	/**
	 * q̐iǉ܂B
	 * 
	 * [t(ReiȊOLO)ł͂̃\bh͌Ă΂邱Ƃz肵Ȃ
	 * ftHgOoƂĂ܂B
	 *  
	 * @param xmoProgress i 
	 * @throws Exception
	 */
	public XMOProgress add(XMOProgress xmoProgress) throws Exception {
		throw new Exception();
	}
	
	/**
	 * i擾܂B
	 * 
	 * @return LearningProgress i 
	 */
	public LearningProgress getProgress() {
		return this.progress;
	}

	/**
	 * i̍ږ̂擾܂B
	 * 
	 * @return String LO̖ 
	 */
	public String getItemName() {
		return this.loClient.getLoTytle();
	}

	/**
	 * Kw̃x擾܂B
	 * 
	 * @return int Kw̃x 
	 */
	public int getLevel() {
		return this.level;
	}

	/**
	 * Kwxtꂽږ擾܂B
	 * 
	 * @return String KwxtꂽLO 
	 */
	public String getNestedItemName() {
		String space = "@";
		for(int i=1; i<=this.level; i++) space += space;
		
		return space + this.getItemName();
	}

	/**
	 * LO̐擾܂B
	 * 
	 * @return String LO̐ 
	 */
	public String getExplanation() {
		return this.loClient.getLoExplanation();
	}
	
	/**
	 * i擾܂B
	 * 
	 * @param loID ΏۂƂȂLoID
	 * @param targetUserID ΏۂƂȂ郆[UID
	 * @param config ݒt@C
	 * @return LearningProgress i
	 * @throws Exception@
	 */
	protected LearningProgress getProgress( String loID, String targetUserID, 
					LearningProgressConfigurationManager config ) throws Exception {
		return new LearningProgress(targetUserID, loID, config);
	}
}
