/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

package jp.co.ntt.lms.Common.RDF1;

import java.util.Vector;
import org.w3c.dom.*;


/**
 * RDFp[X@[eBeBNX
 * @author T.Nijou
 * @version 0.0.0.1 2004/01/08
 */
public class RDFUtility {

	/**
	 * w肳ꂽID<rdf: Descriptioin>m[h܂B
	 * @param objNode Ώۃm[h
	 * @param strID ID
	 * @return Node ʃm[h
	 */
	public static Node searchDescritionNode( Node objNode, String strID ) {

		if( objNode == null ) {
			return null;
		}

		if( strID.equals( getAttribute( objNode, "ID" ) ) ) {
			return objNode;
		}

		NodeList objList = objNode.getChildNodes();
		if( objList != null ) {

			for( int i = 0; i < objList.getLength(); i++ ) {
				if( objList.item(i).getNodeType() != Node.TEXT_NODE &&
					objList.item(i).getNodeType() != Node.CDATA_SECTION_NODE ) {
					Node objResult = searchDescritionNode( objList.item(i), strID );
					if( objResult != null ) {
						return objResult;
					}
				}
			}
		}

		return null;

	}

	/**
	 * NodeIuWFNgw肳ꂽID̃Agr[g擾܂
	 * @param objNode NodeIuWFNg
	 * @param strAttrID Agr[gID
	 * @return String 擾l w肳ꂽID̃Agr[g݂ȂꍇnullԂ
	 */
	public static String getAttribute( Node objNode, String strAttrID ) {

		if( objNode == null ) {
			return null;
		}

		NamedNodeMap objMap = objNode.getAttributes();
		if( objMap == null ) {
			return null;
		}
		Attr objAttr = (Attr)objMap.getNamedItem( strAttrID );
		if( objAttr == null ) {
			return null;
		}
		return objAttr.getValue().trim();
	}

	/**
	 * m[h̎qm[hw肳ꂽ̂̃m[h
	 * @param objNode NodeIuWFNg
	 * @param strName 
	 * @return Node  Ȃꍇnull
	 */
	public static Node searchNodeName( Node objNode, String strName ) {

		if( objNode == null ) {
			return null;
		}

		if( objNode.getNodeName().equals( strName ) ) {
			return objNode;
		}

		NodeList objList = objNode.getChildNodes();
		if( objList != null ) {

			for( int i = 0; i < objList.getLength(); i++ ) {
				if( objList.item(i).getNodeType() != Node.TEXT_NODE &&
					objList.item(i).getNodeType() != Node.CDATA_SECTION_NODE ) {
					Node objResult = searchNodeName( objList.item(i), strName );
					if( objResult != null ) {
						return objResult;
					}
				}
			}
		}

		return null;
	}

	/**
	 * m[hIuWFNg̃eLXg擾郁\bhł
	 * @param objNode Ώۃm[h
	 * @return String eLXg 擾łȂꍇ͋󕶎Ԃ܂
	 */
	public static String getText( Node objNode ) {

		if( objNode == null ) {
			return "";
		}

		String strText = "";

		NodeList objNodeList = objNode.getChildNodes();
		if( objNodeList != null ) {
			for( int i = 0; i < objNodeList.getLength(); i++ ) {
				//#TEXTZNV
				if( objNodeList.item(i).getNodeType() == Node.TEXT_NODE ) {
					strText = objNodeList.item(i).getNodeValue().trim();
				}
			}
		}
		return strText;
	}

	/**
	 * NodeIuWFNgqm[hIDXgĕԂ܂
	 * @param objNode Ώ
	 * @return String[] IDXg Ȃꍇ́A0̔zԂ܂
	 */
	public static String[] searchChildIDList( Node objNode ) {
		// ʊi[p
		Vector vecIDList = new Vector();

		// <calat:SectionTop>̌
		Node objSectionTop = searchNodeName( objNode, "calat:SectionTop" );
		if( objSectionTop != null ) {
			// eLXg擾
			String strText = getText( objSectionTop );
			vecIDList.add( strText );
		}

		// <calat:Children>̌
		Node objChildrenNode = searchNodeName( objNode, "calat:Children" );
		if( objChildrenNode != null ) {
			String strText = getText( objChildrenNode );
			if( !strText.equals( "" ) ) {
				vecIDList.add( strText );
			}
			Node objRdSeq = searchNodeName( objChildrenNode, "rdf:Seq" );
			if( objRdSeq != null ) {
				NodeList objList = objRdSeq.getChildNodes();
				if( objList != null ) {
					for( int i = 0; i < objList.getLength(); i++ ) {
						if( objList.item(i).getNodeType() != Node.TEXT_NODE &&
							objList.item(i).getNodeType() != Node.CDATA_SECTION_NODE )
						{
							strText = getText( objList.item(i) );
							if( !strText.equals( "" ) ) {
								vecIDList.add( strText );
							}
						}
					}
				}
			}
		}

		// <calat:Element>̌
		Node objElementNode = searchNodeName( objNode, "calat:Element" );
		if( objElementNode != null ) {
			String strText = getText( objElementNode );
			if( !strText.equals( "" ) ) {
				vecIDList.add( strText );
			}
			Node objRdSeq = searchNodeName( objElementNode, "rdf:Seq" );
			if( objRdSeq != null ) {
				NodeList objList = objRdSeq.getChildNodes();
				if( objList != null ) {
					for( int i = 0; i < objList.getLength(); i++ ) {
						if( objList.item(i).getNodeType() != Node.TEXT_NODE &&
							objList.item(i).getNodeType() != Node.CDATA_SECTION_NODE )
						{
							strText = getText( objList.item(i) );
							if( !strText.equals( "" ) ) {
								vecIDList.add( strText );
							}
						}
					}
				}
			}
		}



		String[] strIDList = new String[ vecIDList.size() ];
		// zRs[
		vecIDList.copyInto( strIDList );
		return strIDList;
	}

	/**
	 * NodeIuWFNgDescriptionIDARDFNodeIuWFNg쐬܂
	 * @param objNode NodeIuWFNg
	 * @param strID ID
	 * @return RDFNode 쐬RDFNodeIuWFNg
	 */
	public static RDFNode createRDFInstance( Node objNode, String strID, RDFNode objParentNode ) {

		if( objNode == null ) {
			return null;
		}

		// IDDescriptionm[h܂
		Node objDescripNode = searchDescritionNode( objNode, strID );
		if( objDescripNode == null ) {
			return null;
		}

		RDFNode objRDFNode = new RDFNode();
		// em[h̐ݒ
		objRDFNode.setParentNode( objParentNode );
		// ID̐ݒ
		Node objTempNode = searchNodeName( objDescripNode, "calat:UID" );
		objRDFNode.setID( getText( objTempNode ) );
		// ^Cg̐ݒ
		objTempNode = searchNodeName( objDescripNode, "calat:Name" );
		objRDFNode.setTitle( getText( objTempNode ) );
		// ID̐ݒ
		objTempNode = searchNodeName( objDescripNode, "calat:MaterialCode" );
		if( objTempNode != null ) {
			objRDFNode.setMaterialID( getText( objTempNode ) );
		}
		// o[W̐ݒ
		objTempNode = searchNodeName( objDescripNode, "calat:Version" );
		if( objTempNode != null ) {
			objRDFNode.setVersion( getText( objTempNode ) );
		}
		// ^Cv̐ݒ
		try {
			if( strID.indexOf( "Element" ) > 0) {
				// AU^Cv
				objRDFNode.setNodeType( RDFNode.AU_NODE );
			}
			else if( strID.indexOf( "Sections" ) > 0 ) {
				// Block^Cv
				objRDFNode.setNodeType( RDFNode.BLOCK_NODE );
			}
			else {
				// Course^Cv
				objRDFNode.setNodeType( RDFNode.COURSE_NODE );
			}
		}
		catch( RDFUnknownNodeTypeException e ) {
			e.printStackTrace();
		}
		// qIDXg̎擾(AU^CvȊO)
		if( objRDFNode.getNodeType() != RDFNode.AU_NODE ) {
			String[] strChildIDList = searchChildIDList( objDescripNode );
			for( int i = 0; i < strChildIDList.length; i++ ) {
				objRDFNode.addChild( createRDFInstance( objNode, strChildIDList[i], objRDFNode ) );
			}
		}

		return objRDFNode;
	}

}






