/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ntt.lms.installer.lms;

import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;
import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerCheckUtil;
import jp.co.ntt.lms.installer.core.util.InstallerPropertiesUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.lms.LumpInputValue;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;

public class LumpInputAction
implements InstallerAction {
    private static Logger _logger = LoggerUtil.getLogger(class$jp$co$ntt$lms$installer$lms$LumpInputAction == null ? (class$jp$co$ntt$lms$installer$lms$LumpInputAction = LumpInputAction.class$("jp.co.ntt.lms.installer.lms.LumpInputAction")) : class$jp$co$ntt$lms$installer$lms$LumpInputAction);
    static /* synthetic */ Class class$jp$co$ntt$lms$installer$lms$LumpInputAction;

    public boolean isSkipped(InstallerValues installerValues) {
        return false;
    }

    public InstallerActionValue action(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "action(InstallerValues)");
        LumpInputValue lumpInputValue = null;
        try {
            LumpInputValue lumpInputValue2 = this.getDefaultValue(installerValues);
            InstallerUiUtil.outputMessageAsTitle(installerValues, "LumpInputAction.welcome");
            while (!this.confirmInputValue(installerValues, lumpInputValue = this.readInputValue(installerValues, lumpInputValue2))) {
            }
            File file = new File(lumpInputValue.getLumpPath());
            installerValues.addMadeDirectory(file);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "action(InstallerValues)", lumpInputValue);
        return lumpInputValue;
    }

    private LumpInputValue readInputValue(InstallerValues installerValues, LumpInputValue lumpInputValue) throws InstallerException {
        LoggerUtil.methodHead(_logger, "readInputValue(InstallerValues)");
        LumpInputValue lumpInputValue2 = null;
        try {
            lumpInputValue2 = new LumpInputValue();
            String string = null;
            while (InstallerCheckUtil.isEmptyViolation(string = InstallerUiUtil.askUserInput(installerValues, "LumpInputAction.prompt.lumpFilePath", lumpInputValue.getLumpPath()), installerValues, "LumpInputAction.error.lumpFilePath.empty") || InstallerCheckUtil.isFilePath(string, installerValues, "LumpInputAction.error.lumpFilePath.file")) {
            }
            lumpInputValue2.setLumpPath(string);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "readInputValue(InstallerValues)", lumpInputValue2);
        return lumpInputValue2;
    }

    private boolean confirmInputValue(InstallerValues installerValues, LumpInputValue lumpInputValue) throws InstallerException {
        LoggerUtil.methodHead(_logger, "confirmInputValue(InstallerValues, LumpInputValue)");
        boolean bl = false;
        try {
            InstallerUiUtil.outputConfirmTitle(installerValues, "LumpInputAction.confirm.title");
            InstallerUiUtil.outputConfirm(installerValues, "LumpInputAction.confirm.lumpFilePath", lumpInputValue.getLumpPath());
            bl = InstallerUiUtil.askUserConfirm(installerValues, "LumpInputAction.confirm");
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "confirmInputValue(InstallerValues, LumpInputValue)", bl);
        return bl;
    }

    private LumpInputValue getDefaultValue(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "getDefaultValue(InstallerValues)");
        LumpInputValue lumpInputValue = null;
        try {
            lumpInputValue = new LumpInputValue();
            File file = installerValues.getFileOnSystem(lumpInputValue.getTargetFileKey());
            Properties properties = FileUtil.loadAsProperties(file);
            Properties properties2 = InstallerPropertiesUtil.load(installerValues, lumpInputValue.getTargetFileKey());
            String string = InstallerPropertiesUtil.determineInitialValue(properties, properties2, "lump_dir");
            lumpInputValue.setLumpPath(string);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "getDefaultValue(InstallerValues)", lumpInputValue);
        return lumpInputValue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

